/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.e4.xwt.vex.contentassist.CustomTemplateProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.contentassist.ReplaceNameTemplateContext;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;

public class VEXTemplateCompletionProcessor
extends TemplateCompletionProcessor {
    private static final Comparator fgProposalComparator = new ProposalComparator();
    private String fContextTypeId = null;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        String string;
        Region region;
        TemplateContext templateContext;
        ITextSelection iTextSelection = (ITextSelection)iTextViewer.getSelectionProvider().getSelection();
        if (iTextSelection.getOffset() == n) {
            n = iTextSelection.getOffset() + iTextSelection.getLength();
        }
        if ((templateContext = this.createContext(iTextViewer, (IRegion)(region = new Region(n - (string = this.extractPrefix(iTextViewer, n)).length(), string.length())), n)) == null) {
            return new ICompletionProposal[0];
        }
        templateContext.setVariable("selection", iTextSelection.getText());
        Template[] templateArray = this.getTemplates(templateContext.getContextType().getId());
        ArrayList<ICompletionProposal> arrayList = new ArrayList<ICompletionProposal>();
        int n2 = 0;
        while (n2 < templateArray.length) {
            block6: {
                Template template = templateArray[n2];
                try {
                    templateContext.getContextType().validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    break block6;
                }
                if (template.matches(string, templateContext.getContextType().getId())) {
                    arrayList.add(this.createProposal(template, templateContext, (IRegion)region, this.getRelevance(template, string)));
                }
            }
            ++n2;
        }
        Collections.sort(arrayList, fgProposalComparator);
        return arrayList.toArray(new ICompletionProposal[arrayList.size()]);
    }

    private TemplateContext createContext(ITextViewer iTextViewer, IRegion iRegion, int n) {
        TemplateContextType templateContextType = this.getContextType(iTextViewer, iRegion);
        if (templateContextType != null) {
            IDocument iDocument = iTextViewer.getDocument();
            return new ReplaceNameTemplateContext(templateContextType, iDocument, iRegion.getOffset(), iRegion.getLength(), n);
        }
        return null;
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext templateContext, IRegion iRegion, int n) {
        return new CustomTemplateProposal(template, templateContext, iRegion, this.getImage(template), n);
    }

    protected TemplateContextType getContextType(ITextViewer iTextViewer, IRegion iRegion) {
        TemplateContextType templateContextType = null;
        ContextTypeRegistry contextTypeRegistry = this.getTemplateContextRegistry();
        if (contextTypeRegistry != null) {
            templateContextType = contextTypeRegistry.getContextType(this.fContextTypeId);
        }
        return templateContextType;
    }

    protected Image getImage(Template template) {
        return XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag-macro.gif");
    }

    private ContextTypeRegistry getTemplateContextRegistry() {
        return XMLUIPlugin.getDefault().getTemplateContextRegistry();
    }

    protected Template[] getTemplates(String string) {
        Template[] templateArray = null;
        TemplateStore templateStore = this.getTemplateStore();
        if (templateStore != null) {
            templateArray = templateStore.getTemplates(string);
        }
        return templateArray;
    }

    private TemplateStore getTemplateStore() {
        return XMLUIPlugin.getDefault().getTemplateStore();
    }

    public void setContextType(String string) {
        this.fContextTypeId = string;
    }

    private static final class ProposalComparator
    implements Comparator {
        private ProposalComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((TemplateProposal)object2).getRelevance() - ((TemplateProposal)object).getRelevance();
        }
    }
}

