/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex.palette;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.xwt.vex.EditorMessages;
import org.eclipse.e4.xwt.vex.VEXEditor;
import org.eclipse.e4.xwt.vex.palette.PalettePathRegistry;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.IEditorInput;

public class PaletteResourceManager {
    private static final String DEFAULT_PATH = EditorMessages.PaletteResourceManager_toolkit;
    private static final String DEFAULT_ICON_PATH = EditorMessages.PaletteResourceManager_icons;
    private URI resourcePath;
    private URI iconsPath;
    private Resource resource;
    private Resource dynamicResource;
    private Resource customizeResource;
    private VEXEditor host = null;

    public PaletteResourceManager(VEXEditor vEXEditor) {
        assert (this.host != null);
        this.host = vEXEditor;
    }

    public Resource getResource() {
        URI uRI;
        if (this.resource == null && (uRI = this.getResourceFile()) != null) {
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            this.resource = resourceSetImpl.getResource(uRI, true);
        }
        return this.resource;
    }

    public Resource getDynamicResource() {
        if (this.dynamicResource == null) {
            this.dynamicResource = new ResourceImpl();
        }
        return this.dynamicResource;
    }

    public Resource getCustomizeResource() {
        if (this.customizeResource == null) {
            this.customizeResource = new ResourceImpl();
        }
        return this.customizeResource;
    }

    private IProject getCurrentProject() {
        IEditorInput iEditorInput = this.host.getEditorInput();
        IFile iFile = (IFile)iEditorInput.getAdapter(IFile.class);
        IProject iProject = iFile.getProject();
        if (!iProject.exists()) {
            return null;
        }
        return iProject;
    }

    public URI getIconsPath() {
        if (this.iconsPath == null) {
            this.iconsPath = this.computeIconsPath();
        }
        return this.iconsPath;
    }

    private URI computeIconsPath() {
        String string;
        String string2;
        IProject iProject = this.getCurrentProject();
        if (iProject != null) {
            try {
                iProject.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            string2 = iProject.getFile(DEFAULT_ICON_PATH);
            if (string2.exists()) {
                return URI.createFileURI((String)string2.getLocation().toString());
            }
        }
        if (!(string = PalettePathRegistry.getIconsPath(string2 = this.host.getEditorSite().getPluginId())).startsWith("/")) {
            string = "/" + string;
        }
        return URI.createPlatformPluginURI((String)(String.valueOf(string2) + string), (boolean)false);
    }

    public URI getResourceFile() {
        if (this.resourcePath == null) {
            this.resourcePath = this.computeResourcePath();
        }
        return this.resourcePath;
    }

    private URI computeResourcePath() {
        String string;
        String string2;
        IProject iProject = this.getCurrentProject();
        if (iProject != null) {
            try {
                iProject.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            string2 = iProject.getFile(DEFAULT_PATH);
            if (string2.exists()) {
                return URI.createFileURI((String)string2.getLocation().toString());
            }
        }
        if (!(string = PalettePathRegistry.getPath(string2 = this.host.getEditorSite().getPluginId())).startsWith("/")) {
            string = "/" + string;
        }
        return URI.createPlatformPluginURI((String)(String.valueOf(string2) + string), (boolean)false);
    }

    public void saveToolDefinition() {
        IProject iProject = this.getCurrentProject();
        if (iProject != null) {
            String string = iProject.getName();
            String string2 = String.valueOf(string) + "/" + DEFAULT_PATH;
            try {
                this.resource.setURI(URI.createPlatformResourceURI((String)string2, (boolean)false));
                this.resource.save(null);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

