/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex.palette;

import java.util.List;
import org.eclipse.e4.xwt.vex.EditorMessages;
import org.eclipse.e4.xwt.vex.VEXEditor;
import org.eclipse.e4.xwt.vex.palette.EntryContentProvider;
import org.eclipse.e4.xwt.vex.palette.EntryLabelProvider;
import org.eclipse.e4.xwt.vex.palette.PaletteResourceManager;
import org.eclipse.e4.xwt.vex.palette.customize.CustomizeComponentFactory;
import org.eclipse.e4.xwt.vex.palette.customize.model.CustomizeComponent;
import org.eclipse.e4.xwt.vex.palette.part.ToolPaletteDrawer;
import org.eclipse.e4.xwt.vex.toolpalette.ContextType;
import org.eclipse.e4.xwt.vex.toolpalette.Entry;
import org.eclipse.e4.xwt.vex.toolpalette.ToolPaletteFactory;
import org.eclipse.e4.xwt.vex.util.ImageHelper;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;

public class PaletteRootFactory {
    private PaletteResourceManager trManager;

    public PaletteRootFactory(PaletteResourceManager paletteResourceManager) {
        this.trManager = paletteResourceManager;
    }

    public PaletteRoot createPaletteRoot() {
        PaletteRoot paletteRoot = new PaletteRoot();
        Resource resource = this.trManager.getResource();
        if (resource != null) {
            PaletteContainer paletteContainer = this.createShapesDrawer(resource);
            paletteRoot.addAll(paletteContainer.getChildren());
        }
        return paletteRoot;
    }

    private PaletteContainer createShapesDrawer(Resource resource) {
        PaletteDrawer paletteDrawer = this.createPaletteDrawer(EditorMessages.PaletteRootFactory_Shapes);
        if (this.trManager != null) {
            EntryContentProvider entryContentProvider = new EntryContentProvider();
            EntryLabelProvider entryLabelProvider = new EntryLabelProvider();
            this.createToolPaletteStructure(paletteDrawer, entryContentProvider, entryLabelProvider, resource);
        }
        return paletteDrawer;
    }

    private PaletteDrawer createPaletteDrawer(String string) {
        ToolPaletteDrawer toolPaletteDrawer = new ToolPaletteDrawer(string);
        toolPaletteDrawer.setInitialState(1);
        return toolPaletteDrawer;
    }

    private void createToolPaletteStructure(PaletteDrawer paletteDrawer, EntryContentProvider entryContentProvider, EntryLabelProvider entryLabelProvider, Object object) {
        ImageDescriptor imageDescriptor;
        Object[] objectArray = entryContentProvider.getElements(object);
        String string = entryLabelProvider.getText(object);
        if (string == null) {
            return;
        }
        String string2 = entryLabelProvider.getDescription(object);
        ImageDescriptor imageDescriptor2 = this.getImageDescriptor(object);
        if (imageDescriptor2 == null) {
            imageDescriptor2 = entryLabelProvider.getImageDescriptor(object);
        }
        if ((imageDescriptor = this.getLargeImageDescriptor(object)) == null) {
            imageDescriptor = entryLabelProvider.getLargeImageDescriptor(object);
        }
        if (objectArray.length == 0) {
            CombinedTemplateCreationEntry combinedTemplateCreationEntry = new CombinedTemplateCreationEntry(string, string2, object, (CreationFactory)new SimpleFactory(object.getClass()), imageDescriptor2, imageDescriptor);
            combinedTemplateCreationEntry.setDescription(string2);
            paletteDrawer.add((PaletteEntry)combinedTemplateCreationEntry);
        } else if (object instanceof Entry) {
            PaletteDrawer paletteDrawer2 = this.createPaletteDrawer(string);
            paletteDrawer2.setSmallIcon(imageDescriptor2);
            paletteDrawer2.setLargeIcon(imageDescriptor);
            paletteDrawer2.setDescription(string2);
            paletteDrawer.add((PaletteEntry)paletteDrawer2);
            paletteDrawer2.setParent((PaletteContainer)paletteDrawer);
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = objectArray2[n2];
                this.createToolPaletteStructure(paletteDrawer2, entryContentProvider, entryLabelProvider, object2);
                ++n2;
            }
        } else {
            Object[] objectArray3 = objectArray;
            int n = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object object3 = objectArray3[n3];
                this.createToolPaletteStructure(paletteDrawer, entryContentProvider, entryLabelProvider, object3);
                ++n3;
            }
        }
    }

    private ImageDescriptor getImageDescriptor(Object object) {
        if (object instanceof Entry) {
            return ImageHelper.getImageDescriptor(this.trManager, ((Entry)object).getIcon());
        }
        return null;
    }

    private ImageDescriptor getLargeImageDescriptor(Object object) {
        if (object instanceof Entry) {
            return ImageHelper.getImageDescriptor(this.trManager, ((Entry)object).getLargeIcon());
        }
        return null;
    }

    public static PaletteRoot createPalette(IEditorPart iEditorPart) {
        PaletteRoot paletteRoot = new PaletteRoot();
        if (!(iEditorPart instanceof VEXEditor)) {
            return paletteRoot;
        }
        PaletteResourceManager paletteResourceManager = (PaletteResourceManager)iEditorPart.getAdapter(PaletteResourceManager.class);
        PaletteRootFactory paletteRootFactory = new PaletteRootFactory(paletteResourceManager);
        return paletteRootFactory.createPaletteRoot();
    }

    public static PaletteRoot createPaletteByResourceManager(PaletteResourceManager paletteResourceManager) {
        PaletteRootFactory paletteRootFactory = new PaletteRootFactory(paletteResourceManager);
        return paletteRootFactory.createPaletteRoot();
    }

    public static PaletteRoot createDynamicPalette(IEditorPart iEditorPart) {
        PaletteRoot paletteRoot = new PaletteRoot();
        if (!(iEditorPart instanceof VEXEditor)) {
            return paletteRoot;
        }
        PaletteResourceManager paletteResourceManager = (PaletteResourceManager)iEditorPart.getAdapter(PaletteResourceManager.class);
        PaletteRootFactory paletteRootFactory = new PaletteRootFactory(paletteResourceManager);
        return paletteRootFactory.createDynamicPaletteRoot();
    }

    public PaletteRoot createDynamicPaletteRoot() {
        PaletteRoot paletteRoot = new PaletteRoot();
        PaletteGroup paletteGroup = new PaletteGroup(EditorMessages.VEXEditor_Dynamic);
        paletteRoot.add((PaletteEntry)paletteGroup);
        return paletteRoot;
    }

    public static PaletteRoot createCustomizePalette(IEditorPart iEditorPart) {
        PaletteRoot paletteRoot = new PaletteRoot();
        if (!(iEditorPart instanceof VEXEditor)) {
            return paletteRoot;
        }
        PaletteResourceManager paletteResourceManager = (PaletteResourceManager)iEditorPart.getAdapter(PaletteResourceManager.class);
        PaletteRootFactory paletteRootFactory = new PaletteRootFactory(paletteResourceManager);
        return paletteRootFactory.createCustomizePaletteRoot();
    }

    public PaletteRoot createCustomizePaletteRoot() {
        PaletteRoot paletteRoot = new PaletteRoot();
        PaletteGroup paletteGroup = new PaletteGroup("Customize");
        Resource resource = this.trManager.getCustomizeResource();
        if (resource != null) {
            List<CustomizeComponent> list = CustomizeComponentFactory.loadCustomizeComponents();
            for (CustomizeComponent customizeComponent : list) {
                Entry entry = ToolPaletteFactory.eINSTANCE.createEntry();
                entry.setName(customizeComponent.getName());
                entry.setScope(customizeComponent.getScope());
                String string = customizeComponent.getIcon();
                if (string != null && string.length() > 0) {
                    entry.setIcon(string);
                }
                if ((string = customizeComponent.getLargeIcon()) != null && string.length() > 0) {
                    entry.setLargeIcon(string);
                }
                entry.setToolTip(customizeComponent.getTooptip());
                entry.setContent(customizeComponent.getContent());
                entry.setContext(ContextType.XML_TAG);
                CombinedTemplateCreationEntry combinedTemplateCreationEntry = new CombinedTemplateCreationEntry(entry.getName(), entry.getToolTip(), (Object)entry, (CreationFactory)new SimpleFactory(resource.getClass()), ImageHelper.getImageDescriptor(this.trManager, entry.getIcon()), ImageHelper.getImageDescriptor(this.trManager, entry.getLargeIcon()));
                paletteGroup.add((PaletteEntry)combinedTemplateCreationEntry);
            }
        }
        paletteRoot.add((PaletteEntry)paletteGroup);
        return paletteRoot;
    }
}

