/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex.palette.customize;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.xwt.vex.Activator;
import org.eclipse.e4.xwt.vex.EditorMessages;
import org.eclipse.e4.xwt.vex.VEXEditor;
import org.eclipse.e4.xwt.vex.palette.CustomPalettePage;
import org.eclipse.e4.xwt.vex.palette.PaletteResourceManager;
import org.eclipse.e4.xwt.vex.palette.customize.model.CustomizeComponent;
import org.eclipse.e4.xwt.vex.palette.part.CustomizePaletteViewer;
import org.eclipse.e4.xwt.vex.toolpalette.Entry;
import org.eclipse.e4.xwt.vex.toolpalette.ToolPaletteFactory;
import org.eclipse.e4.xwt.vex.util.ImageHelper;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizeComponentFactory {
    private static final String CUSTOMER_COMPONENT_ROOT = "VEX_CUSTOMIZE_COMPONENT_LIST";
    private List<VEXEditor> allVEXEditorList = new ArrayList<VEXEditor>();
    private static final String PREFIX_COMPONENT = "CUSTOMIZE_COMPONENT_";
    private static final String POSTFIX_NAME = "_name";
    private static final String POSTFIX_SCOPE = "_scope";
    private static final String POSTFIX_ICON = "_icon";
    private static final String POSTFIX_LARGE_ICON = "_large_icon";
    private static final String POSTFIX_TOOLTIP = "_tooltip";
    private static final String POSTFIX_CONTENT = "_content";
    private static CustomizeComponentFactory customizeComponentFactory;
    private static List<CustomizeComponent> customizeComponentList;

    static {
        customizeComponentList = new ArrayList<CustomizeComponent>();
    }

    public static CustomizeComponentFactory getCustomizeComponentFactory() {
        if (customizeComponentFactory == null) {
            customizeComponentFactory = new CustomizeComponentFactory();
        }
        return customizeComponentFactory;
    }

    private void refreshVEXEditorList() {
        IEditorReference[] iEditorReferenceArray;
        this.allVEXEditorList.clear();
        IEditorReference[] iEditorReferenceArray2 = iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference iEditorReference = iEditorReferenceArray2[n2];
            IEditorPart iEditorPart = iEditorReference.getEditor(false);
            if (iEditorPart instanceof VEXEditor) {
                this.allVEXEditorList.add((VEXEditor)iEditorPart);
            }
            ++n2;
        }
    }

    private CustomizeComponentFactory() {
        customizeComponentList.addAll(CustomizeComponentFactory.loadCustomizeComponents());
    }

    public static List<CustomizeComponent> loadCustomizeComponents() {
        ArrayList<CustomizeComponent> arrayList = new ArrayList<CustomizeComponent>();
        String string = CustomizeComponentFactory.getCustomizeComponentNames();
        if (string != null && !string.equals("")) {
            List<String> list = CustomizeComponentFactory.getSubString(string);
            for (String string2 : list) {
                arrayList.add(CustomizeComponentFactory.loadComponent(string2));
            }
        }
        return arrayList;
    }

    private static String getCustomizeComponentNames() {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString(CUSTOMER_COMPONENT_ROOT);
        return string;
    }

    private void saveChangeAndRefresh() {
        this.deleteRootComponentPreferenceStorage();
        this.addComponentPreferenceStorage();
        this.refreshPalette();
    }

    private void deleteRootComponentPreferenceStorage() {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(CUSTOMER_COMPONENT_ROOT, "");
        try {
            ((ScopedPreferenceStore)iPreferenceStore).save();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void addComponentPreferenceStorage() {
        if (customizeComponentList.size() > 0) {
            IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
            String string = "";
            StringBuilder stringBuilder = new StringBuilder();
            for (CustomizeComponent customizeComponent : customizeComponentList) {
                this.updateComponentInPreference(iPreferenceStore, customizeComponent);
                stringBuilder.append(String.valueOf(customizeComponent.getName()) + ",");
            }
            string = stringBuilder.substring(0, stringBuilder.length() - 1);
            iPreferenceStore.setValue(CUSTOMER_COMPONENT_ROOT, string);
            try {
                ((ScopedPreferenceStore)iPreferenceStore).save();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void updateComponentInPreference(IPreferenceStore iPreferenceStore, CustomizeComponent customizeComponent) {
        iPreferenceStore.setValue(CustomizeComponentFactory.getComponentNameKey(customizeComponent.getName()), customizeComponent.getName());
        iPreferenceStore.setValue(CustomizeComponentFactory.getComponentScopeKey(customizeComponent.getName()), customizeComponent.getScope());
        iPreferenceStore.setValue(CustomizeComponentFactory.getComponentIconKey(customizeComponent.getName()), customizeComponent.getIcon());
        iPreferenceStore.setValue(CustomizeComponentFactory.getComponentLargeIconKey(customizeComponent.getName()), customizeComponent.getLargeIcon());
        iPreferenceStore.setValue(CustomizeComponentFactory.getComponentTooltipKey(customizeComponent.getName()), customizeComponent.getTooptip());
        iPreferenceStore.setValue(CustomizeComponentFactory.getComponentContentKey(customizeComponent.getName()), customizeComponent.getContent());
        try {
            ((ScopedPreferenceStore)iPreferenceStore).save();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void refreshPalette() {
        this.refreshVEXEditorList();
        for (VEXEditor vEXEditor : this.allVEXEditorList) {
            Object object3;
            PaletteViewer paletteViewer = ((CustomPalettePage)vEXEditor.getVEXEditorPalettePage()).getPaletteViewer();
            PaletteResourceManager paletteResourceManager = vEXEditor.getPaletteResourceManager();
            if (paletteResourceManager == null) {
                return;
            }
            Resource resource = paletteResourceManager.getCustomizeResource();
            CustomizePaletteViewer customizePaletteViewer = null;
            Object object2 = paletteViewer.getProperty("Customize_PaletteViewer");
            if (object2 instanceof CustomizePaletteViewer) {
                customizePaletteViewer = (CustomizePaletteViewer)((Object)object2);
            }
            if (customizePaletteViewer == null) {
                return;
            }
            PaletteRoot paletteRoot = customizePaletteViewer.getPaletteRoot();
            List list = paletteRoot.getChildren();
            PaletteGroup paletteGroup = null;
            for (Object object3 : list) {
                if (!((PaletteGroup)object3).getLabel().equals(EditorMessages.CustomizeComponentFactory_Customize)) continue;
                paletteGroup = (PaletteGroup)object3;
                break;
            }
            if (paletteGroup == null) {
                paletteGroup = new PaletteGroup(EditorMessages.CustomizeComponentFactory_Customize);
            }
            object3 = paletteGroup.getChildren();
            int n = object3.size();
            int n2 = 0;
            while (n2 < n) {
                paletteGroup.remove((PaletteEntry)object3.get(0));
                ++n2;
            }
            paletteRoot.remove((PaletteEntry)paletteGroup);
            if (customizeComponentList.size() > 0) {
                for (CustomizeComponent customizeComponent : customizeComponentList) {
                    Entry entry = ToolPaletteFactory.eINSTANCE.createEntry();
                    entry.setName(customizeComponent.getName());
                    entry.setScope(customizeComponent.getScope());
                    entry.setIcon(customizeComponent.getIcon());
                    entry.setLargeIcon(customizeComponent.getLargeIcon());
                    entry.setToolTip(customizeComponent.getTooptip());
                    entry.setContent(customizeComponent.getContent());
                    CombinedTemplateCreationEntry combinedTemplateCreationEntry = new CombinedTemplateCreationEntry(entry.getName(), entry.getToolTip(), (Object)entry, (CreationFactory)new SimpleFactory(resource.getClass()), ImageHelper.getImageDescriptor(paletteResourceManager, entry.getIcon()), ImageHelper.getImageDescriptor(paletteResourceManager, entry.getLargeIcon()));
                    paletteGroup.add((PaletteEntry)combinedTemplateCreationEntry);
                }
            }
            paletteRoot.add((PaletteEntry)paletteGroup);
        }
    }

    public List<CustomizeComponent> getComponents() {
        return customizeComponentList;
    }

    public void addComponent(CustomizeComponent customizeComponent) {
        customizeComponentList.add(customizeComponent);
        this.saveChangeAndRefresh();
    }

    public void modifyComponent(CustomizeComponent customizeComponent, String string) {
        if (customizeComponent == null) {
            return;
        }
        for (CustomizeComponent customizeComponent2 : customizeComponentList) {
            if (!customizeComponent2.getName().equals(string)) continue;
            customizeComponent2.setName(customizeComponent.getName());
            customizeComponent2.setScope(customizeComponent.getScope());
            customizeComponent2.setIcon(customizeComponent.getIcon());
            customizeComponent2.setLargeIcon(customizeComponent.getLargeIcon());
            customizeComponent2.setTooptip(customizeComponent.getTooptip());
            customizeComponent2.setContent(customizeComponent.getContent());
        }
        this.saveChangeAndRefresh();
    }

    public void deleteComponent(String string) {
        if (customizeComponentList.size() > 0) {
            for (CustomizeComponent customizeComponent : customizeComponentList) {
                if (!customizeComponent.getName().equals(string)) continue;
                customizeComponentList.remove(customizeComponent);
                break;
            }
            this.saveChangeAndRefresh();
        }
    }

    private static List<String> getSubString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.split(",");
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(stringArray[n]);
            ++n;
        }
        return arrayList;
    }

    private static String getComponentNameKey(String string) {
        return PREFIX_COMPONENT + string + POSTFIX_NAME;
    }

    private static String getComponentScopeKey(String string) {
        return PREFIX_COMPONENT + string + POSTFIX_SCOPE;
    }

    private static String getComponentIconKey(String string) {
        return PREFIX_COMPONENT + string + POSTFIX_ICON;
    }

    private static String getComponentLargeIconKey(String string) {
        return PREFIX_COMPONENT + string + POSTFIX_LARGE_ICON;
    }

    private static String getComponentTooltipKey(String string) {
        return PREFIX_COMPONENT + string + POSTFIX_TOOLTIP;
    }

    private static String getComponentContentKey(String string) {
        return PREFIX_COMPONENT + string + POSTFIX_CONTENT;
    }

    public static CustomizeComponent loadComponent(String string) {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        CustomizeComponent customizeComponent = new CustomizeComponent();
        customizeComponent.setName(iPreferenceStore.getString(CustomizeComponentFactory.getComponentNameKey(string)));
        customizeComponent.setScope(iPreferenceStore.getString(CustomizeComponentFactory.getComponentScopeKey(string)));
        customizeComponent.setIcon(iPreferenceStore.getString(CustomizeComponentFactory.getComponentIconKey(string)));
        customizeComponent.setLargeIcon(iPreferenceStore.getString(CustomizeComponentFactory.getComponentLargeIconKey(string)));
        customizeComponent.setTooptip(iPreferenceStore.getString(CustomizeComponentFactory.getComponentTooltipKey(string)));
        customizeComponent.setContent(iPreferenceStore.getString(CustomizeComponentFactory.getComponentContentKey(string)));
        return customizeComponent;
    }

    public boolean isComponentExist(String string) {
        if (customizeComponentList == null) {
            return false;
        }
        for (CustomizeComponent customizeComponent : customizeComponentList) {
            if (!customizeComponent.getName().equals(string)) continue;
            return true;
        }
        return false;
    }
}

