/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex.palette.customize.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.e4.xwt.vex.EditorMessages;
import org.eclipse.e4.xwt.vex.palette.customize.CustomizeComponentFactory;
import org.eclipse.e4.xwt.vex.palette.customize.InvokeType;
import org.eclipse.e4.xwt.vex.palette.customize.model.CustomizeComponent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CustomizePaletteDialog
extends TitleAreaDialog {
    private Text textName;
    private Text textScope;
    private Text textIcon;
    private Text textLargeIcon;
    private Text textToolTip;
    private Text textContent;
    InvokeType invokeType;
    CustomizeComponent customizeComponent;
    String templateDnDText;

    public CustomizePaletteDialog(InvokeType invokeType, String string, String string2) {
        super(null);
        this.invokeType = invokeType;
        if (invokeType == InvokeType.Modify) {
            this.customizeComponent = CustomizeComponentFactory.loadComponent(string);
        }
        if (invokeType == InvokeType.DragAdd) {
            this.templateDnDText = string2;
        }
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        Rectangle rectangle = Display.getDefault().getClientArea();
        Rectangle rectangle2 = this.getShell().getBounds();
        this.getShell().setLocation((rectangle.width - rectangle2.width) / 2, (rectangle.height - rectangle2.height) / 2);
        this.setTitle(EditorMessages.CustomizePaletteDialog_Title);
        this.setMessage(EditorMessages.CustomizePaletteDialog_Message, 1);
        return control;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(EditorMessages.CustomizePaletteDialog_Header);
        shell.setSize(500, 500);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        final Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite3.setLayoutData((Object)gridData);
        Label label = new Label(composite3, 16384);
        label.setText(EditorMessages.CustomizePaletteDialog_Name);
        this.textName = new Text(composite3, 2052);
        gridData = new GridData(768);
        this.textName.setLayoutData((Object)gridData);
        this.textName.setToolTipText(EditorMessages.CustomizePaletteDialog_Name_ToolTip);
        Label label2 = new Label(composite3, 16384);
        label2.setText(EditorMessages.CustomizePaletteDialog_Scope);
        this.textScope = new Text(composite3, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.textScope.setLayoutData((Object)gridData);
        this.textScope.setToolTipText(EditorMessages.CustomizePaletteDialog_Scope_ToolTip);
        Label label3 = new Label(composite3, 16384);
        label3.setText(EditorMessages.CustomizePaletteDialog_Icon);
        this.textIcon = new Text(composite3, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.minimumWidth = 280;
        this.textIcon.setLayoutData((Object)gridData);
        this.textIcon.setToolTipText(EditorMessages.CustomizePaletteDialog_Icon_ToolTip);
        Button button = new Button(composite3, 8);
        button.setText(EditorMessages.CustomizePaletteDialog_BrowseIcon);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(composite3.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                elementTreeSelectionDialog.setAllowMultiple(false);
                elementTreeSelectionDialog.setTitle(EditorMessages.CustomizePaletteDialog_SelectionDialog_Title);
                elementTreeSelectionDialog.setMessage(EditorMessages.CustomizePaletteDialog_SelectionDialog_Text);
                elementTreeSelectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                if (elementTreeSelectionDialog.open() == 0) {
                    IFile iFile = (IFile)elementTreeSelectionDialog.getFirstResult();
                    String string = iFile.getWorkspace().getRoot().getLocation().toOSString();
                    String string2 = iFile.getFullPath().toOSString();
                    CustomizePaletteDialog.this.textIcon.setText(String.valueOf(string) + string2);
                }
            }
        });
        gridData = new GridData(768);
        gridData.minimumWidth = 100;
        button.setLayoutData((Object)gridData);
        Label label4 = new Label(composite3, 16384);
        label4.setText(EditorMessages.CustomizePaletteDialog_LargeIcon);
        this.textLargeIcon = new Text(composite3, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.textLargeIcon.setLayoutData((Object)gridData);
        this.textLargeIcon.setToolTipText(EditorMessages.CustomizePaletteDialog_LargeIcon_ToolTip);
        Button button2 = new Button(composite3, 8);
        button2.setText(EditorMessages.CustomizePaletteDialog_BrowseLargeIcon);
        button2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(composite3.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                elementTreeSelectionDialog.setAllowMultiple(false);
                elementTreeSelectionDialog.setTitle(EditorMessages.CustomizePaletteDialog_SelectionDialog_LargeTitle);
                elementTreeSelectionDialog.setMessage(EditorMessages.CustomizePaletteDialog_SelectionDialog_LargeText);
                elementTreeSelectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                if (elementTreeSelectionDialog.open() == 0) {
                    IFile iFile = (IFile)elementTreeSelectionDialog.getFirstResult();
                    String string = iFile.getWorkspace().getRoot().getLocation().toOSString();
                    String string2 = iFile.getFullPath().toOSString();
                    CustomizePaletteDialog.this.textLargeIcon.setText(String.valueOf(string) + string2);
                }
            }
        });
        gridData = new GridData(768);
        button2.setLayoutData((Object)gridData);
        Label label5 = new Label(composite3, 16384);
        label5.setText(EditorMessages.CustomizePaletteDialog_ToolTip);
        this.textToolTip = new Text(composite3, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.textToolTip.setLayoutData((Object)gridData);
        this.textToolTip.setToolTipText(EditorMessages.CustomizePaletteDialog_ToolTip_ToolTip);
        Label label6 = new Label(composite3, 16384);
        label6.setText(EditorMessages.CustomizePaletteDialog_Content);
        gridData = new GridData(768);
        gridData.horizontalSpan = 5;
        label6.setLayoutData((Object)gridData);
        this.textContent = new Text(composite3, 2818);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 5;
        this.textContent.setLayoutData((Object)gridData);
        this.textContent.setToolTipText(EditorMessages.CustomizePaletteDialog_Content_ToolTip);
        if (this.invokeType == InvokeType.DragAdd) {
            this.textContent.setText(this.templateDnDText);
        }
        this.setModifyComponentContent();
        return composite2;
    }

    private void setModifyComponentContent() {
        if (this.invokeType == InvokeType.Modify) {
            this.textName.setText(this.customizeComponent.getName());
            this.textScope.setText(this.customizeComponent.getScope());
            this.textIcon.setText(this.customizeComponent.getIcon());
            this.textLargeIcon.setText(this.customizeComponent.getLargeIcon());
            this.textToolTip.setText(this.customizeComponent.getTooptip());
            this.textContent.setText(this.customizeComponent.getContent());
        }
    }

    protected void okPressed() {
        if (this.doAddCustomizePaletteComponent()) {
            super.okPressed();
        }
    }

    private boolean doAddCustomizePaletteComponent() {
        if (!this.validInput()) {
            return false;
        }
        CustomizeComponentFactory customizeComponentFactory = CustomizeComponentFactory.getCustomizeComponentFactory();
        if (this.invokeType != InvokeType.Modify && customizeComponentFactory.isComponentExist(this.textName.getText())) {
            MessageDialog.openError(null, (String)EditorMessages.CustomizePaletteDialog_ErrorTitle, (String)EditorMessages.CustomizePaletteDialog_ErrorMessage);
            return false;
        }
        if (this.invokeType == InvokeType.Modify && !this.textName.getText().equals(this.customizeComponent.getName()) && customizeComponentFactory.isComponentExist(this.textName.getText())) {
            MessageDialog.openError(null, (String)EditorMessages.CustomizePaletteDialog_ErrorTitle, (String)EditorMessages.CustomizePaletteDialog_ErrorMessage);
            return false;
        }
        CustomizeComponent customizeComponent = new CustomizeComponent();
        customizeComponent.setName(this.textName.getText());
        customizeComponent.setScope(this.textScope.getText());
        customizeComponent.setIcon(this.textIcon.getText());
        customizeComponent.setLargeIcon(this.textLargeIcon.getText());
        customizeComponent.setTooptip(this.textToolTip.getText());
        customizeComponent.setContent(this.textContent.getText());
        if (this.invokeType == InvokeType.Modify) {
            customizeComponentFactory.modifyComponent(customizeComponent, this.customizeComponent.getName());
        } else {
            customizeComponentFactory.addComponent(customizeComponent);
        }
        return true;
    }

    private boolean validInput() {
        boolean bl = true;
        if (this.textName.getText() == null || this.textName.getText().trim().equals("")) {
            MessageDialog.openError(null, (String)EditorMessages.CustomizePaletteDialog_ErrorTitle, (String)EditorMessages.CustomizePaletteDialog_NameError);
            this.textName.setFocus();
            this.textName.selectAll();
            return false;
        }
        if (this.textContent.getText() == null || this.textContent.getText().trim().equals("")) {
            MessageDialog.openError(null, (String)EditorMessages.CustomizePaletteDialog_ErrorTitle, (String)EditorMessages.CustomizePaletteDialog_ContentError);
            this.textContent.setFocus();
            this.textContent.selectAll();
            return false;
        }
        return bl;
    }
}

