/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class CustomSashForm
extends SashForm {
    public static final String copyright = "(c) Copyright IBM Corporation 2002.";
    public static final int NO_MAX_LEFT = 1;
    public static final int NO_MAX_UP = 1;
    public static final int NO_MAX_RIGHT = 2;
    public static final int NO_MAX_DOWN = 2;
    private static final int NO_WEIGHT = -1;
    private static final int NO_ARROW = -1;
    protected SashInfo currentSashInfo = null;
    protected boolean inMouseClick = false;
    protected boolean[] sashBorders;
    protected boolean noMaxUp;
    protected boolean noMaxDown;
    protected List customSashFormListeners = null;
    protected static final int UP_ARROW = 0;
    protected static final int UP_MAX_ARROW = 1;
    protected static final int DOWN_ARROW = 2;
    protected static final int DOWN_MAX_ARROW = 3;
    protected static final int MAX_ARROWS = 4;
    protected static final int ARROW_TYPE_INDEX = 0;
    protected static final int ARROW_DRAWN_INDEX = 1;
    protected static final int X_INDEX = 2;
    protected static final int Y_INDEX = 3;
    protected static final int WIDTH_INDEX = 4;
    protected static final int HEIGHT_INDEX = 5;
    protected static final int ARROW_SIZE = 8;
    protected static final int ARROW_HEIGHT = 8;
    protected static final int ARROW_MARGIN = 3;
    protected Color arrowColor;
    protected Color borderColor;

    public CustomSashForm(Composite composite, int n) {
        this(composite, n, 0);
    }

    public CustomSashForm(Composite composite, int n, int n2) {
        super(composite, n);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                CustomSashForm.this.layout(true);
            }
        });
        this.noMaxUp = (n2 & 1) != 0;
        boolean bl = this.noMaxDown = (n2 & 2) != 0;
        if (this.noMaxUp & this.noMaxDown) {
            return;
        }
        this.SASH_WIDTH = 3 + this.getOrientation() == 512 ? 8 : 8;
        this.arrowColor = new Color((Device)composite.getDisplay(), 99, 101, 156);
        this.borderColor = new Color((Device)composite.getDisplay(), 132, 130, 132);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                CustomSashForm.this.arrowColor.dispose();
                CustomSashForm.this.borderColor.dispose();
                CustomSashForm.this.borderColor = null;
                CustomSashForm.this.arrowColor = null;
            }
        });
    }

    public void maxUp() {
        if (this.noMaxUp) {
            return;
        }
        if (this.currentSashInfo == null) {
            this.currentSashInfo = new SashInfo(null);
        }
        this.upMaxClicked(this.currentSashInfo);
    }

    public void maxLeft() {
        this.maxUp();
    }

    public void maxDown() {
        if (this.noMaxDown) {
            return;
        }
        if (this.currentSashInfo == null) {
            this.currentSashInfo = new SashInfo(null);
        }
        this.downMaxClicked(this.currentSashInfo);
    }

    public void maxRight() {
        this.maxDown();
    }

    public void setSashBorders(boolean[] blArray) {
        int[] nArray = this.getWeights();
        if (nArray.length != 2 || blArray != null && blArray.length != 2) {
            SWT.error((int)5);
        }
        this.sashBorders = blArray;
    }

    public void layout(boolean bl) {
        super.layout(bl);
        if (this.noMaxUp && this.noMaxDown) {
            return;
        }
        if (this.getMaximizedControl() != null) {
            return;
        }
        Control[] controlArray = this.getChildren();
        Sash sash = null;
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] instanceof Sash) {
                if (sash == null) {
                    sash = (Sash)controlArray[n];
                } else {
                    if (this.currentSashInfo != null) {
                        this.currentSashInfo.enabled = false;
                    }
                    return;
                }
            }
            ++n;
        }
        if (sash == null) {
            return;
        }
        if (this.currentSashInfo == null || this.currentSashInfo.sash == null) {
            if (this.currentSashInfo == null) {
                this.currentSashInfo = new SashInfo(sash);
            } else {
                this.currentSashInfo.sash = sash;
            }
            sash.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    GC gC = paintEvent.gc;
                    Color color = gC.getForeground();
                    Color color2 = gC.getBackground();
                    CustomSashForm.this.drawArrow(gC, CustomSashForm.this.currentSashInfo.sashLocs[0], CustomSashForm.this.currentSashInfo.cursorOver == 0);
                    if (CustomSashForm.this.currentSashInfo.sashLocs.length > 1) {
                        CustomSashForm.this.drawArrow(gC, CustomSashForm.this.currentSashInfo.sashLocs[1], CustomSashForm.this.currentSashInfo.cursorOver == 1);
                    }
                    if (CustomSashForm.this.currentSashInfo.sashBorderLeft) {
                        CustomSashForm.this.drawSashBorder(gC, CustomSashForm.this.currentSashInfo.sash, true);
                    }
                    if (CustomSashForm.this.currentSashInfo.sashBorderRight) {
                        CustomSashForm.this.drawSashBorder(gC, CustomSashForm.this.currentSashInfo.sash, false);
                    }
                    gC.setForeground(color);
                    gC.setBackground(color2);
                }
            });
            sash.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent controlEvent) {
                    CustomSashForm.this.recomputeSashInfo();
                }

                public void controlResized(ControlEvent controlEvent) {
                    CustomSashForm.this.recomputeSashInfo();
                }
            });
            sash.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    CustomSashForm.this.currentSashInfo = null;
                }
            });
            sash.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent mouseEvent) {
                    int n = mouseEvent.x;
                    int n2 = mouseEvent.y;
                    int n3 = 0;
                    while (n3 < CustomSashForm.this.currentSashInfo.sashLocs.length) {
                        int n4;
                        int[] nArray = CustomSashForm.this.currentSashInfo.sashLocs[n3];
                        boolean bl = CustomSashForm.this.getOrientation() == 512;
                        int n5 = bl ? n : n2;
                        int n6 = bl ? 2 : 3;
                        int n7 = n4 = bl ? 4 : 5;
                        if (nArray[n6] <= n5 && n5 <= nArray[n6] + nArray[n4]) {
                            if (CustomSashForm.this.currentSashInfo.cursorOver == -1) {
                                CustomSashForm.this.currentSashInfo.sash.setCursor(Cursors.ARROW);
                            }
                            if (CustomSashForm.this.currentSashInfo.cursorOver != n3) {
                                CustomSashForm.this.currentSashInfo.cursorOver = n3;
                                CustomSashForm.this.currentSashInfo.sash.redraw();
                                switch (nArray[0]) {
                                    case 0: 
                                    case 2: {
                                        CustomSashForm.this.currentSashInfo.sash.setToolTipText("Restore Previous Location");
                                        break;
                                    }
                                    case 1: 
                                    case 3: {
                                        CustomSashForm.this.currentSashInfo.sash.setToolTipText("Maximize Pane");
                                    }
                                }
                            }
                            return;
                        }
                        ++n3;
                    }
                    if (CustomSashForm.this.currentSashInfo.cursorOver != -1) {
                        CustomSashForm.this.currentSashInfo.sash.setCursor(null);
                        CustomSashForm.this.currentSashInfo.cursorOver = -1;
                        CustomSashForm.this.currentSashInfo.sash.redraw();
                        CustomSashForm.this.currentSashInfo.sash.setToolTipText(null);
                    }
                }
            });
            sash.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent mouseEvent) {
                    if (CustomSashForm.this.currentSashInfo.cursorOver != -1) {
                        CustomSashForm.this.currentSashInfo.sash.setCursor(null);
                        CustomSashForm.this.currentSashInfo.cursorOver = -1;
                        CustomSashForm.this.currentSashInfo.sash.redraw();
                        CustomSashForm.this.currentSashInfo.sash.setToolTipText(null);
                    }
                }
            });
            sash.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    CustomSashForm.this.inMouseClick = true;
                    int n = mouseEvent.x;
                    int n2 = mouseEvent.y;
                    int n3 = 0;
                    while (n3 < CustomSashForm.this.currentSashInfo.sashLocs.length) {
                        int n4;
                        int[] nArray = CustomSashForm.this.currentSashInfo.sashLocs[n3];
                        boolean bl = CustomSashForm.this.getOrientation() == 512;
                        int n5 = bl ? n : n2;
                        int n6 = bl ? 2 : 3;
                        int n7 = n4 = bl ? 4 : 5;
                        if (nArray[n6] <= n5 && n5 <= nArray[n6] + nArray[n4]) {
                            CustomSashForm.this.currentSashInfo.sash.redraw();
                            break;
                        }
                        ++n3;
                    }
                }

                public void mouseUp(MouseEvent mouseEvent) {
                    CustomSashForm.this.inMouseClick = false;
                    int n = mouseEvent.x;
                    int n2 = mouseEvent.y;
                    int n3 = 0;
                    while (n3 < CustomSashForm.this.currentSashInfo.sashLocs.length) {
                        int n4;
                        int[] nArray = CustomSashForm.this.currentSashInfo.sashLocs[n3];
                        boolean bl = CustomSashForm.this.getOrientation() == 512;
                        int n5 = bl ? n : n2;
                        int n6 = bl ? 2 : 3;
                        int n7 = n4 = bl ? 4 : 5;
                        if (nArray[n6] <= n5 && n5 <= nArray[n6] + nArray[n4]) {
                            switch (nArray[0]) {
                                case 0: {
                                    CustomSashForm.this.upClicked(CustomSashForm.this.currentSashInfo);
                                    break;
                                }
                                case 1: {
                                    CustomSashForm.this.upMaxClicked(CustomSashForm.this.currentSashInfo);
                                    break;
                                }
                                case 2: {
                                    CustomSashForm.this.downClicked(CustomSashForm.this.currentSashInfo);
                                    break;
                                }
                                case 3: {
                                    CustomSashForm.this.downMaxClicked(CustomSashForm.this.currentSashInfo);
                                }
                            }
                            break;
                        }
                        ++n3;
                    }
                    CustomSashForm.this.currentSashInfo.sash.redraw();
                    CustomSashForm.this.fireDividerMoved();
                }
            });
            this.recomputeSashInfo();
        }
    }

    protected void recomputeSashInfo() {
        if (this.inMouseClick && this.currentSashInfo.cursorOver != -1) {
            return;
        }
        int[] nArray = null;
        int[] nArray2 = null;
        int[] nArray3 = this.getWeights();
        if (this.noMaxUp) {
            nArray = new int[1];
            nArray2 = new int[1];
            if (nArray3[1] == 0) {
                nArray[0] = 0;
                nArray2[0] = 0;
                this.currentSashInfo.sashBorderLeft = this.sashBorders != null ? this.sashBorders[0] : false;
                this.currentSashInfo.sashBorderRight = false;
            } else {
                nArray[0] = 3;
                nArray2[0] = 2;
                this.currentSashInfo.weight = -1;
                this.currentSashInfo.sashBorderLeft = this.sashBorders != null ? this.sashBorders[0] : false;
                this.currentSashInfo.sashBorderRight = this.sashBorders != null ? this.sashBorders[1] : false;
            }
        } else if (this.noMaxDown) {
            nArray = new int[1];
            nArray2 = new int[1];
            if (nArray3[0] == 0) {
                nArray[0] = 2;
                nArray2[0] = 2;
                this.currentSashInfo.sashBorderLeft = false;
                this.currentSashInfo.sashBorderRight = this.sashBorders != null ? this.sashBorders[1] : false;
            } else {
                nArray[0] = 1;
                nArray2[0] = 0;
                this.currentSashInfo.weight = -1;
                this.currentSashInfo.sashBorderLeft = this.sashBorders != null ? this.sashBorders[0] : false;
                this.currentSashInfo.sashBorderRight = this.sashBorders != null ? this.sashBorders[1] : false;
            }
        } else {
            nArray = new int[2];
            nArray2 = new int[2];
            Rectangle rectangle = this.currentSashInfo.sash.getBounds();
            Rectangle rectangle2 = this.getClientArea();
            if (nArray3[0] == 0 || this.currentSashInfo.weight != -1 && rectangle.y <= 20) {
                nArray[0] = 3;
                nArray2[0] = 3;
                nArray[1] = 2;
                nArray2[1] = 2;
                this.currentSashInfo.sashBorderLeft = false;
                this.currentSashInfo.sashBorderRight = this.sashBorders != null ? this.sashBorders[1] : false;
            } else if (nArray3[1] == 0 || this.currentSashInfo.weight != -1 && rectangle.y + rectangle.height >= rectangle2.height - 20) {
                nArray[0] = 0;
                nArray2[0] = 0;
                nArray[1] = 1;
                nArray2[1] = 1;
                this.currentSashInfo.sashBorderLeft = this.sashBorders != null ? this.sashBorders[0] : false;
                this.currentSashInfo.sashBorderRight = false;
            } else {
                nArray[0] = 1;
                nArray2[0] = 0;
                nArray[1] = 3;
                nArray2[1] = 2;
                this.currentSashInfo.weight = -1;
                this.currentSashInfo.sashBorderLeft = this.sashBorders != null ? this.sashBorders[0] : false;
                this.currentSashInfo.sashBorderRight = this.sashBorders != null ? this.sashBorders[1] : false;
            }
        }
        this.getNewSashArray(this.currentSashInfo, nArray, nArray2);
        this.currentSashInfo.sash.redraw();
    }

    protected void upClicked(SashInfo sashInfo) {
        int[] nArray = this.getWeights();
        nArray[0] = 1000 - sashInfo.weight;
        nArray[1] = sashInfo.weight;
        sashInfo.weight = -1;
        this.setWeights(nArray);
        this.fireDividerMoved();
    }

    protected void upMaxClicked(SashInfo sashInfo) {
        int[] nArray = this.getWeights();
        if (this.currentSashInfo.weight == -1) {
            this.currentSashInfo.weight = nArray[1];
        }
        nArray[1] = 1000;
        nArray[0] = 0;
        Control[] controlArray = this.getChildren();
        boolean bl = this.isFocusAncestorA(controlArray[0]);
        this.setWeights(nArray);
        if (bl) {
            controlArray[1].setFocus();
        }
        this.fireDividerMoved();
    }

    protected void downClicked(SashInfo sashInfo) {
        int[] nArray = this.getWeights();
        nArray[0] = 1000 - sashInfo.weight;
        nArray[1] = sashInfo.weight;
        sashInfo.weight = -1;
        this.setWeights(nArray);
        this.fireDividerMoved();
    }

    protected void downMaxClicked(SashInfo sashInfo) {
        int[] nArray = this.getWeights();
        if (this.currentSashInfo.weight == -1) {
            this.currentSashInfo.weight = nArray[1];
        }
        nArray[0] = 1000;
        nArray[1] = 0;
        Control[] controlArray = this.getChildren();
        boolean bl = this.isFocusAncestorA(controlArray[1]);
        this.setWeights(nArray);
        if (bl) {
            controlArray[0].setFocus();
        }
        this.fireDividerMoved();
    }

    protected boolean isFocusAncestorA(Control control) {
        Display display = this.getDisplay();
        Control control2 = display.getFocusControl();
        while (control2 != null && control2 != control) {
            control2 = control2.getParent();
        }
        return control == control2;
    }

    protected void getNewSashArray(SashInfo sashInfo, int[] nArray, int[] nArray2) {
        Object object = sashInfo.sashLocs;
        if (object == null) {
            int[][] nArrayArray = new int[nArray.length][];
            sashInfo.sashLocs = nArrayArray;
            object = nArrayArray;
        }
        int n = 8;
        int n2 = n + 6;
        int n3 = n2 * nArray.length;
        boolean bl = this.getOrientation() == 512;
        Point point = sashInfo.sash.getSize();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (bl) {
            n5 = n4 = (point.x - n3) / 2;
            n6 = (point.y - 8) / 2;
            n7 = n2;
            n8 = n;
        } else {
            n6 = n4 = (point.y - n3) / 2;
            n5 = (point.x - 8) / 2;
            n7 = n;
            n8 = n2;
        }
        int n9 = 0;
        while (n9 < nArray.length) {
            if (object[n9] == null) {
                object[n9] = new int[]{nArray[n9], nArray2[n9], n5, n6, n7, n8};
            } else {
                object[n9][0] = nArray[n9];
                object[n9][1] = nArray2[n9];
                object[n9][2] = n5;
                object[n9][3] = n6;
                object[n9][4] = n7;
                object[n9][5] = n8;
            }
            if (bl) {
                n5 += n2;
            } else {
                n6 += n2;
            }
            ++n9;
        }
    }

    protected void drawSashBorder(GC gC, Sash sash, boolean bl) {
        gC.setForeground(this.borderColor);
        if (this.getOrientation() == 512) {
            Point point = sash.getSize();
            if (bl) {
                gC.drawLine(0, 0, point.x - 1, 0);
            } else {
                gC.drawLine(0, point.y - 1, point.x - 1, point.y - 1);
            }
        } else {
            Point point = sash.getSize();
            if (bl) {
                gC.drawLine(0, 0, 0, point.y - 1);
            } else {
                gC.drawLine(point.x - 1, 0, point.x - 1, point.y - 1);
            }
        }
    }

    protected void drawArrow(GC gC, int[] nArray, boolean bl) {
        int n = 0;
        if (bl) {
            if (!this.inMouseClick) {
                Color color = this.getDisplay().getSystemColor(20);
                Color color2 = this.getDisplay().getSystemColor(18);
                gC.setForeground(color);
                gC.drawLine(nArray[2], nArray[3] + nArray[5], nArray[2], nArray[3]);
                gC.drawLine(nArray[2], nArray[3], nArray[2] + nArray[4], nArray[3]);
                gC.setForeground(color2);
                gC.drawLine(nArray[2], nArray[3] + nArray[5], nArray[2] + nArray[4], nArray[3] + nArray[5]);
                gC.drawLine(nArray[2] + nArray[4], nArray[3] + nArray[5], nArray[2] + nArray[4], nArray[3]);
            } else {
                n = 1;
                Color color = this.getDisplay().getSystemColor(20);
                Color color3 = this.getDisplay().getSystemColor(18);
                gC.setForeground(color3);
                gC.drawLine(nArray[2], nArray[3] + nArray[5], nArray[2], nArray[3]);
                gC.drawLine(nArray[2], nArray[3], nArray[2] + nArray[4], nArray[3]);
                gC.setForeground(color);
                gC.drawLine(nArray[2], nArray[3] + nArray[5], nArray[2] + nArray[4], nArray[3] + nArray[5]);
                gC.drawLine(nArray[2] + nArray[4], nArray[3] + nArray[5], nArray[2] + nArray[4], nArray[3]);
            }
        }
        if (this.getOrientation() == 512) {
            switch (nArray[1]) {
                case 0: {
                    this.drawUpArrow(gC, nArray[2] + n, nArray[3] + n);
                    break;
                }
                case 2: {
                    this.drawDownArrow(gC, nArray[2] + n, nArray[3] + n);
                    break;
                }
                case 1: {
                    this.drawUpMaxArrow(gC, nArray[2] + n, nArray[3] + n);
                    break;
                }
                case 3: {
                    this.drawDownMaxArrow(gC, nArray[2] + n, nArray[3] + n);
                }
            }
        } else {
            switch (nArray[1]) {
                case 0: {
                    this.drawLeftArrow(gC, nArray[2] + n, nArray[3] + n);
                    break;
                }
                case 2: {
                    this.drawRightArrow(gC, nArray[2] + n, nArray[3] + n);
                    break;
                }
                case 1: {
                    this.drawLeftMaxArrow(gC, nArray[2] + n, nArray[3] + n);
                    break;
                }
                case 3: {
                    this.drawRightMaxArrow(gC, nArray[2] + n, nArray[3] + n);
                }
            }
        }
    }

    protected void drawUpArrow(GC gC, int n, int n2) {
        gC.setForeground(this.arrowColor);
        gC.drawLine((n += 3) + 4, n2 + 2, n + 7, n2 + 5);
        gC.drawLine(n + 3, n2 + 2, n + 3, n2 + 2);
        gC.drawLine(n + 2, n2 + 3, n + 4, n2 + 3);
        gC.drawLine(n + 1, n2 + 4, n + 5, n2 + 4);
        gC.drawLine(n, n2 + 5, n + 6, n2 + 5);
    }

    protected void drawUpMaxArrow(GC gC, int n, int n2) {
        gC.setForeground(this.arrowColor);
        gC.drawLine(n += 3, n2, n + 7, n2);
        gC.drawLine(n, n2 + 1, n + 7, n2 + 1);
        gC.drawLine(n + 4, n2 + 2, n + 7, n2 + 5);
        gC.drawLine(n + 3, n2 + 2, n + 3, n2 + 2);
        gC.drawLine(n + 2, n2 + 3, n + 4, n2 + 3);
        gC.drawLine(n + 1, n2 + 4, n + 5, n2 + 4);
        gC.drawLine(n, n2 + 5, n + 6, n2 + 5);
    }

    protected void drawDownArrow(GC gC, int n, int n2) {
        gC.setForeground(this.arrowColor);
        gC.drawLine(n += 3, n2 + 2, n + 3, n2 + 5);
        gC.drawLine(n + 4, n2 + 5, n + 4, n2 + 5);
        gC.drawLine(n + 3, n2 + 4, n + 5, n2 + 4);
        gC.drawLine(n + 1, n2 + 3, n + 6, n2 + 3);
        gC.drawLine(n + 1, n2 + 2, n + 7, n2 + 2);
    }

    protected void drawDownMaxArrow(GC gC, int n, int n2) {
        gC.setForeground(this.arrowColor);
        gC.drawLine(n += 3, n2 + 6, n + 7, n2 + 6);
        gC.drawLine(n, n2 + 7, n + 7, n2 + 7);
        gC.drawLine(n, n2 + 2, n + 3, n2 + 5);
        gC.drawLine(n + 4, n2 + 5, n + 4, n2 + 5);
        gC.drawLine(n + 3, n2 + 4, n + 5, n2 + 4);
        gC.drawLine(n + 1, n2 + 3, n + 6, n2 + 3);
        gC.drawLine(n + 1, n2 + 2, n + 7, n2 + 2);
    }

    protected void drawLeftArrow(GC gC, int n, int n2) {
        gC.setForeground(this.arrowColor);
        gC.drawLine(n + 2, (n2 += 3) + 4, n + 5, n2 + 7);
        gC.drawLine(n + 2, n2 + 3, n + 2, n2 + 3);
        gC.drawLine(n + 3, n2 + 2, n + 3, n2 + 4);
        gC.drawLine(n + 4, n2 + 1, n + 4, n2 + 5);
        gC.drawLine(n + 5, n2, n + 5, n2 + 6);
    }

    protected void drawLeftMaxArrow(GC gC, int n, int n2) {
        gC.setForeground(this.arrowColor);
        gC.drawLine(n, n2 += 3, n, n2 + 7);
        gC.drawLine(n + 1, n2, n + 1, n2 + 7);
        gC.drawLine(n + 2, n2 + 4, n + 5, n2 + 7);
        gC.drawLine(n + 2, n2 + 3, n + 2, n2 + 3);
        gC.drawLine(n + 3, n2 + 2, n + 3, n2 + 4);
        gC.drawLine(n + 4, n2 + 1, n + 4, n2 + 5);
        gC.drawLine(n + 5, n2, n + 5, n2 + 6);
    }

    protected void drawRightArrow(GC gC, int n, int n2) {
        gC.setForeground(this.arrowColor);
        gC.drawLine(n + 2, n2 += 3, n + 5, n2 + 3);
        gC.drawLine(n + 5, n2 + 4, n + 5, n2 + 4);
        gC.drawLine(n + 4, n2 + 3, n + 4, n2 + 5);
        gC.drawLine(n + 3, n2 + 1, n + 3, n2 + 6);
        gC.drawLine(n + 2, n2 + 1, n + 2, n2 + 7);
    }

    protected void drawRightMaxArrow(GC gC, int n, int n2) {
        gC.setForeground(this.arrowColor);
        gC.drawLine(n + 6, n2 += 3, n + 6, n2 + 7);
        gC.drawLine(n + 7, n2, n + 7, n2 + 7);
        gC.drawLine(n + 2, n2, n + 5, n2 + 3);
        gC.drawLine(n + 5, n2 + 4, n + 5, n2 + 4);
        gC.drawLine(n + 4, n2 + 3, n + 4, n2 + 5);
        gC.drawLine(n + 3, n2 + 1, n + 3, n2 + 6);
        gC.drawLine(n + 2, n2 + 1, n + 2, n2 + 7);
    }

    public int getSavedWeight() {
        if (this.currentSashInfo != null) {
            return this.currentSashInfo.weight;
        }
        return -1;
    }

    protected Sash getSash() {
        Control[] controlArray = this.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] instanceof Sash) {
                return (Sash)controlArray[n];
            }
            ++n;
        }
        return null;
    }

    public void setCurrentSavedWeight(int n) {
        if (n >= 0 && this.currentSashInfo != null) {
            this.recomputeSashInfo();
            this.currentSashInfo.weight = n;
        }
    }

    public void addCustomSashFormListener(ICustomSashFormListener iCustomSashFormListener) {
        if (this.customSashFormListeners == null) {
            this.customSashFormListeners = new ArrayList();
        }
        this.customSashFormListeners.add(iCustomSashFormListener);
    }

    public void removeCustomSashFormListener(ICustomSashFormListener iCustomSashFormListener) {
        if (this.customSashFormListeners != null) {
            this.customSashFormListeners.remove(iCustomSashFormListener);
        }
    }

    protected void fireDividerMoved() {
        int[] nArray;
        if (this.customSashFormListeners != null && this.customSashFormListeners.size() > 0 && (nArray = this.getWeights()) != null && nArray.length == 2) {
            int n = nArray[0];
            int n2 = nArray[1];
            for (ICustomSashFormListener iCustomSashFormListener : this.customSashFormListeners) {
                iCustomSashFormListener.dividerMoved(n, n2);
            }
        }
    }

    public static interface ICustomSashFormListener {
        public void dividerMoved(int var1, int var2);
    }

    private static class SashInfo {
        public Sash sash;
        public boolean enabled;
        public int weight = -1;
        public int cursorOver = -1;
        public boolean sashBorderLeft;
        public boolean sashBorderRight;
        public int[][] sashLocs;

        public SashInfo(Sash sash) {
            this.sash = sash;
        }
    }
}

