/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex.swt;

import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.xwt.vex.swt.Win32ImageCapture;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class ImageCapture {
    static ImageCapture instance;

    public Image captureImage(Control control) {
        Rectangle rectangle = control.getBounds();
        Display display = control.getDisplay();
        Image image = null;
        if (control instanceof Shell) {
            Shell shell = (Shell)control;
            shell.layout();
            Point point = control.toDisplay(0, 0);
            image = this.getImage(control, rectangle.width, rectangle.height, false);
            rectangle.x = point.x;
            rectangle.y = point.y;
            GC gC = new GC((Drawable)image);
            try {
                Control[] controlArray = shell.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control2 = controlArray[n2];
                    Rectangle rectangle2 = control2.getBounds();
                    int n3 = (rectangle.width - rectangle2.width) / 2;
                    int n4 = rectangle.height - rectangle2.height - n3;
                    rectangle2.x = rectangle.x + n3;
                    rectangle2.y = rectangle.y + n4;
                    if (rectangle.intersects(rectangle2)) {
                        Image image2 = new Image((Device)display, control2.getBounds());
                        GC gC2 = new GC((Drawable)image2);
                        control2.print(gC2);
                        gC2.dispose();
                        try {
                            gC.drawImage(image2, n3, n4);
                        }
                        finally {
                            image2.dispose();
                        }
                    }
                    ++n2;
                }
            }
            finally {
                gC.dispose();
            }
        }
        image = this.defaultCapture(control);
        return image;
    }

    public Image defaultCapture(Control control) {
        Rectangle rectangle = control.getBounds();
        return this.getImage(control, rectangle.width, rectangle.height, true);
    }

    protected abstract Image getImage(Control var1, int var2, int var3, boolean var4);

    public static ImageCapture getImageCapture() {
        if (instance == null) {
            if ("win32".equals(Platform.getOS())) {
                instance = new Win32ImageCapture();
            } else if ("gtk".equals(Platform.getWS())) {
                instance = "ia64".equals(Platform.getOSArch()) || "x86_64".equals(Platform.getOSArch()) ? new org.eclipse.ve.internal.swt.targetvm.unix.bits64.ImageCapture() : new org.eclipse.ve.internal.swt.targetvm.unix.ImageCapture();
            } else if ("macosx".equals(Platform.getOS())) {
                instance = new org.eclipse.ve.internal.swt.targetvm.macosx.ImageCapture();
            } else {
                throw new UnsupportedOperationException(Platform.getOS());
            }
        }
        return instance;
    }
}

