/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt.targetvm.unix;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.xwt.vex.ResourceManager;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ImageCapture
extends org.eclipse.e4.xwt.vex.swt.ImageCapture {
    protected int border = 4;
    protected int titleHeight = 25;
    static final int OBSCURED = 64;
    static final String FIELD_STATE_NAME = "state";
    protected Map fieldAccessors = new HashMap();
    private static final Object NO_FIELD;

    static {
        try {
            System.loadLibrary("swt-gtk-print");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        NO_FIELD = new Object();
    }

    private native int[] getPixels(int var1, int var2, int var3, int var4, int var5);

    protected Point getTopLeftOfClientarea(Decorations decorations) {
        Point point = decorations.toControl(decorations.getLocation());
        point.x = -point.x + this.border;
        point.y = -point.y + this.titleHeight;
        if (decorations.getMenuBar() != null) {
            Menu menu = decorations.getMenuBar();
            try {
                Class<?> clazz = Class.forName("org.eclipse.swt.internal.gtk.OS");
                Method method = clazz.getMethod("GTK_WIDGET_HEIGHT", Integer.TYPE);
                Object object = method.invoke((Object)menu, new Integer(menu.handle));
                if (object != null) {
                    int n = (Integer)object;
                    point.y -= n;
                }
            }
            catch (Throwable throwable) {}
        }
        return new Point(point.x, point.y);
    }

    public Image captureImage(Control control) {
        Rectangle rectangle = this.getBounds(control);
        Display display = control.getDisplay();
        Image image = null;
        if (control instanceof Shell) {
            Shell shell = (Shell)control;
            shell.layout();
            Point point = control.toDisplay(0, 0);
            image = this.getImage(control, rectangle.width, rectangle.height, false);
            rectangle.x = point.x;
            rectangle.y = point.y;
            GC gC = new GC((Drawable)image);
            try {
                Control[] controlArray = shell.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control2 = controlArray[n2];
                    Rectangle rectangle2 = control2.getBounds();
                    int n3 = (rectangle.width - rectangle2.width) / 2;
                    int n4 = rectangle.height - rectangle2.height - n3;
                    rectangle2.x = rectangle.x + n3;
                    rectangle2.y = rectangle.y + n4;
                    if (rectangle.intersects(rectangle2)) {
                        Image image2 = new Image((Device)display, control2.getBounds());
                        GC gC2 = new GC((Drawable)image2);
                        control2.print(gC2);
                        gC2.dispose();
                        try {
                            gC.drawImage(image2, n3, n4);
                        }
                        finally {
                            image2.dispose();
                        }
                    }
                    ++n2;
                }
            }
            finally {
                gC.dispose();
            }
        }
        image = new Image((Device)display, rectangle);
        GC gC = new GC((Drawable)image);
        control.print(gC);
        gC.dispose();
        return image;
    }

    protected Image getImageOfControl(Control control, int n, int n2, int n3) {
        Shell shell;
        int n4;
        Image image = null;
        if (control instanceof Shell && (n4 = this.readIntFieldValue((shell = (Shell)control).getClass(), shell, "shellHandle")) > 0) {
            image = this.getImageOfHandle(n4, shell.getDisplay(), n, n2, n3);
        }
        if (image == null) {
            image = this.getImageOfHandle(control.handle, control.getDisplay(), n, n2, n3);
        }
        if (control instanceof Decorations) {
            shell = (Decorations)control;
            Rectangle rectangle = this.getBounds((Control)shell);
            Point point = this.getTopLeftOfClientarea((Decorations)shell);
            Image image2 = new Image((Device)shell.getDisplay(), rectangle.width, rectangle.height);
            Image image3 = image;
            try {
                this.simulateDecoration((Decorations)shell, image2, rectangle, this.getClientArea((Composite)shell), point);
                GC gC = new GC((Drawable)image2);
                gC.drawImage(image, point.x, point.y);
                gC.dispose();
                image = image2;
            }
            finally {
                image3.dispose();
            }
        }
        return image;
    }

    protected Rectangle getBounds(Control control) {
        Rectangle rectangle = control.getBounds();
        if (control instanceof Decorations) {
            Decorations cfr_ignored_0 = (Decorations)control;
            rectangle.x -= this.border;
            rectangle.y -= this.titleHeight;
            rectangle.width += this.border * 2;
            rectangle.height += this.border + this.titleHeight;
        }
        return rectangle;
    }

    protected Rectangle getClientArea(Composite composite) {
        Rectangle rectangle = composite.getClientArea();
        if (composite instanceof Decorations) {
            Decorations cfr_ignored_0 = (Decorations)composite;
            rectangle.x += this.border;
            rectangle.y += this.titleHeight;
        }
        return rectangle;
    }

    protected Image getImageOfHandle(int n, Display display, int n2, int n3, int n4) {
        int[] nArray = this.getPixels(n, n2, n3, n4, 0);
        int n5 = display.getDepth();
        if (n5 == 15) {
            n5 = 16;
        }
        if (n5 > 24) {
            n5 = 24;
        }
        if (nArray != null) {
            int n6 = nArray[0];
            int n7 = nArray[1];
            int n8 = nArray[2];
            if (n8 == 1) {
                int n9 = nArray[3] == -1 ? 255 : nArray[3];
                int n10 = nArray[4] == -1 ? 65280 : nArray[4];
                int n11 = nArray[5] == -1 ? 0xFF0000 : nArray[5];
                int[] nArray2 = new int[nArray.length - 6];
                System.arraycopy(nArray, 6, nArray2, 0, nArray2.length);
                ImageData imageData = new ImageData(n6, n7, n5, new PaletteData(n9, n10, n11));
                imageData.setPixels(0, 0, nArray2.length, nArray2, 0);
                Image image = new Image((Device)display, imageData);
                return image;
            }
            if (n8 == 2) {
                int n12;
                int n13 = nArray[3];
                RGB[] rGBArray = new RGB[n13];
                int n14 = 0;
                while (n14 < n13) {
                    int n15 = nArray[4 + n14 * 3 + 0];
                    n12 = nArray[4 + n14 * 3 + 1];
                    int n16 = nArray[4 + n14 * 3 + 2];
                    rGBArray[n14] = new RGB(n15, n12, n16);
                    ++n14;
                }
                PaletteData paletteData = new PaletteData(rGBArray);
                ImageData imageData = new ImageData(n6, n7, n5, paletteData);
                n12 = 4 + rGBArray.length * 3;
                int[] nArray3 = new int[nArray.length - n12];
                System.arraycopy(nArray, n12, nArray3, 0, nArray3.length);
                imageData.setPixels(0, 0, nArray3.length, nArray3, 0);
                Image image = new Image((Device)display, imageData);
                return image;
            }
            System.err.println("JNI Returned unknown image type");
        }
        return null;
    }

    private void simulateDecoration(Decorations decorations, Image image, Rectangle rectangle, Rectangle rectangle2, Point point) {
        GC gC = new GC((Drawable)image);
        try {
            int n;
            gC.setBackground(decorations.getDisplay().getSystemColor(22));
            gC.fillRectangle(0, 0, rectangle.width, rectangle.height);
            gC.setBackground(decorations.getDisplay().getSystemColor(17));
            gC.drawRectangle(point.x - 1, point.y - 1, rectangle2.width + 2, rectangle2.height + 2);
            gC.setBackground(decorations.getDisplay().getSystemColor(31));
            gC.fillRectangle(0, rectangle.height - point.y, point.y, rectangle.height);
            gC.fillRectangle(rectangle.width - point.y, rectangle.height - point.y, rectangle.width, rectangle.height);
            Object object = decorations.getData("DesignMode.style");
            int n2 = n = object != null ? Integer.parseInt(object.toString()) : decorations.getStyle();
            if ((n & 0x4E0) != 0 && point.y > 2) {
                int n3;
                Image image2;
                int n4 = point.y - 2;
                gC.setForeground(decorations.getDisplay().getSystemColor(31));
                gC.setBackground(decorations.getDisplay().getSystemColor(30));
                gC.fillGradientRectangle(0, 0, rectangle.width, n4, false);
                gC.setForeground(decorations.getDisplay().getSystemColor(30));
                gC.drawText(decorations.getText(), point.y, 2, true);
                Image image3 = image2 = decorations.getImage() != null && !decorations.getImage().isDisposed() ? decorations.getImage() : ResourceManager.getImage("org.eclipse.e4.xwt.vex.obj16.eclipse_icon.png");
                if (image2 != null && !image2.isDisposed()) {
                    Rectangle rectangle3 = image2.getBounds();
                    if (rectangle3.height <= n4) {
                        n3 = (n4 - rectangle3.height) / 2;
                        gC.drawImage(image2, n3, n3);
                    } else {
                        ImageData imageData = image2.getImageData();
                        double d = (double)n4 / (double)rectangle3.height;
                        int n5 = (int)((double)rectangle3.width * d);
                        imageData = imageData.scaledTo(n5, n4);
                        Image image4 = new Image((Device)decorations.getDisplay(), imageData);
                        gC.drawImage(image4, 0, 0);
                        image4.dispose();
                    }
                }
                int n6 = rectangle.width - point.y;
                if ((n & 0x40) != 0) {
                    gC.setBackground(decorations.getDisplay().getSystemColor(22));
                    gC.fillRectangle(n6, 0, point.y, point.y);
                    gC.setLineWidth(1);
                    gC.setForeground(decorations.getDisplay().getSystemColor(17));
                    gC.drawRectangle(n6, 0, point.y, point.y);
                    n3 = point.y / 6;
                    if (n3 < 1) {
                        n3 = 1;
                    }
                    gC.setLineWidth(n3);
                    gC.setForeground(decorations.getDisplay().getSystemColor(23));
                    gC.drawLine(n6 + (n3 *= 2), n3, n6 + point.y - n3, point.y - n3);
                    gC.drawLine(n6 + n3, point.y - n3, n6 + point.y - n3, n3);
                    n6 -= point.y;
                }
                if ((n & 0x400) != 0) {
                    gC.setBackground(decorations.getDisplay().getSystemColor(22));
                    gC.fillRectangle(n6, 0, point.y, point.y);
                    gC.setLineWidth(1);
                    gC.setForeground(decorations.getDisplay().getSystemColor(17));
                    gC.drawRectangle(n6, 0, point.y, point.y);
                    n3 = point.y / 6;
                    if (n3 < 1) {
                        n3 = 1;
                    }
                    gC.setLineWidth(n3);
                    gC.setForeground(decorations.getDisplay().getSystemColor(23));
                    gC.drawRectangle(n6 + (n3 *= 2), n3, point.y - 2 * n3, point.y - 2 * n3);
                    n6 -= point.y;
                }
                if ((n & 0x80) != 0) {
                    gC.setLineWidth(1);
                    gC.setBackground(decorations.getDisplay().getSystemColor(22));
                    gC.fillRectangle(n6, 0, point.y - 1, point.y - 1);
                    gC.setForeground(decorations.getDisplay().getSystemColor(17));
                    gC.drawRectangle(n6, 0, point.y - 1, point.y - 1);
                    n3 = point.y / 6;
                    if (n3 < 1) {
                        n3 = 1;
                    }
                    gC.setLineWidth(n3);
                    gC.setForeground(decorations.getDisplay().getSystemColor(23));
                    gC.drawLine(n6 + (n3 *= 2), point.y - n3, n6 + point.y - n3, point.y - n3);
                    n6 -= point.y;
                }
                gC.setLineWidth(1);
                gC.setForeground(decorations.getDisplay().getSystemColor(17));
                gC.drawLine(0, point.y - 1, rectangle.width, point.y - 1);
            }
        }
        finally {
            gC.dispose();
        }
    }

    private int readIntFieldValue(Class clazz, Object object, String string) {
        try {
            Field field = this.getField(clazz, string);
            return field != null ? field.getInt(object) : 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return -1;
    }

    private Field getField(Class clazz, String string) {
        Object object;
        HashMap hashMap = (HashMap)this.fieldAccessors.get(clazz);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.fieldAccessors.put(clazz, hashMap);
        }
        if ((object = hashMap.get(string)) == null) {
            try {
                object = clazz.getDeclaredField(string);
                ((Field)object).setAccessible(true);
            }
            catch (SecurityException securityException) {
                object = NO_FIELD;
                securityException.printStackTrace();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                object = NO_FIELD;
                noSuchFieldException.printStackTrace();
            }
            hashMap.put(clazz, object);
        }
        return (Field)(object != NO_FIELD ? object : null);
    }

    private void writeIntFieldValue(Class clazz, Object object, String string, int n) {
        try {
            Field field = this.getField(clazz, string);
            field.setInt(object, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
    }

    protected Image getImage(Control control, int n, int n2, boolean bl) {
        int n3 = bl ? 1 : 0;
        HashMap hashMap = new HashMap();
        this.changeObscured(control, hashMap, false);
        Image image = null;
        try {
            image = this.getImageOfControl(control, n3, n, n2);
        }
        finally {
            this.changeObscured(control, hashMap, true);
        }
        return image;
    }

    private void changeObscured(Control control, Map map, boolean bl) {
        Integer n;
        if (bl) {
            if (map.containsKey(control)) {
                n = (Integer)map.get(control);
                this.writeIntFieldValue(Widget.class, control, FIELD_STATE_NAME, n);
            }
        } else {
            int n2 = this.readIntFieldValue(Widget.class, control, FIELD_STATE_NAME);
            if ((n2 & 0x40) != 0) {
                map.put(control, new Integer(n2));
                this.writeIntFieldValue(Widget.class, control, FIELD_STATE_NAME, n2 &= 0xFFFFFFBF);
            }
        }
        if (control instanceof CCombo) {
            n = (CCombo)control;
            Object object = this.readObjectFieldValue(CCombo.class, n, "text");
            if (object instanceof Text) {
                Text text = (Text)object;
                this.changeObscured((Control)text, map, bl);
            }
        } else if (control instanceof Composite) {
            n = (Composite)control;
            Control[] controlArray = n.getChildren();
            int n3 = 0;
            while (controlArray != null && n3 < controlArray.length) {
                this.changeObscured(controlArray[n3], map, bl);
                ++n3;
            }
        }
    }

    private Object readObjectFieldValue(Class clazz, Object object, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return null;
    }
}

