/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.utils;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderHelper {
    public static URL getResourceAsURL(IJavaProject iJavaProject, String string) {
        IFile iFile;
        if (iJavaProject == null) {
            return null;
        }
        HashSet<IJavaProject> hashSet = new HashSet<IJavaProject>();
        URL uRL = ClassLoaderHelper.findResourceURL(iJavaProject, hashSet, true, string);
        if (uRL == null && (iFile = iJavaProject.getProject().getFile(string)).exists()) {
            uRL = ClassLoaderHelper.toURL(iFile.getLocation());
        }
        return uRL;
    }

    public static byte[] getClassContent(IJavaProject iJavaProject, String string) {
        if (iJavaProject == null || !iJavaProject.exists()) {
            return null;
        }
        String string2 = String.valueOf(string.replace('.', '/')) + ".class";
        try {
            IProject iProject;
            IPath iPath = iJavaProject.getProject().getLocation().removeLastSegments(1).append(iJavaProject.getOutputLocation());
            iPath = iPath.addTrailingSeparator();
            URL uRL = ClassLoaderHelper.toURL(iPath.append(string2));
            if (uRL != null) {
                InputStream inputStream = uRL.openStream();
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                return byArray;
            }
            IProject[] iProjectArray = iJavaProject.getProject().getReferencedProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] byArray;
                IJavaProject iJavaProject2;
                iProject = iProjectArray[n2];
                if (iProject.isOpen() && (iJavaProject2 = JavaCore.create((IProject)iProject)).exists() && (byArray = ClassLoaderHelper.getClassContent(iJavaProject2, string)) != null) {
                    return byArray;
                }
                ++n2;
            }
            uRL = iJavaProject.findType(string);
            if (uRL != null && uRL.exists()) {
                if (uRL.isBinary()) {
                    return uRL.getClassFile().getBytes();
                }
                iProject = uRL.getJavaProject();
                if (!iJavaProject.equals(iProject)) {
                    return ClassLoaderHelper.getClassContent((IJavaProject)iProject, string);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static URL[] getClasspathAsURLArray(IJavaProject iJavaProject) {
        if (iJavaProject == null) {
            return null;
        }
        HashSet<IJavaProject> hashSet = new HashSet<IJavaProject>();
        ArrayList<URL> arrayList = new ArrayList<URL>(20);
        ClassLoaderHelper.collectClasspathURLs(iJavaProject, arrayList, hashSet, true);
        URL[] uRLArray = new URL[arrayList.size()];
        arrayList.toArray(uRLArray);
        return uRLArray;
    }

    private static URL findResourceURL(IJavaProject iJavaProject, Set<IJavaProject> set, boolean bl, String string) {
        if (set.contains(iJavaProject)) {
            return null;
        }
        set.add(iJavaProject);
        try {
            Object object;
            IPath iPath = iJavaProject.getProject().getLocation().removeLastSegments(1).append(iJavaProject.getOutputLocation());
            iPath = iPath.addTrailingSeparator();
            IPackageFragmentRoot iPackageFragmentRoot = ClassLoaderHelper.toURL(iPath.append(string));
            if (iPackageFragmentRoot != null) {
                return iPackageFragmentRoot;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                iPackageFragmentRoot = iPackageFragmentRootArray[n2];
                if (iPackageFragmentRoot.getKind() == 1 && (object = ClassLoaderHelper.toURL(iPackageFragmentRoot.getResource().getLocation().append(string))) != null) {
                    return object;
                }
                ++n2;
            }
            object = iPackageFragmentRoot = iJavaProject.getResolvedClasspath(true);
            int n3 = ((IPackageFragmentRoot)object).length;
            n = 0;
            while (n < n3) {
                IPackageFragmentRoot iPackageFragmentRoot2 = object[n];
                switch (iPackageFragmentRoot2.getEntryKind()) {
                    case 1: {
                        Object object2;
                        String string2;
                        Object object3 = JavaCore.getResolvedClasspathEntry((IClasspathEntry)iPackageFragmentRoot2);
                        File file = object3.getPath().toFile();
                        IPath iPath2 = object3.getPath();
                        if (!file.exists()) {
                            string2 = iPath2.segment(0);
                            object2 = iJavaProject.getProject().getWorkspace().getRoot().getProject(string2);
                            iPath2 = object2.getLocation().append(iPath2.removeFirstSegments(1));
                        }
                        string2 = "jar:file:" + iPath2.toString() + "!/" + string;
                        try {
                            object2 = new URL(string2);
                            ((URL)object2).getContent();
                            return object2;
                        }
                        catch (Exception exception) {
                            break;
                        }
                    }
                    case 5: {
                        break;
                    }
                    case 4: {
                        Object object3 = ClassLoaderHelper.toURL(iPath.append(string));
                        if (object3 == null) break;
                        return object3;
                    }
                    case 2: {
                        Object object3;
                        if (!bl && !iPackageFragmentRoot2.isExported() || (object3 = ClassLoaderHelper.findResourceURL(ClassLoaderHelper.getJavaProject((IClasspathEntry)iPackageFragmentRoot2), set, false, string)) == null) break;
                        return object3;
                    }
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        return null;
    }

    private static URL toURL(IPath iPath) {
        File file = iPath.toFile();
        if (file != null && file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        return null;
    }

    private static void collectClasspathURLs(IJavaProject iJavaProject, List<URL> list, Set<IJavaProject> set, boolean bl) {
        if (set.contains(iJavaProject)) {
            return;
        }
        set.add(iJavaProject);
        try {
            IPath iPath = iJavaProject.getProject().getWorkspace().getRoot().getFullPath().append(iJavaProject.getOutputLocation());
            iPath = iPath.addTrailingSeparator();
            URL uRL = ClassLoaderHelper.createFileURL(iPath);
            list.add(uRL);
            IClasspathEntry[] iClasspathEntryArray = null;
            IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntryArray = iJavaProject.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray2[n2];
                switch (iClasspathEntry.getEntryKind()) {
                    case 1: 
                    case 4: 
                    case 5: {
                        ClassLoaderHelper.collectClasspathEntryURL(iClasspathEntry, list);
                        break;
                    }
                    case 2: {
                        if (!bl && !iClasspathEntry.isExported()) break;
                        ClassLoaderHelper.collectClasspathURLs(ClassLoaderHelper.getJavaProject(iClasspathEntry), list, set, false);
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            return;
        }
    }

    private static URL createFileURL(IPath iPath) {
        URL uRL = null;
        try {
            uRL = new URL("file://" + iPath.toOSString());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return uRL;
    }

    private static void collectClasspathEntryURL(IClasspathEntry iClasspathEntry, List<URL> list) {
        URL uRL = ClassLoaderHelper.createFileURL(iClasspathEntry.getPath());
        if (uRL != null) {
            list.add(uRL);
        }
    }

    private static IJavaProject getJavaProject(IClasspathEntry iClasspathEntry) {
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iClasspathEntry.getPath().segment(0));
        if (iProject != null) {
            return JavaCore.create((IProject)iProject);
        }
        return null;
    }
}

