/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.utils;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.xwt.ILogger;
import org.eclipse.e4.xwt.Tracking;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log
implements ILogger {
    private MessageConsoleStream messageConsoleStream = null;
    private Map<Tracking, String> messageMap = new HashMap<Tracking, String>();
    private MessageConsole console;

    private MessageConsoleStream getConsoleStream() {
        if (this.messageConsoleStream == null) {
            ConsolePlugin consolePlugin = ConsolePlugin.getDefault();
            if (consolePlugin == null) {
                return null;
            }
            this.console = new MessageConsole("XWT Application [XWT Application]", null);
            IConsoleManager iConsoleManager = consolePlugin.getConsoleManager();
            iConsoleManager.addConsoles(new IConsole[]{this.console});
            iConsoleManager.showConsoleView((IConsole)this.console);
            this.messageConsoleStream = this.console.newMessageStream();
            this.messageConsoleStream.setColor(Display.getDefault().getSystemColor(2));
        }
        return this.messageConsoleStream;
    }

    public void printInfo(String string, Tracking tracking, Set<Tracking> set) {
        String string2 = "";
        if (set != null && set.size() > 0 && set.contains(tracking)) {
            string2 = this.messageMap.get(tracking);
        }
        MessageConsoleStream messageConsoleStream = this.getConsoleStream();
        this.console.clearConsole();
        if (messageConsoleStream != null) {
            messageConsoleStream.print(string2);
        }
    }

    public void addMessage(String string, Tracking tracking) {
        if (this.messageMap.containsKey(tracking)) {
            this.messageMap.remove(tracking);
        }
        this.messageMap.put(tracking, string);
    }

    public void removeMessage(Tracking tracking) {
        if (this.messageMap.containsKey(tracking)) {
            this.messageMap.remove(tracking);
        }
    }

    public void error(Throwable throwable) {
        MessageConsoleStream messageConsoleStream = this.getConsoleStream();
        if (messageConsoleStream != null) {
            Color color = messageConsoleStream.getColor();
            messageConsoleStream.setColor(Display.getDefault().getSystemColor(3));
            PrintStream printStream = new PrintStream((OutputStream)messageConsoleStream);
            throwable.printStackTrace(printStream);
            messageConsoleStream.setColor(color);
        }
    }

    public void error(Throwable throwable, String string) {
        MessageConsoleStream messageConsoleStream = this.getConsoleStream();
        if (messageConsoleStream != null) {
            Color color = messageConsoleStream.getColor();
            messageConsoleStream.setColor(Display.getDefault().getSystemColor(3));
            PrintStream printStream = new PrintStream((OutputStream)messageConsoleStream);
            messageConsoleStream.print(string);
            throwable.printStackTrace(printStream);
            messageConsoleStream.setColor(color);
        }
    }

    public void message(String string) {
        MessageConsoleStream messageConsoleStream = this.getConsoleStream();
        if (messageConsoleStream != null) {
            messageConsoleStream.print(string);
        }
    }

    public void warning(String string) {
        this.message(string);
    }
}

