/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.utils;

import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.HashSet;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.e4.xwt.ui.utils.ClassLoaderHelper;
import org.eclipse.e4.xwt.ui.utils.LoadingContext;
import org.eclipse.jdt.core.IJavaProject;

public class ProjectContext
extends LoadingContext {
    protected static WeakHashMap<String, ProjectContext> contexts = new WeakHashMap();
    protected static IResourceChangeListener changeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            if (!contexts.isEmpty() && iResourceDelta != null) {
                this.processDelta(iResourceDelta);
            }
        }

        protected void processDelta(IResourceDelta iResourceDelta) {
            IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string;
                ProjectContext projectContext;
                IResourceDelta iResourceDelta2 = iResourceDeltaArray[n2];
                IProject iProject = iResourceDelta2.getResource().getProject();
                if (iProject != null && iProject.exists() && (projectContext = contexts.get(string = iProject.getName())) != null) {
                    projectContext.processDelta(iResourceDelta);
                } else {
                    this.processDelta(iResourceDelta2);
                }
                ++n2;
            }
        }
    };
    protected IJavaProject javaProject;
    protected HashSet<String> classes = new HashSet();

    private ProjectContext(IJavaProject iJavaProject) {
        this.javaProject = iJavaProject;
        this.resetLoader();
    }

    protected void resetLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.setClassLoader(new RuntimeLoader(classLoader));
        this.firePropertyChangeListener(new PropertyChangeEvent(this, "ClassLoader", null, this.getClassLoader()));
    }

    protected boolean processDelta(IResourceDelta iResourceDelta) {
        IResourceDelta[] iResourceDeltaArray;
        IResourceDelta[] iResourceDeltaArray2 = iResourceDeltaArray = iResourceDelta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath iPath;
            IResourceDelta iResourceDelta2 = iResourceDeltaArray2[n2];
            switch (iResourceDelta2.getKind()) {
                case 4: 
                case 4096: 
                case 8192: {
                    iPath = iResourceDelta2.getProjectRelativePath();
                    if (iPath.isEmpty() || !"class".equals(iPath.getFileExtension())) break;
                    this.resetLoader();
                    return true;
                }
            }
            IResourceDelta[] iResourceDeltaArray3 = iResourceDelta2.getAffectedChildren();
            int n3 = iResourceDeltaArray3.length;
            int n4 = 0;
            while (n4 < n3) {
                iPath = iResourceDeltaArray3[n4];
                IPath iPath2 = iPath.getProjectRelativePath();
                if (!iPath2.isEmpty() && "class".equals(iPath2.getFileExtension())) {
                    this.resetLoader();
                    return true;
                }
                if (this.processDelta((IResourceDelta)iPath)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static ProjectContext getContext(IJavaProject iJavaProject) {
        String string = iJavaProject.getElementName();
        ProjectContext projectContext = contexts.get(string);
        if (projectContext == null) {
            projectContext = new ProjectContext(iJavaProject);
            contexts.put(string, projectContext);
        }
        return projectContext;
    }

    public static void start() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(changeListener);
    }

    public static void stop() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(changeListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RuntimeLoader
    extends ClassLoader {
        public RuntimeLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        @Override
        protected Class<?> findClass(String string) throws ClassNotFoundException {
            Class<?> clazz = null;
            try {
                clazz = super.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (clazz == null) {
                    clazz = this.redefined(string);
                }
                if (clazz == null) {
                    throw classNotFoundException;
                }
                ProjectContext.this.classes.add(string);
            }
            return clazz;
        }

        public Class<?> redefined(String string) {
            try {
                byte[] byArray = ClassLoaderHelper.getClassContent(ProjectContext.this.javaProject, string);
                if (byArray != null) {
                    return this.defineClass(string, byArray, 0, byArray.length);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }

        @Override
        protected URL findResource(String string) {
            URL uRL = super.findResource(string);
            if (uRL == null) {
                uRL = ClassLoaderHelper.getResourceAsURL(ProjectContext.this.javaProject, string);
            }
            return uRL;
        }
    }
}

