/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.xwt.ui.ExceptionHandle;
import org.eclipse.e4.xwt.ui.XWTUIPlugin;
import org.eclipse.e4.xwt.ui.jdt.ProjectHelper;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class NewUIComponentWizardPage
extends NewClassWizardPage {
    public static final String VIEW_LOCATION = "Resources/vues/";
    protected TableViewer modelTableViewer;
    protected String superClass;
    protected IResource guiResource;

    public NewUIComponentWizardPage() {
        this.setTitle("New Wizard Creation");
        this.setDescription("This wizard creates a *.xwt file with java host class.");
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        int n = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        composite2.setLayout((Layout)gridLayout);
        this.createContainerControls(composite2, n);
        this.createPackageControls(composite2, n);
        this.createSeparator(composite2, n);
        this.createTypeNameControls(composite2, n);
        this.createSeparator(composite2, n);
        this.createCommentControls(composite2, n);
        this.enableCommentControl(true);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.jdt.ui.new_class_wizard_page_context");
    }

    public boolean isCreateConstructors() {
        return true;
    }

    protected void initTypePage(IJavaElement iJavaElement) {
        super.initTypePage(iJavaElement);
        this.setSuperClass(this.getSuperClassName(), false);
    }

    protected String getSuperClassName() {
        return Composite.class.getName();
    }

    protected void handleFieldChanged(String string) {
        super.handleFieldChanged(string);
        if (this.modelTableViewer != null && this.modelTableViewer.getSelection().isEmpty() && this.getErrorMessage() == null) {
            this.setErrorMessage("Veuillez selectionner le type de vue.");
        }
    }

    public int getModifiers() {
        return this.F_PUBLIC;
    }

    public String getSuperClass() {
        return super.getSuperClass();
    }

    public List getSuperInterfaces() {
        return Collections.EMPTY_LIST;
    }

    public boolean isCreateMain() {
        return false;
    }

    protected InputStream getContentStream() {
        Object object;
        IType iType = this.getCreatedType();
        String string = iType.getFullyQualifiedName();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.println("<j:" + iType.getElementName() + " xmlns=\"" + "http://www.eclipse.org/xwt/presentation" + "\"");
        if (string != null) {
            printStream.println("\t xmlns:x=\"http://www.eclipse.org/xwt\"");
            object = iType.getPackageFragment().getElementName();
            if (object != null) {
                printStream.println("\t xmlns:j=\"clr-namespace:" + (String)object + "\"");
            }
            printStream.println("\t x:Class=\"" + string + "\">");
        } else {
            printStream.println("\t xmlns:x=\"http://www.eclipse.org/xwt\">");
        }
        printStream.println("</j:" + iType.getElementName() + ">");
        try {
            object = byteArrayOutputStream.toByteArray();
            printStream.close();
            byteArrayOutputStream.close();
            return new ByteArrayInputStream((byte[])object);
        }
        catch (Exception exception) {
            XWTUIPlugin.log(exception);
            ExceptionHandle.handle(exception, "save failed in the file: " + this.getModifiedResource().getLocation());
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    public void createType(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        ProjectHelper.checkDependenceJars(this.getJavaProject());
        super.createType(iProgressMonitor);
        IResource iResource = this.getModifiedResource();
        IPath iPath = iResource.getProjectRelativePath().removeFileExtension();
        iPath = iPath.addFileExtension("xwt");
        try {
            IFile iFile = iResource.getProject().getFile(iPath);
            iFile.create(this.getContentStream(), 3, iProgressMonitor);
            this.guiResource = iFile;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ExceptionHandle.handle(exception, "save failed in the file: " + this.getModifiedResource().getLocation());
        }
    }

    public String getTypeName() {
        String string = super.getTypeName();
        if (string == null || string.equals("")) {
            return string;
        }
        return String.valueOf(Character.toUpperCase(string.charAt(0))) + string.substring(1);
    }

    public boolean isPageComplete() {
        if (this.modelTableViewer != null && this.modelTableViewer.getSelection().isEmpty()) {
            this.setErrorMessage("Please select a model type.");
            return false;
        }
        return super.isPageComplete();
    }

    public boolean isCreateInherited() {
        return true;
    }

    public IResource getGuiResource() {
        return this.guiResource;
    }
}

