/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.xwt.ui.ExceptionHandle;
import org.eclipse.e4.xwt.ui.XWTUIPlugin;
import org.eclipse.e4.xwt.ui.wizards.NewUIFileWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewUIFileWizard
extends Wizard
implements INewWizard {
    private NewUIFileWizardPage fileWizardPage;
    private IStructuredSelection selection;

    public NewUIFileWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New Widget File Wizard.");
    }

    public void addPages() {
        this.fileWizardPage = new NewUIFileWizardPage((ISelection)this.selection);
        this.addPage((IWizardPage)this.fileWizardPage);
    }

    public boolean performFinish() {
        final String string = this.fileWizardPage.getContainerName();
        final String string2 = this.fileWizardPage.getFileName();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    try {
                        NewUIFileWizard.this.doFinish(string, string2, iProgressMonitor);
                        NewUIFileWizard.this.tryToOpenPerspective();
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)throwable.getMessage());
            return false;
        }
        return true;
    }

    protected void tryToOpenPerspective() {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                XWTUIPlugin.getDefault().openXWTPerspective();
            }
        });
    }

    private void doFinish(String string, String string2, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask("Creating " + string2, 2);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember((IPath)new Path(string));
        if (!iResource.exists() || !(iResource instanceof IContainer)) {
            this.throwCoreException("Container \"" + string + "\" does not exist.");
        }
        IContainer iContainer = (IContainer)iResource;
        final IFile iFile = iContainer.getFile((IPath)new Path(string2));
        try {
            InputStream inputStream = this.openContentStream(iFile);
            if (iFile.exists()) {
                iFile.setContents(inputStream, true, true, iProgressMonitor);
            } else {
                iFile.create(inputStream, true, iProgressMonitor);
            }
            inputStream.close();
        }
        catch (IOException iOException) {}
        iProgressMonitor.worked(1);
        iProgressMonitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        iProgressMonitor.worked(1);
    }

    private InputStream openContentStream(IFile iFile) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.println("<Composite");
        printStream.println("\t xmlns=\"http://www.eclipse.org/xwt/presentation\"");
        printStream.println("\t xmlns:x=\"http://www.eclipse.org/xwt\">");
        printStream.println("</Composite>");
        try {
            byte[] byArray = byteArrayOutputStream.toByteArray();
            printStream.close();
            byteArrayOutputStream.close();
            return new ByteArrayInputStream(byArray);
        }
        catch (Exception exception) {
            XWTUIPlugin.log(exception);
            ExceptionHandle.handle(exception, "save failed in the file: " + this.fileWizardPage.getFileName());
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private void throwCoreException(String string) throws CoreException {
        Status status = new Status(4, "org.eclipse.e4.xwt.tools.ui", 0, string, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
    }
}

