/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewUIFileWizardPage
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private ISelection selection;

    protected NewUIFileWizardPage(ISelection iSelection) {
        super("NewWidgetFileWizardPage");
        this.setTitle("New Widget File Creation");
        this.setDescription("This wizard creates a new file with *.xwt extension.");
        this.selection = iSelection;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 9;
        Label label = new Label(composite2, 0);
        label.setText("&Container:");
        this.containerText = new Text(composite2, 2052);
        GridData gridData = new GridData(768);
        this.containerText.setLayoutData((Object)gridData);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewUIFileWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(composite2, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewUIFileWizardPage.this.handleBrowse();
            }
        });
        label = new Label(composite2, 0);
        label.setText("&File name:");
        this.fileText = new Text(composite2, 2052);
        gridData = new GridData(768);
        this.fileText.setLayoutData((Object)gridData);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewUIFileWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)composite2);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.selection;
            if (iStructuredSelection.size() > 1) {
                return;
            }
            IContainer iContainer = null;
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)object;
                IResource iResource = (IResource)iAdaptable.getAdapter(IResource.class);
                iContainer = iResource instanceof IContainer ? (IContainer)iResource : iResource.getParent();
            }
            if (object instanceof IResource) {
                iContainer = object instanceof IContainer ? (IContainer)object : ((IResource)object).getParent();
            }
            if (this.containerText != null) {
                this.containerText.setText(iContainer.getFullPath().toString());
            }
        }
        this.fileText.setText("NewWidget.xwt");
    }

    private void handleBrowse() {
        Object[] objectArray;
        ContainerSelectionDialog containerSelectionDialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (containerSelectionDialog.open() == 0 && (objectArray = containerSelectionDialog.getResult()).length == 1) {
            this.containerText.setText(((Path)objectArray[0]).toString());
        }
    }

    private void dialogChanged() {
        String string;
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String string2 = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (iResource == null || (iResource.getType() & 6) == 0) {
            this.updateStatus("File container must exist");
            return;
        }
        if (!iResource.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (string2.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (string2.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must be valid");
            return;
        }
        int n = string2.lastIndexOf(46);
        if (n != -1 && !(string = string2.substring(n + 1)).equalsIgnoreCase("xwt")) {
            this.updateStatus("File extension must be \"xwt\"");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String string) {
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }
}

