/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.css;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.engine.CSSErrorHandler;
import org.eclipse.e4.xwt.IStyle;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.css.CSSXWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCSSStyle
implements IStyle,
CSSErrorHandler {
    protected URL url;
    protected String content;
    private CSSEngine engine;
    private Display display;
    private Class<?> jfaceViewerClass;
    private Method getControl;

    public AbstractCSSStyle() {
        this((String)null);
    }

    public AbstractCSSStyle(URL uRL) {
        this.url = uRL;
        this.init();
    }

    public AbstractCSSStyle(String string) {
        this.content = string;
        this.init();
    }

    public AbstractCSSStyle(CSSEngine cSSEngine) {
        this.engine = cSSEngine;
        this.init();
    }

    private void init() {
        try {
            this.jfaceViewerClass = Class.forName("org.eclipse.jface.viewers.Viewer");
            this.getControl = this.jfaceViewerClass.getMethod("getControl", new Class[0]);
        }
        catch (Throwable throwable) {}
    }

    public void initializeIfNeed(Control control) {
        block11: {
            Display display = control.getDisplay();
            if (this.display != null && this.display == display) {
                return;
            }
            this.display = display;
            try {
                Serializable serializable;
                if (this.engine == null) {
                    this.engine = CSSXWT.getCSSEngine((Widget)control);
                    if (this.engine == null) {
                        this.engine = this.createCSSEngine(display);
                        CSSXWT.setCSSEngine(control.getShell(), this.engine);
                    }
                }
                this.engine.setErrorHandler((CSSErrorHandler)this);
                if (this.content != null) {
                    this.engine.parseStyleSheet((Reader)new StringReader(this.content));
                    break block11;
                }
                Method method = null;
                try {
                    serializable = this.loadClass("org.eclipse.core.runtime.FileLocator");
                    method = ((Class)serializable).getMethod("resolve", URL.class);
                }
                catch (Throwable throwable) {}
                serializable = this.url;
                if (method != null) {
                    try {
                        serializable = (URL)method.invoke(null, serializable);
                    }
                    catch (Throwable throwable) {}
                }
                InputStream inputStream = ((URL)serializable).openStream();
                this.engine.parseStyleSheet(inputStream);
                inputStream.close();
            }
            catch (Throwable throwable) {
                System.err.println("Warning - could not initialize CSS styling : " + throwable.toString());
            }
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        if (this.url == uRL || this.url != null && this.url.equals(uRL)) {
            return;
        }
        this.url = uRL;
        this.reset();
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        if (this.content == string || this.content != null && this.content.equals(string)) {
            return;
        }
        this.content = string;
        this.reset();
    }

    protected void reset() {
        this.display = null;
        if (this.engine != null) {
            this.engine.reset();
            this.engine = null;
        }
    }

    public void applyStyle(Object object) {
        if (this.url == null && this.content == null && this.engine == null) {
            return;
        }
        String string = XWT.getElementName((Object)object);
        Control control = null;
        if (object instanceof Control) {
            control = (Control)object;
        } else if (this.getControl != null && this.jfaceViewerClass.isInstance(object)) {
            try {
                control = (Control)this.getControl.invoke(object, new Object[0]);
            }
            catch (Throwable throwable) {
                throw new XWTException(throwable);
            }
        }
        if (control != null) {
            this.initializeIfNeed(control);
            if (string != null) {
                control.setData("org.eclipse.e4.ui.css.id", (Object)string);
            }
            try {
                this.engine.applyStyles((Object)control, false, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public CSSEngine getEngine() {
        return this.engine;
    }

    public void error(Exception exception) {
        throw new XWTException((Throwable)exception);
    }

    protected Class<?> loadClass(String string) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Thread.currentThread().getContextClassLoader().loadClass(string);
        }
    }

    protected abstract CSSEngine createCSSEngine(Display var1);
}

