/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dtree;

import org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import org.eclipse.core.internal.dtree.DataTreeLookup;
import org.eclipse.core.internal.dtree.ObjectNotFoundException;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractDataTree {
    private boolean immutable = false;
    protected static final IPath[] NO_CHILDREN = new IPath[0];

    public AbstractDataTree() {
        this.empty();
    }

    protected AbstractDataTree copy() {
        AbstractDataTree abstractDataTree = this.createInstance();
        abstractDataTree.setImmutable(this.isImmutable());
        abstractDataTree.setRootNode(this.getRootNode());
        return abstractDataTree;
    }

    public abstract AbstractDataTreeNode copyCompleteSubtree(IPath var1);

    public abstract void createChild(IPath var1, String var2);

    public abstract void createChild(IPath var1, String var2, Object var3);

    protected abstract AbstractDataTree createInstance();

    public abstract void createSubtree(IPath var1, AbstractDataTreeNode var2);

    public abstract void deleteChild(IPath var1, String var2);

    public abstract void empty();

    public IPath getChild(IPath iPath, int n) {
        String string = this.getNameOfChild(iPath, n);
        return iPath.append(string);
    }

    public int getChildCount(IPath iPath) {
        return this.getNamesOfChildren(iPath).length;
    }

    public IPath[] getChildren(IPath iPath) {
        String[] stringArray = this.getNamesOfChildren(iPath);
        int n = stringArray.length;
        if (n == 0) {
            return NO_CHILDREN;
        }
        IPath[] iPathArray = new IPath[n];
        int n2 = 0;
        while (n2 < n) {
            iPathArray[n2] = iPath.append(stringArray[n2]);
            ++n2;
        }
        return iPathArray;
    }

    public abstract Object getData(IPath var1);

    public String getNameOfChild(IPath iPath, int n) {
        String[] stringArray = this.getNamesOfChildren(iPath);
        return stringArray[n];
    }

    public abstract String[] getNamesOfChildren(IPath var1);

    AbstractDataTreeNode getRootNode() {
        throw new AbstractMethodError(Messages.dtree_subclassImplement);
    }

    static void handleImmutableTree() {
        throw new RuntimeException(Messages.dtree_immutable);
    }

    static void handleNotFound(IPath iPath) {
        throw new ObjectNotFoundException(NLS.bind((String)Messages.dtree_notFound, (Object)iPath));
    }

    public void immutable() {
        this.immutable = true;
    }

    public abstract boolean includes(IPath var1);

    public boolean isImmutable() {
        return this.immutable;
    }

    public abstract DataTreeLookup lookup(IPath var1);

    public IPath rootKey() {
        return Path.ROOT;
    }

    public abstract void setData(IPath var1, Object var2);

    void setImmutable(boolean bl) {
        this.immutable = bl;
    }

    void setRootNode(AbstractDataTreeNode abstractDataTreeNode) {
        throw new Error(Messages.dtree_subclassImplement);
    }
}

