/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dtree;

import org.eclipse.core.internal.dtree.DataDeltaNode;
import org.eclipse.core.internal.dtree.DataTreeNode;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.dtree.IComparator;
import org.eclipse.core.internal.dtree.NoDataDeltaNode;
import org.eclipse.core.internal.dtree.NodeComparison;
import org.eclipse.core.internal.dtree.ObjectNotFoundException;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.StringPool;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractDataTreeNode {
    static final AbstractDataTreeNode[] NO_CHILDREN = new AbstractDataTreeNode[0];
    protected AbstractDataTreeNode[] children;
    protected String name;
    public static final int T_COMPLETE_NODE = 0;
    public static final int T_DELTA_NODE = 1;
    public static final int T_DELETED_NODE = 2;
    public static final int T_NO_DATA_DELTA_NODE = 3;

    AbstractDataTreeNode(String string, AbstractDataTreeNode[] abstractDataTreeNodeArray) {
        this.name = string;
        this.children = abstractDataTreeNodeArray == null || abstractDataTreeNodeArray.length == 0 ? NO_CHILDREN : abstractDataTreeNodeArray;
    }

    abstract AbstractDataTreeNode asBackwardDelta(DeltaDataTree var1, DeltaDataTree var2, IPath var3);

    AbstractDataTreeNode asReverseComparisonNode(IComparator iComparator) {
        return this;
    }

    static AbstractDataTreeNode[] assembleWith(AbstractDataTreeNode[] abstractDataTreeNodeArray, AbstractDataTreeNode[] abstractDataTreeNodeArray2, boolean bl) {
        if (abstractDataTreeNodeArray2.length == 0) {
            return abstractDataTreeNodeArray;
        }
        AbstractDataTreeNode[] abstractDataTreeNodeArray3 = new AbstractDataTreeNode[abstractDataTreeNodeArray.length + abstractDataTreeNodeArray2.length];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < abstractDataTreeNodeArray.length && n2 < abstractDataTreeNodeArray2.length) {
            AbstractDataTreeNode abstractDataTreeNode;
            int n4 = abstractDataTreeNodeArray[n].name.compareTo(abstractDataTreeNodeArray2[n2].name);
            if (n4 == 0) {
                if ((abstractDataTreeNode = abstractDataTreeNodeArray[n++].assembleWith(abstractDataTreeNodeArray2[n2++])) == null || abstractDataTreeNode.isDeleted() && !bl) continue;
                abstractDataTreeNodeArray3[n3++] = abstractDataTreeNode;
                continue;
            }
            if (n4 < 0) {
                abstractDataTreeNodeArray3[n3++] = abstractDataTreeNodeArray[n++];
                continue;
            }
            if (n4 <= 0 || (abstractDataTreeNode = abstractDataTreeNodeArray2[n2++]).isDeleted() && !bl) continue;
            abstractDataTreeNodeArray3[n3++] = abstractDataTreeNode;
        }
        while (n < abstractDataTreeNodeArray.length) {
            abstractDataTreeNodeArray3[n3++] = abstractDataTreeNodeArray[n++];
        }
        while (n2 < abstractDataTreeNodeArray2.length) {
            AbstractDataTreeNode abstractDataTreeNode;
            if ((abstractDataTreeNode = abstractDataTreeNodeArray2[n2++]).isDeleted() && !bl) continue;
            abstractDataTreeNodeArray3[n3++] = abstractDataTreeNode;
        }
        if (n3 < abstractDataTreeNodeArray3.length) {
            AbstractDataTreeNode[] abstractDataTreeNodeArray4 = abstractDataTreeNodeArray3;
            abstractDataTreeNodeArray3 = new AbstractDataTreeNode[n3];
            System.arraycopy(abstractDataTreeNodeArray4, 0, abstractDataTreeNodeArray3, 0, n3);
        }
        return abstractDataTreeNodeArray3;
    }

    AbstractDataTreeNode assembleWith(AbstractDataTreeNode abstractDataTreeNode) {
        if (!abstractDataTreeNode.isDelta() || this.isDeleted()) {
            return abstractDataTreeNode;
        }
        if (abstractDataTreeNode.hasData()) {
            if (this.isDelta()) {
                AbstractDataTreeNode[] abstractDataTreeNodeArray = AbstractDataTreeNode.assembleWith(this.children, abstractDataTreeNode.children, true);
                return new DataDeltaNode(this.name, abstractDataTreeNode.getData(), abstractDataTreeNodeArray);
            }
            AbstractDataTreeNode[] abstractDataTreeNodeArray = AbstractDataTreeNode.assembleWith(this.children, abstractDataTreeNode.children, false);
            return new DataTreeNode(this.name, abstractDataTreeNode.getData(), abstractDataTreeNodeArray);
        }
        if (this.isDelta()) {
            AbstractDataTreeNode[] abstractDataTreeNodeArray = AbstractDataTreeNode.assembleWith(this.children, abstractDataTreeNode.children, true);
            if (this.hasData()) {
                return new DataDeltaNode(this.name, this.getData(), abstractDataTreeNodeArray);
            }
            return new NoDataDeltaNode(this.name, abstractDataTreeNodeArray);
        }
        AbstractDataTreeNode[] abstractDataTreeNodeArray = AbstractDataTreeNode.assembleWith(this.children, abstractDataTreeNode.children, false);
        return new DataTreeNode(this.name, this.getData(), abstractDataTreeNodeArray);
    }

    AbstractDataTreeNode assembleWith(AbstractDataTreeNode abstractDataTreeNode, IPath iPath, int n) {
        int n2 = iPath.segmentCount();
        if (n == n2) {
            return this.assembleWith(abstractDataTreeNode);
        }
        int n3 = this.indexOfChild(iPath.segment(n));
        if (n3 >= 0) {
            AbstractDataTreeNode abstractDataTreeNode2 = this.copy();
            abstractDataTreeNode2.children[n3] = this.children[n3].assembleWith(abstractDataTreeNode, iPath, n + 1);
            return abstractDataTreeNode2;
        }
        int n4 = n2 - 2;
        while (n4 >= n) {
            abstractDataTreeNode = new NoDataDeltaNode(iPath.segment(n4), abstractDataTreeNode);
            --n4;
        }
        abstractDataTreeNode = new NoDataDeltaNode(this.name, abstractDataTreeNode);
        return this.assembleWith(abstractDataTreeNode);
    }

    AbstractDataTreeNode childAt(String string) {
        AbstractDataTreeNode abstractDataTreeNode = this.childAtOrNull(string);
        if (abstractDataTreeNode != null) {
            return abstractDataTreeNode;
        }
        throw new ObjectNotFoundException(NLS.bind((String)Messages.dtree_missingChild, (Object)string));
    }

    AbstractDataTreeNode childAtOrNull(String string) {
        int n = this.indexOfChild(string);
        return n >= 0 ? this.children[n] : null;
    }

    AbstractDataTreeNode childAtIgnoreCase(String string) {
        AbstractDataTreeNode abstractDataTreeNode = null;
        int n = 0;
        while (n < this.children.length) {
            if (this.children[n].getName().equalsIgnoreCase(string)) {
                if (this.children[n].isDeleted()) {
                    abstractDataTreeNode = this.children[n];
                } else {
                    return this.children[n];
                }
            }
            ++n;
        }
        return abstractDataTreeNode;
    }

    protected static AbstractDataTreeNode[] compareWith(AbstractDataTreeNode[] abstractDataTreeNodeArray, AbstractDataTreeNode[] abstractDataTreeNodeArray2, IComparator iComparator) {
        DataTreeNode dataTreeNode;
        int n = abstractDataTreeNodeArray.length;
        int n2 = abstractDataTreeNodeArray2.length;
        int n3 = 0;
        int n4 = 0;
        AbstractDataTreeNode[] abstractDataTreeNodeArray3 = new AbstractDataTreeNode[n + n2];
        int n5 = 0;
        while (n3 < n && n4 < n2) {
            dataTreeNode = (DataTreeNode)abstractDataTreeNodeArray[n3];
            DataTreeNode dataTreeNode2 = (DataTreeNode)abstractDataTreeNodeArray2[n4];
            int n6 = dataTreeNode.name.compareTo(dataTreeNode2.name);
            if (n6 < 0) {
                int n7 = iComparator.compare(dataTreeNode.getData(), null);
                if (n7 != 0) {
                    abstractDataTreeNodeArray3[n5++] = AbstractDataTreeNode.convertToRemovedComparisonNode(dataTreeNode, n7);
                }
                ++n3;
                continue;
            }
            if (n6 > 0) {
                int n8 = iComparator.compare(null, dataTreeNode2.getData());
                if (n8 != 0) {
                    abstractDataTreeNodeArray3[n5++] = AbstractDataTreeNode.convertToAddedComparisonNode(dataTreeNode2, n8);
                }
                ++n4;
                continue;
            }
            AbstractDataTreeNode abstractDataTreeNode = dataTreeNode.compareWith(dataTreeNode2, iComparator);
            NodeComparison nodeComparison = (NodeComparison)abstractDataTreeNode.getData();
            if (!nodeComparison.isUnchanged() || abstractDataTreeNode.size() != 0) {
                abstractDataTreeNodeArray3[n5++] = abstractDataTreeNode;
            }
            ++n3;
            ++n4;
        }
        while (n3 < n) {
            int n9;
            if ((n9 = iComparator.compare((dataTreeNode = (DataTreeNode)abstractDataTreeNodeArray[n3++]).getData(), null)) == 0) continue;
            abstractDataTreeNodeArray3[n5++] = AbstractDataTreeNode.convertToRemovedComparisonNode(dataTreeNode, n9);
        }
        while (n4 < n2) {
            int n10;
            if ((n10 = iComparator.compare(null, (dataTreeNode = (DataTreeNode)abstractDataTreeNodeArray2[n4++]).getData())) == 0) continue;
            abstractDataTreeNodeArray3[n5++] = AbstractDataTreeNode.convertToAddedComparisonNode(dataTreeNode, n10);
        }
        if (n5 == 0) {
            return NO_CHILDREN;
        }
        if (n5 < abstractDataTreeNodeArray3.length) {
            AbstractDataTreeNode[] abstractDataTreeNodeArray4 = abstractDataTreeNodeArray3;
            abstractDataTreeNodeArray3 = new AbstractDataTreeNode[n5];
            System.arraycopy(abstractDataTreeNodeArray4, 0, abstractDataTreeNodeArray3, 0, n5);
        }
        return abstractDataTreeNodeArray3;
    }

    protected static AbstractDataTreeNode[] compareWithParent(AbstractDataTreeNode[] abstractDataTreeNodeArray, IPath iPath, DeltaDataTree deltaDataTree, IComparator iComparator) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray2 = new AbstractDataTreeNode[abstractDataTreeNodeArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < abstractDataTreeNodeArray.length) {
            AbstractDataTreeNode abstractDataTreeNode = abstractDataTreeNodeArray[n2];
            AbstractDataTreeNode abstractDataTreeNode2 = abstractDataTreeNode.compareWithParent(iPath.append(abstractDataTreeNode.getName()), deltaDataTree, iComparator);
            NodeComparison nodeComparison = (NodeComparison)abstractDataTreeNode2.getData();
            if (!nodeComparison.isUnchanged() || abstractDataTreeNode2.size() != 0) {
                abstractDataTreeNodeArray2[n++] = abstractDataTreeNode2;
            }
            ++n2;
        }
        if (n == 0) {
            return NO_CHILDREN;
        }
        if (n < abstractDataTreeNodeArray2.length) {
            AbstractDataTreeNode[] abstractDataTreeNodeArray3 = abstractDataTreeNodeArray2;
            abstractDataTreeNodeArray2 = new AbstractDataTreeNode[n];
            System.arraycopy(abstractDataTreeNodeArray3, 0, abstractDataTreeNodeArray2, 0, n);
        }
        return abstractDataTreeNodeArray2;
    }

    abstract AbstractDataTreeNode compareWithParent(IPath var1, DeltaDataTree var2, IComparator var3);

    static AbstractDataTreeNode convertToAddedComparisonNode(AbstractDataTreeNode abstractDataTreeNode, int n) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray;
        AbstractDataTreeNode[] abstractDataTreeNodeArray2 = abstractDataTreeNode.getChildren();
        int n2 = abstractDataTreeNodeArray2.length;
        if (n2 == 0) {
            abstractDataTreeNodeArray = NO_CHILDREN;
        } else {
            abstractDataTreeNodeArray = new AbstractDataTreeNode[n2];
            int n3 = 0;
            while (n3 < n2) {
                abstractDataTreeNodeArray[n3] = AbstractDataTreeNode.convertToAddedComparisonNode(abstractDataTreeNodeArray2[n3], n);
                ++n3;
            }
        }
        return new DataTreeNode(abstractDataTreeNode.name, new NodeComparison(null, abstractDataTreeNode.getData(), 1, n), abstractDataTreeNodeArray);
    }

    static AbstractDataTreeNode convertToRemovedComparisonNode(AbstractDataTreeNode abstractDataTreeNode, int n) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray;
        AbstractDataTreeNode[] abstractDataTreeNodeArray2 = abstractDataTreeNode.getChildren();
        int n2 = abstractDataTreeNodeArray2.length;
        if (n2 == 0) {
            abstractDataTreeNodeArray = NO_CHILDREN;
        } else {
            abstractDataTreeNodeArray = new AbstractDataTreeNode[n2];
            int n3 = 0;
            while (n3 < n2) {
                abstractDataTreeNodeArray[n3] = AbstractDataTreeNode.convertToRemovedComparisonNode(abstractDataTreeNodeArray2[n3], n);
                ++n3;
            }
        }
        return new DataTreeNode(abstractDataTreeNode.name, new NodeComparison(abstractDataTreeNode.getData(), null, 2, n), abstractDataTreeNodeArray);
    }

    abstract AbstractDataTreeNode copy();

    protected void copyChildren(int n, int n2, AbstractDataTreeNode abstractDataTreeNode, int n3) {
        int n4 = n3;
        int n5 = n;
        while (n5 <= n2) {
            this.children[n5] = abstractDataTreeNode.children[n4];
            ++n5;
            ++n4;
        }
    }

    public AbstractDataTreeNode[] getChildren() {
        return this.children;
    }

    Object getData() {
        throw new AbstractMethodError(Messages.dtree_subclassImplement);
    }

    public String getName() {
        return this.name;
    }

    boolean hasData() {
        return false;
    }

    boolean includesChild(String string) {
        return this.indexOfChild(string) != -1;
    }

    protected int indexOfChild(String string) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray = this.children;
        int n = 0;
        int n2 = abstractDataTreeNodeArray.length - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            int n4 = string.compareTo(abstractDataTreeNodeArray[n3].name);
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return n3;
        }
        return -1;
    }

    boolean isDeleted() {
        return false;
    }

    boolean isDelta() {
        return false;
    }

    boolean isEmptyDelta() {
        return false;
    }

    String[] namesOfChildren() {
        String[] stringArray = new String[this.children.length];
        int n = this.children.length;
        while (--n >= 0) {
            stringArray[n] = this.children[n].getName();
        }
        return stringArray;
    }

    void replaceChild(String string, DataTreeNode dataTreeNode) {
        int n = this.indexOfChild(string);
        if (n < 0) {
            throw new ObjectNotFoundException(NLS.bind((String)Messages.dtree_missingChild, (Object)string));
        }
        this.children[n] = dataTreeNode;
    }

    protected void setChildren(AbstractDataTreeNode[] abstractDataTreeNodeArray) {
        this.children = abstractDataTreeNodeArray;
    }

    void setName(String string) {
        this.name = string;
    }

    protected static AbstractDataTreeNode[] simplifyWithParent(AbstractDataTreeNode[] abstractDataTreeNodeArray, IPath iPath, DeltaDataTree deltaDataTree, IComparator iComparator) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray2 = new AbstractDataTreeNode[abstractDataTreeNodeArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < abstractDataTreeNodeArray.length) {
            AbstractDataTreeNode abstractDataTreeNode = abstractDataTreeNodeArray[n2];
            AbstractDataTreeNode abstractDataTreeNode2 = abstractDataTreeNode.simplifyWithParent(iPath.append(abstractDataTreeNode.getName()), deltaDataTree, iComparator);
            if (!abstractDataTreeNode2.isEmptyDelta()) {
                abstractDataTreeNodeArray2[n++] = abstractDataTreeNode2;
            }
            ++n2;
        }
        if (n == 0) {
            return NO_CHILDREN;
        }
        if (n < abstractDataTreeNodeArray2.length) {
            AbstractDataTreeNode[] abstractDataTreeNodeArray3 = abstractDataTreeNodeArray2;
            abstractDataTreeNodeArray2 = new AbstractDataTreeNode[n];
            System.arraycopy(abstractDataTreeNodeArray3, 0, abstractDataTreeNodeArray2, 0, n);
        }
        return abstractDataTreeNodeArray2;
    }

    abstract AbstractDataTreeNode simplifyWithParent(IPath var1, DeltaDataTree var2, IComparator var3);

    int size() {
        return this.children.length;
    }

    public void storeStrings(StringPool stringPool) {
        this.name = stringPool.add(this.name);
        AbstractDataTreeNode[] abstractDataTreeNodeArray = this.children;
        if (abstractDataTreeNodeArray != null) {
            int n = abstractDataTreeNodeArray.length;
            while (--n >= 0) {
                abstractDataTreeNodeArray[n].storeStrings(stringPool);
            }
        }
    }

    public String toString() {
        return "an AbstractDataTreeNode(" + this.getName() + ") with " + this.getChildren().length + " children.";
    }

    abstract int type();
}

