/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dtree;

import org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import org.eclipse.core.internal.dtree.DataTreeNode;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.dtree.IComparator;
import org.eclipse.core.internal.dtree.NoDataDeltaNode;
import org.eclipse.core.internal.dtree.NodeComparison;
import org.eclipse.core.runtime.IPath;

public class DataDeltaNode
extends DataTreeNode {
    DataDeltaNode(String string, Object object) {
        super(string, object);
    }

    DataDeltaNode(String string, Object object, AbstractDataTreeNode[] abstractDataTreeNodeArray) {
        super(string, object, abstractDataTreeNodeArray);
    }

    AbstractDataTreeNode asBackwardDelta(DeltaDataTree deltaDataTree, DeltaDataTree deltaDataTree2, IPath iPath) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray;
        if (this.children.length == 0) {
            abstractDataTreeNodeArray = NO_CHILDREN;
        } else {
            abstractDataTreeNodeArray = new AbstractDataTreeNode[this.children.length];
            int n = this.children.length;
            while (--n >= 0) {
                abstractDataTreeNodeArray[n] = this.children[n].asBackwardDelta(deltaDataTree, deltaDataTree2, iPath.append(this.children[n].getName()));
            }
        }
        return new DataDeltaNode(this.name, deltaDataTree2.getData(iPath), abstractDataTreeNodeArray);
    }

    AbstractDataTreeNode compareWithParent(IPath iPath, DeltaDataTree deltaDataTree, IComparator iComparator) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray = DataDeltaNode.compareWithParent(this.children, iPath, deltaDataTree, iComparator);
        Object object = deltaDataTree.getData(iPath);
        Object object2 = this.data;
        int n = 0;
        if (iPath != deltaDataTree.rootKey()) {
            n = iComparator.compare(object, object2);
        }
        return new DataTreeNode(iPath.lastSegment(), new NodeComparison(object, object2, 4, n), abstractDataTreeNodeArray);
    }

    AbstractDataTreeNode copy() {
        AbstractDataTreeNode[] abstractDataTreeNodeArray;
        if (this.children.length == 0) {
            abstractDataTreeNodeArray = NO_CHILDREN;
        } else {
            abstractDataTreeNodeArray = new AbstractDataTreeNode[this.children.length];
            System.arraycopy(this.children, 0, abstractDataTreeNodeArray, 0, this.children.length);
        }
        return new DataDeltaNode(this.name, this.data, abstractDataTreeNodeArray);
    }

    boolean isDelta() {
        return true;
    }

    AbstractDataTreeNode simplifyWithParent(IPath iPath, DeltaDataTree deltaDataTree, IComparator iComparator) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray = DataDeltaNode.simplifyWithParent(this.children, iPath, deltaDataTree, iComparator);
        if (!iPath.isRoot() && iComparator.compare(deltaDataTree.getData(iPath), this.data) == 0) {
            return new NoDataDeltaNode(this.name, abstractDataTreeNodeArray);
        }
        return new DataDeltaNode(this.name, this.data, abstractDataTreeNodeArray);
    }

    public String toString() {
        return "a DataDeltaNode(" + this.getName() + ") with " + this.getChildren().length + " children.";
    }

    int type() {
        return 1;
    }
}

