/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dtree;

import org.eclipse.core.internal.dtree.AbstractDataTree;
import org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import org.eclipse.core.internal.dtree.DataTreeLookup;
import org.eclipse.core.internal.dtree.DataTreeNode;
import org.eclipse.core.internal.dtree.ObjectNotFoundException;
import org.eclipse.core.runtime.IPath;

public class DataTree
extends AbstractDataTree {
    private DataTreeNode rootNode;

    public DataTree() {
        this.empty();
    }

    public AbstractDataTreeNode copyCompleteSubtree(IPath iPath) {
        DataTreeNode dataTreeNode = this.findNodeAt(iPath);
        if (dataTreeNode == null) {
            DataTree.handleNotFound(iPath);
        }
        return this.copyHierarchy(dataTreeNode);
    }

    DataTreeNode copyHierarchy(DataTreeNode dataTreeNode) {
        DataTreeNode dataTreeNode2;
        int n = dataTreeNode.size();
        if (n == 0) {
            dataTreeNode2 = new DataTreeNode(dataTreeNode.getName(), dataTreeNode.getData());
        } else {
            AbstractDataTreeNode[] abstractDataTreeNodeArray = dataTreeNode.getChildren();
            AbstractDataTreeNode[] abstractDataTreeNodeArray2 = new DataTreeNode[n];
            int n2 = n;
            while (--n2 >= 0) {
                abstractDataTreeNodeArray2[n2] = this.copyHierarchy((DataTreeNode)abstractDataTreeNodeArray[n2]);
            }
            dataTreeNode2 = new DataTreeNode(dataTreeNode.getName(), dataTreeNode.getData(), abstractDataTreeNodeArray2);
        }
        return dataTreeNode2;
    }

    public void createChild(IPath iPath, String string) {
        this.createChild(iPath, string, null);
    }

    public void createChild(IPath iPath, String string, Object object) {
        DataTreeNode dataTreeNode = this.findNodeAt(iPath);
        if (dataTreeNode == null) {
            DataTree.handleNotFound(iPath);
        }
        if (this.isImmutable()) {
            DataTree.handleImmutableTree();
        }
        if (dataTreeNode.includesChild(string)) {
            dataTreeNode.replaceChild(string, new DataTreeNode(string, object));
        } else {
            this.replaceNode(iPath, dataTreeNode.copyWithNewChild(string, new DataTreeNode(string, object)));
        }
    }

    protected AbstractDataTree createInstance() {
        return new DataTree();
    }

    public void createSubtree(IPath iPath, AbstractDataTreeNode abstractDataTreeNode) {
        DataTreeNode dataTreeNode = this.copyHierarchy((DataTreeNode)abstractDataTreeNode);
        if (this.isImmutable()) {
            DataTree.handleImmutableTree();
        }
        if (iPath.isRoot()) {
            this.setRootNode(dataTreeNode);
        } else {
            String string = iPath.lastSegment();
            dataTreeNode.setName(string);
            IPath iPath2 = iPath.removeLastSegments(1);
            DataTreeNode dataTreeNode2 = this.findNodeAt(iPath2);
            if (dataTreeNode2 == null) {
                DataTree.handleNotFound(iPath2);
            }
            if (dataTreeNode2.includesChild(string)) {
                dataTreeNode2.replaceChild(string, dataTreeNode);
            }
            this.replaceNode(iPath2, dataTreeNode2.copyWithNewChild(string, dataTreeNode));
        }
    }

    public void deleteChild(IPath iPath, String string) {
        DataTreeNode dataTreeNode;
        if (this.isImmutable()) {
            DataTree.handleImmutableTree();
        }
        if ((dataTreeNode = this.findNodeAt(iPath)) == null || !dataTreeNode.includesChild(string)) {
            DataTree.handleNotFound(dataTreeNode == null ? iPath : iPath.append(string));
        } else {
            this.replaceNode(iPath, dataTreeNode.copyWithoutChild(string));
        }
    }

    public void empty() {
        this.setRootNode(new DataTreeNode(null, (Object)null));
    }

    public DataTreeNode findNodeAt(IPath iPath) {
        AbstractDataTreeNode abstractDataTreeNode = this.getRootNode();
        int n = iPath.segmentCount();
        int n2 = 0;
        while (n2 < n) {
            try {
                abstractDataTreeNode = abstractDataTreeNode.childAt(iPath.segment(n2));
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                return null;
            }
            ++n2;
        }
        return (DataTreeNode)abstractDataTreeNode;
    }

    public Object getData(IPath iPath) {
        DataTreeNode dataTreeNode = this.findNodeAt(iPath);
        if (dataTreeNode == null) {
            DataTree.handleNotFound(iPath);
            return null;
        }
        return dataTreeNode.getData();
    }

    public String[] getNamesOfChildren(IPath iPath) {
        DataTreeNode dataTreeNode = this.findNodeAt(iPath);
        if (dataTreeNode == null) {
            DataTree.handleNotFound(iPath);
            return null;
        }
        return dataTreeNode.namesOfChildren();
    }

    AbstractDataTreeNode getRootNode() {
        return this.rootNode;
    }

    public boolean includes(IPath iPath) {
        return this.findNodeAt(iPath) != null;
    }

    public DataTreeLookup lookup(IPath iPath) {
        DataTreeNode dataTreeNode = this.findNodeAt(iPath);
        if (dataTreeNode == null) {
            return DataTreeLookup.newLookup(iPath, false, null);
        }
        return DataTreeLookup.newLookup(iPath, true, dataTreeNode.getData());
    }

    protected void replaceNode(IPath iPath, DataTreeNode dataTreeNode) {
        if (iPath.isRoot()) {
            this.setRootNode(dataTreeNode);
        } else {
            DataTreeNode dataTreeNode2 = this.findNodeAt(iPath.removeLastSegments(1));
            dataTreeNode2.replaceChild(iPath.lastSegment(), dataTreeNode);
        }
    }

    public void setData(IPath iPath, Object object) {
        DataTreeNode dataTreeNode = this.findNodeAt(iPath);
        if (this.isImmutable()) {
            DataTree.handleImmutableTree();
        }
        if (dataTreeNode == null) {
            DataTree.handleNotFound(iPath);
        } else {
            dataTreeNode.setData(object);
        }
    }

    void setRootNode(DataTreeNode dataTreeNode) {
        this.rootNode = dataTreeNode;
    }
}

