/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dtree;

import org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import org.eclipse.core.internal.dtree.DataDeltaNode;
import org.eclipse.core.internal.dtree.DeletedNode;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.dtree.IComparator;
import org.eclipse.core.internal.dtree.NoDataDeltaNode;
import org.eclipse.core.internal.dtree.NodeComparison;
import org.eclipse.core.internal.utils.IStringPoolParticipant;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.StringPool;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

public class DataTreeNode
extends AbstractDataTreeNode {
    protected Object data;

    public DataTreeNode(String string, Object object) {
        super(string, AbstractDataTreeNode.NO_CHILDREN);
        this.data = object;
    }

    public DataTreeNode(String string, Object object, AbstractDataTreeNode[] abstractDataTreeNodeArray) {
        super(string, abstractDataTreeNodeArray);
        this.data = object;
    }

    AbstractDataTreeNode asBackwardDelta(DeltaDataTree deltaDataTree, DeltaDataTree deltaDataTree2, IPath iPath) {
        if (deltaDataTree2.includes(iPath)) {
            return deltaDataTree2.copyCompleteSubtree(iPath);
        }
        return new DeletedNode(this.name);
    }

    AbstractDataTreeNode asReverseComparisonNode(IComparator iComparator) {
        NodeComparison nodeComparison = null;
        try {
            nodeComparison = ((NodeComparison)this.data).asReverseComparison(iComparator);
        }
        catch (ClassCastException classCastException) {
            Assert.isTrue((boolean)false, (String)Messages.dtree_reverse);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.children.length) {
            AbstractDataTreeNode abstractDataTreeNode = this.children[n2].asReverseComparisonNode(iComparator);
            if (abstractDataTreeNode != null) {
                this.children[n++] = abstractDataTreeNode;
            }
            ++n2;
        }
        if (n == 0 && nodeComparison.getUserComparison() == 0) {
            return null;
        }
        this.data = nodeComparison;
        if (n < this.children.length) {
            AbstractDataTreeNode[] abstractDataTreeNodeArray = new AbstractDataTreeNode[n];
            System.arraycopy(this.children, 0, abstractDataTreeNodeArray, 0, n);
            this.children = abstractDataTreeNodeArray;
        }
        return this;
    }

    AbstractDataTreeNode compareWith(DataTreeNode dataTreeNode, IComparator iComparator) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray = DataTreeNode.compareWith(this.children, dataTreeNode.children, iComparator);
        Object object = this.data;
        Object object2 = dataTreeNode.data;
        int n = 0;
        if (this.name != null) {
            n = iComparator.compare(object, object2);
        }
        return new DataTreeNode(this.name, new NodeComparison(object, object2, 4, n), abstractDataTreeNodeArray);
    }

    AbstractDataTreeNode compareWithParent(IPath iPath, DeltaDataTree deltaDataTree, IComparator iComparator) {
        if (!deltaDataTree.includes(iPath)) {
            return DataTreeNode.convertToAddedComparisonNode(this, 1);
        }
        DataTreeNode dataTreeNode = (DataTreeNode)deltaDataTree.copyCompleteSubtree(iPath);
        return dataTreeNode.compareWith(this, iComparator);
    }

    AbstractDataTreeNode copy() {
        if (this.children.length > 0) {
            AbstractDataTreeNode[] abstractDataTreeNodeArray = new AbstractDataTreeNode[this.children.length];
            System.arraycopy(this.children, 0, abstractDataTreeNodeArray, 0, this.children.length);
            return new DataTreeNode(this.name, this.data, abstractDataTreeNodeArray);
        }
        return new DataTreeNode(this.name, this.data, this.children);
    }

    DataTreeNode copyWithNewChild(String string, DataTreeNode dataTreeNode) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray = this.children;
        int n = 0;
        int n2 = abstractDataTreeNodeArray.length - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            int n4 = string.compareTo(abstractDataTreeNodeArray[n3].name);
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            throw new Error();
        }
        AbstractDataTreeNode[] abstractDataTreeNodeArray2 = new AbstractDataTreeNode[abstractDataTreeNodeArray.length + 1];
        System.arraycopy(abstractDataTreeNodeArray, 0, abstractDataTreeNodeArray2, 0, n);
        dataTreeNode.setName(string);
        abstractDataTreeNodeArray2[n] = dataTreeNode;
        System.arraycopy(abstractDataTreeNodeArray, n, abstractDataTreeNodeArray2, n + 1, abstractDataTreeNodeArray.length - n);
        return new DataTreeNode(this.getName(), this.getData(), abstractDataTreeNodeArray2);
    }

    DataTreeNode copyWithoutChild(String string) {
        DataTreeNode dataTreeNode;
        int n = this.indexOfChild(string);
        if (n == -1) {
            dataTreeNode = (DataTreeNode)this.copy();
        } else {
            int n2 = this.size() - 1;
            AbstractDataTreeNode[] abstractDataTreeNodeArray = new AbstractDataTreeNode[n2];
            dataTreeNode = new DataTreeNode(this.getName(), this.getData(), abstractDataTreeNodeArray);
            dataTreeNode.copyChildren(0, n - 1, this, 0);
            dataTreeNode.copyChildren(n, n2 - 1, this, n + 1);
        }
        return dataTreeNode;
    }

    protected static AbstractDataTreeNode[] forwardDeltaWith(AbstractDataTreeNode[] abstractDataTreeNodeArray, AbstractDataTreeNode[] abstractDataTreeNodeArray2, IComparator iComparator) {
        if (abstractDataTreeNodeArray.length == 0 && abstractDataTreeNodeArray2.length == 0) {
            return NO_CHILDREN;
        }
        AbstractDataTreeNode[] abstractDataTreeNodeArray3 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < abstractDataTreeNodeArray.length && n4 < abstractDataTreeNodeArray2.length) {
            String string = abstractDataTreeNodeArray[n3].name;
            String string2 = abstractDataTreeNodeArray2[n4].name;
            int n5 = string.compareTo(string2);
            if (n5 == 0) {
                AbstractDataTreeNode abstractDataTreeNode;
                if ((abstractDataTreeNode = DataTreeNode.forwardDeltaWithOrNullIfEqual(abstractDataTreeNodeArray[n3++], abstractDataTreeNodeArray2[n4++], iComparator)) == null) continue;
                if (n >= n2) {
                    if (abstractDataTreeNodeArray3 == null) {
                        n2 = 5;
                        abstractDataTreeNodeArray3 = new AbstractDataTreeNode[5];
                    } else {
                        AbstractDataTreeNode[] abstractDataTreeNodeArray4 = abstractDataTreeNodeArray3;
                        n2 = n2 * 2 + 1;
                        abstractDataTreeNodeArray3 = new AbstractDataTreeNode[n2];
                        System.arraycopy(abstractDataTreeNodeArray4, 0, abstractDataTreeNodeArray3, 0, n);
                    }
                }
                abstractDataTreeNodeArray3[n++] = abstractDataTreeNode;
                continue;
            }
            if (n5 < 0) {
                if (n >= n2) {
                    if (abstractDataTreeNodeArray3 == null) {
                        n2 = 5;
                        abstractDataTreeNodeArray3 = new AbstractDataTreeNode[5];
                    } else {
                        AbstractDataTreeNode[] abstractDataTreeNodeArray5 = abstractDataTreeNodeArray3;
                        n2 = n2 * 2 + 1;
                        abstractDataTreeNodeArray3 = new AbstractDataTreeNode[n2];
                        System.arraycopy(abstractDataTreeNodeArray5, 0, abstractDataTreeNodeArray3, 0, n);
                    }
                }
                abstractDataTreeNodeArray3[n++] = new DeletedNode(string);
                ++n3;
                continue;
            }
            if (n >= n2) {
                if (abstractDataTreeNodeArray3 == null) {
                    n2 = 5;
                    abstractDataTreeNodeArray3 = new AbstractDataTreeNode[5];
                } else {
                    AbstractDataTreeNode[] abstractDataTreeNodeArray6 = abstractDataTreeNodeArray3;
                    n2 = n2 * 2 + 1;
                    abstractDataTreeNodeArray3 = new AbstractDataTreeNode[n2];
                    System.arraycopy(abstractDataTreeNodeArray6, 0, abstractDataTreeNodeArray3, 0, n);
                }
            }
            abstractDataTreeNodeArray3[n++] = abstractDataTreeNodeArray2[n4++];
        }
        while (n3 < abstractDataTreeNodeArray.length) {
            if (n >= n2) {
                if (abstractDataTreeNodeArray3 == null) {
                    n2 = 5;
                    abstractDataTreeNodeArray3 = new AbstractDataTreeNode[5];
                } else {
                    AbstractDataTreeNode[] abstractDataTreeNodeArray7 = abstractDataTreeNodeArray3;
                    n2 = n2 * 2 + 1;
                    abstractDataTreeNodeArray3 = new AbstractDataTreeNode[n2];
                    System.arraycopy(abstractDataTreeNodeArray7, 0, abstractDataTreeNodeArray3, 0, n);
                }
            }
            abstractDataTreeNodeArray3[n++] = new DeletedNode(abstractDataTreeNodeArray[n3++].name);
        }
        while (n4 < abstractDataTreeNodeArray2.length) {
            if (n >= n2) {
                if (abstractDataTreeNodeArray3 == null) {
                    n2 = 5;
                    abstractDataTreeNodeArray3 = new AbstractDataTreeNode[5];
                } else {
                    AbstractDataTreeNode[] abstractDataTreeNodeArray8 = abstractDataTreeNodeArray3;
                    n2 = n2 * 2 + 1;
                    abstractDataTreeNodeArray3 = new AbstractDataTreeNode[n2];
                    System.arraycopy(abstractDataTreeNodeArray8, 0, abstractDataTreeNodeArray3, 0, n);
                }
            }
            abstractDataTreeNodeArray3[n++] = abstractDataTreeNodeArray2[n4++];
        }
        if (n == 0) {
            return NO_CHILDREN;
        }
        if (n < n2) {
            AbstractDataTreeNode[] abstractDataTreeNodeArray9 = abstractDataTreeNodeArray3;
            abstractDataTreeNodeArray3 = new AbstractDataTreeNode[n];
            System.arraycopy(abstractDataTreeNodeArray9, 0, abstractDataTreeNodeArray3, 0, n);
        }
        return abstractDataTreeNodeArray3;
    }

    protected AbstractDataTreeNode forwardDeltaWith(DataTreeNode dataTreeNode, IComparator iComparator) {
        AbstractDataTreeNode abstractDataTreeNode = DataTreeNode.forwardDeltaWithOrNullIfEqual(this, dataTreeNode, iComparator);
        if (abstractDataTreeNode == null) {
            return new NoDataDeltaNode(this.name, NO_CHILDREN);
        }
        return abstractDataTreeNode;
    }

    protected static AbstractDataTreeNode forwardDeltaWithOrNullIfEqual(AbstractDataTreeNode abstractDataTreeNode, AbstractDataTreeNode abstractDataTreeNode2, IComparator iComparator) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray = DataTreeNode.forwardDeltaWith(abstractDataTreeNode.children, abstractDataTreeNode2.children, iComparator);
        Object object = abstractDataTreeNode2.getData();
        if (iComparator.compare(abstractDataTreeNode.getData(), object) == 0) {
            if (abstractDataTreeNodeArray.length == 0) {
                return null;
            }
            return new NoDataDeltaNode(abstractDataTreeNode2.name, abstractDataTreeNodeArray);
        }
        return new DataDeltaNode(abstractDataTreeNode2.name, object, abstractDataTreeNodeArray);
    }

    public Object getData() {
        return this.data;
    }

    boolean hasData() {
        return true;
    }

    void setData(Object object) {
        this.data = object;
    }

    AbstractDataTreeNode simplifyWithParent(IPath iPath, DeltaDataTree deltaDataTree, IComparator iComparator) {
        if (!deltaDataTree.includes(iPath)) {
            return this;
        }
        DataTreeNode dataTreeNode = (DataTreeNode)deltaDataTree.copyCompleteSubtree(iPath);
        return dataTreeNode.forwardDeltaWith(this, iComparator);
    }

    public void storeStrings(StringPool stringPool) {
        super.storeStrings(stringPool);
        Object object = this.data;
        if (object instanceof IStringPoolParticipant) {
            ((IStringPoolParticipant)object).shareStrings(stringPool);
        }
    }

    public String toString() {
        return "a DataTreeNode(" + this.getName() + ") with " + this.getChildren().length + " children.";
    }

    int type() {
        return 0;
    }
}

