/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dtree;

import java.io.DataInput;
import java.io.IOException;
import org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import org.eclipse.core.internal.dtree.DataDeltaNode;
import org.eclipse.core.internal.dtree.DataTreeNode;
import org.eclipse.core.internal.dtree.DeletedNode;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.dtree.IDataFlattener;
import org.eclipse.core.internal.dtree.NoDataDeltaNode;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DataTreeReader {
    protected IDataFlattener flatener;
    protected DataInput input;

    public DataTreeReader(IDataFlattener iDataFlattener) {
        this.flatener = iDataFlattener;
    }

    protected boolean hasData(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    protected AbstractDataTreeNode readNode(IPath iPath) throws IOException {
        AbstractDataTreeNode[] abstractDataTreeNodeArray;
        int n;
        String string = this.input.readUTF();
        int n2 = this.readNumber();
        Object object = iPath != null ? iPath.append(string) : Path.ROOT;
        Object object2 = null;
        if (this.hasData(n2) && (n = this.readNumber()) != 0) {
            object2 = this.flatener.readData((IPath)object, this.input);
        }
        if ((n = this.readNumber()) == 0) {
            abstractDataTreeNodeArray = AbstractDataTreeNode.NO_CHILDREN;
        } else {
            abstractDataTreeNodeArray = new AbstractDataTreeNode[n];
            int n3 = 0;
            while (n3 < n) {
                abstractDataTreeNodeArray[n3] = this.readNode((IPath)object);
                ++n3;
            }
        }
        switch (n2) {
            case 0: {
                return new DataTreeNode(string, object2, abstractDataTreeNodeArray);
            }
            case 1: {
                return new DataDeltaNode(string, object2, abstractDataTreeNodeArray);
            }
            case 2: {
                return new DeletedNode(string);
            }
            case 3: {
                return new NoDataDeltaNode(string, abstractDataTreeNodeArray);
            }
        }
        Assert.isTrue((boolean)false, (String)Messages.dtree_switchError);
        return null;
    }

    protected int readNumber() throws IOException {
        byte by = this.input.readByte();
        int n = by & 0xFF;
        if (n == 255) {
            n = this.input.readInt();
        }
        return n;
    }

    public DeltaDataTree readTree(DeltaDataTree deltaDataTree, DataInput dataInput) throws IOException {
        this.input = dataInput;
        AbstractDataTreeNode abstractDataTreeNode = this.readNode((IPath)Path.ROOT);
        return new DeltaDataTree(abstractDataTreeNode, deltaDataTree);
    }
}

