/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dtree;

import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.core.internal.dtree.AbstractDataTree;
import org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import org.eclipse.core.internal.dtree.IDataFlattener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DataTreeWriter {
    protected IDataFlattener flatener;
    protected DataOutput output;
    public static final int D_INFINITE = -1;

    public DataTreeWriter(IDataFlattener iDataFlattener) {
        this.flatener = iDataFlattener;
    }

    protected void writeNode(AbstractDataTreeNode abstractDataTreeNode, IPath iPath, int n) throws IOException {
        AbstractDataTreeNode[] abstractDataTreeNodeArray;
        int n2 = abstractDataTreeNode.type();
        String string = abstractDataTreeNode.getName();
        if (string == null) {
            string = "";
        }
        this.output.writeUTF(string);
        this.writeNumber(n2);
        if (abstractDataTreeNode.hasData()) {
            abstractDataTreeNodeArray = abstractDataTreeNode.getData();
            if (abstractDataTreeNodeArray == null) {
                this.writeNumber(0);
            } else {
                this.writeNumber(1);
                this.flatener.writeData(iPath, abstractDataTreeNode.getData(), this.output);
            }
        }
        if (n > 0 || n == -1) {
            abstractDataTreeNodeArray = abstractDataTreeNode.getChildren();
            this.writeNumber(abstractDataTreeNodeArray.length);
            int n3 = n == -1 ? -1 : n - 1;
            int n4 = 0;
            int n5 = abstractDataTreeNodeArray.length;
            while (n4 < n5) {
                this.writeNode(abstractDataTreeNodeArray[n4], iPath.append(abstractDataTreeNodeArray[n4].getName()), n3);
                ++n4;
            }
        } else {
            this.writeNumber(0);
        }
    }

    protected void writeNumber(int n) throws IOException {
        if (n >= 0 && n < 255) {
            this.output.writeByte(n);
        } else {
            this.output.writeByte(255);
            this.output.writeInt(n);
        }
    }

    protected void writeSingleNode(AbstractDataTreeNode abstractDataTreeNode, IPath iPath) throws IOException {
        String string = abstractDataTreeNode.getName();
        if (string == null) {
            string = "";
        }
        this.output.writeUTF(string);
        this.writeNumber(abstractDataTreeNode.type());
        if (abstractDataTreeNode.hasData()) {
            Object object = abstractDataTreeNode.getData();
            if (object == null) {
                this.writeNumber(0);
            } else {
                this.writeNumber(1);
                this.flatener.writeData(iPath, abstractDataTreeNode.getData(), this.output);
            }
        }
    }

    public void writeTree(AbstractDataTree abstractDataTree, IPath iPath, int n, DataOutput dataOutput) throws IOException {
        this.output = dataOutput;
        AbstractDataTreeNode abstractDataTreeNode = abstractDataTree.getRootNode();
        Path path = Path.ROOT;
        String[] stringArray = iPath.segments();
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            this.writeSingleNode(abstractDataTreeNode, (IPath)path);
            path = path.append(string);
            abstractDataTreeNode = abstractDataTreeNode.childAtOrNull(string);
            if (abstractDataTreeNode == null) {
                this.writeNumber(0);
                return;
            }
            this.writeNumber(1);
            ++n2;
        }
        Assert.isTrue((boolean)path.equals((Object)iPath), (String)"dtree.navigationError");
        this.writeNode(abstractDataTreeNode, iPath, n);
    }
}

