/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dtree;

import org.eclipse.core.internal.dtree.AbstractDataTree;
import org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import org.eclipse.core.internal.dtree.DataDeltaNode;
import org.eclipse.core.internal.dtree.DataTreeLookup;
import org.eclipse.core.internal.dtree.DataTreeNode;
import org.eclipse.core.internal.dtree.DeletedNode;
import org.eclipse.core.internal.dtree.IComparator;
import org.eclipse.core.internal.dtree.NoDataDeltaNode;
import org.eclipse.core.internal.dtree.NodeComparison;
import org.eclipse.core.internal.dtree.ObjectNotFoundException;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.StringPool;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DeltaDataTree
extends AbstractDataTree {
    private AbstractDataTreeNode rootNode;
    private DeltaDataTree parent;

    public DeltaDataTree() {
        this.empty();
    }

    public DeltaDataTree(AbstractDataTreeNode abstractDataTreeNode) {
        this.rootNode = abstractDataTreeNode;
        this.parent = null;
    }

    protected DeltaDataTree(AbstractDataTreeNode abstractDataTreeNode, DeltaDataTree deltaDataTree) {
        this.rootNode = abstractDataTreeNode;
        this.parent = deltaDataTree;
    }

    protected void addChild(IPath iPath, String string, AbstractDataTreeNode abstractDataTreeNode) {
        if (!this.includes(iPath)) {
            DeltaDataTree.handleNotFound(iPath);
        }
        abstractDataTreeNode.setName(string);
        this.assembleNode(iPath, new NoDataDeltaNode(iPath.lastSegment(), abstractDataTreeNode));
    }

    DeltaDataTree asBackwardDelta() {
        if (this.getParent() == null) {
            return this.newEmptyDeltaTree();
        }
        return new DeltaDataTree(this.getRootNode().asBackwardDelta(this, this.getParent(), this.rootKey()), this);
    }

    public DeltaDataTree asReverseComparisonTree(IComparator iComparator) {
        if (this.rootNode.getName() == null) {
            AbstractDataTreeNode[] abstractDataTreeNodeArray = this.rootNode.getChildren();
            int n = 0;
            int n2 = 0;
            while (n2 < abstractDataTreeNodeArray.length) {
                AbstractDataTreeNode abstractDataTreeNode = abstractDataTreeNodeArray[n2].asReverseComparisonNode(iComparator);
                if (abstractDataTreeNode != null) {
                    abstractDataTreeNodeArray[n++] = abstractDataTreeNode;
                }
                ++n2;
            }
            if (n < abstractDataTreeNodeArray.length) {
                AbstractDataTreeNode[] abstractDataTreeNodeArray2 = new AbstractDataTreeNode[n];
                System.arraycopy(abstractDataTreeNodeArray, 0, abstractDataTreeNodeArray2, 0, n);
                this.rootNode.setChildren(abstractDataTreeNodeArray2);
            }
        } else {
            this.rootNode.asReverseComparisonNode(iComparator);
        }
        return this;
    }

    protected void assembleNode(IPath iPath, AbstractDataTreeNode abstractDataTreeNode) {
        this.rootNode = this.rootNode.assembleWith(abstractDataTreeNode, iPath, 0);
    }

    public DeltaDataTree assembleWithForwardDelta(DeltaDataTree deltaDataTree) {
        return new DeltaDataTree(this.getRootNode().assembleWith(deltaDataTree.getRootNode()), this);
    }

    protected DeltaDataTree basicCompare(DeltaDataTree deltaDataTree, IComparator iComparator, IPath iPath) {
        DeltaDataTree deltaDataTree2;
        if (this == deltaDataTree) {
            deltaDataTree2 = new DeltaDataTree();
            deltaDataTree2.setData((IPath)Path.ROOT, new NodeComparison(null, null, 0, 0));
        } else if (deltaDataTree.hasAncestor(this)) {
            AbstractDataTreeNode abstractDataTreeNode;
            AbstractDataTreeNode abstractDataTreeNode2 = deltaDataTree.searchNodeAt(iPath);
            DeltaDataTree deltaDataTree3 = deltaDataTree;
            while ((deltaDataTree3 = deltaDataTree3.getParent()) != this) {
                abstractDataTreeNode = deltaDataTree3.searchNodeAt(iPath);
                if (abstractDataTreeNode == null) continue;
                abstractDataTreeNode2 = abstractDataTreeNode.assembleWith(abstractDataTreeNode2);
            }
            abstractDataTreeNode = abstractDataTreeNode2.compareWithParent(iPath, this, iComparator);
            deltaDataTree2 = new DeltaDataTree(abstractDataTreeNode);
        } else if (this.hasAncestor(deltaDataTree)) {
            AbstractDataTreeNode abstractDataTreeNode = this.asBackwardDelta().searchNodeAt(iPath);
            DeltaDataTree deltaDataTree4 = this;
            while ((deltaDataTree4 = deltaDataTree4.getParent()) != deltaDataTree) {
                abstractDataTreeNode = abstractDataTreeNode.assembleWith(deltaDataTree4.asBackwardDelta().searchNodeAt(iPath));
            }
            AbstractDataTreeNode abstractDataTreeNode3 = abstractDataTreeNode.compareWithParent(iPath, this, iComparator);
            deltaDataTree2 = new DeltaDataTree(abstractDataTreeNode3);
        } else {
            DataTreeNode dataTreeNode = (DataTreeNode)this.copyCompleteSubtree(iPath);
            DataTreeNode dataTreeNode2 = (DataTreeNode)deltaDataTree.copyCompleteSubtree(iPath);
            AbstractDataTreeNode abstractDataTreeNode = dataTreeNode.compareWith(dataTreeNode2, iComparator);
            deltaDataTree2 = new DeltaDataTree(abstractDataTreeNode);
        }
        deltaDataTree2.immutable();
        return deltaDataTree2;
    }

    public DeltaDataTree collapseTo(DeltaDataTree deltaDataTree, IComparator iComparator) {
        if (this == deltaDataTree || this.getParent() == deltaDataTree) {
            return this;
        }
        DeltaDataTree deltaDataTree2 = deltaDataTree.forwardDeltaWith(this, iComparator);
        this.parent = deltaDataTree;
        this.rootNode = deltaDataTree2.rootNode;
        return this;
    }

    public DeltaDataTree compareWith(DeltaDataTree deltaDataTree, IComparator iComparator) {
        DeltaDataTree deltaDataTree2;
        if (this == deltaDataTree) {
            deltaDataTree2 = new DeltaDataTree();
            deltaDataTree2.setData((IPath)Path.ROOT, new NodeComparison(null, null, 0, 0));
        } else if (deltaDataTree.hasAncestor(this)) {
            AbstractDataTreeNode abstractDataTreeNode = deltaDataTree.getRootNode();
            DeltaDataTree deltaDataTree3 = deltaDataTree;
            while ((deltaDataTree3 = deltaDataTree3.getParent()) != this) {
                abstractDataTreeNode = deltaDataTree3.getRootNode().assembleWith(abstractDataTreeNode);
            }
            AbstractDataTreeNode abstractDataTreeNode2 = abstractDataTreeNode.compareWithParent(this.rootKey(), this, iComparator);
            deltaDataTree2 = new DeltaDataTree(abstractDataTreeNode2);
        } else if (this.hasAncestor(deltaDataTree)) {
            AbstractDataTreeNode abstractDataTreeNode = this.asBackwardDelta().getRootNode();
            DeltaDataTree deltaDataTree4 = this;
            while ((deltaDataTree4 = deltaDataTree4.getParent()) != deltaDataTree) {
                abstractDataTreeNode = abstractDataTreeNode.assembleWith(deltaDataTree4.asBackwardDelta().getRootNode());
            }
            AbstractDataTreeNode abstractDataTreeNode3 = abstractDataTreeNode.compareWithParent(this.rootKey(), this, iComparator);
            deltaDataTree2 = new DeltaDataTree(abstractDataTreeNode3);
        } else {
            DataTreeNode dataTreeNode = (DataTreeNode)this.copyCompleteSubtree(this.rootKey());
            DataTreeNode dataTreeNode2 = (DataTreeNode)deltaDataTree.copyCompleteSubtree(this.rootKey());
            AbstractDataTreeNode abstractDataTreeNode = dataTreeNode.compareWith(dataTreeNode2, iComparator);
            deltaDataTree2 = new DeltaDataTree(abstractDataTreeNode);
        }
        deltaDataTree2.immutable();
        return deltaDataTree2;
    }

    public DeltaDataTree compareWith(DeltaDataTree deltaDataTree, IComparator iComparator, IPath iPath) {
        if (this.includes(iPath)) {
            if (deltaDataTree.includes(iPath)) {
                return this.basicCompare(deltaDataTree, iComparator, iPath);
            }
            return new DeltaDataTree(AbstractDataTreeNode.convertToRemovedComparisonNode(this.copyCompleteSubtree(iPath), iComparator.compare(this.getData(iPath), null)));
        }
        if (deltaDataTree.includes(iPath)) {
            return new DeltaDataTree(AbstractDataTreeNode.convertToAddedComparisonNode(deltaDataTree.copyCompleteSubtree(iPath), iComparator.compare(null, deltaDataTree.getData(iPath))));
        }
        return DeltaDataTree.createEmptyDelta();
    }

    protected AbstractDataTree copy() {
        return new DeltaDataTree(this.rootNode, this.parent);
    }

    public AbstractDataTreeNode copyCompleteSubtree(IPath iPath) {
        AbstractDataTreeNode abstractDataTreeNode = this.searchNodeAt(iPath);
        if (abstractDataTreeNode == null) {
            DeltaDataTree.handleNotFound(iPath);
            return null;
        }
        if (abstractDataTreeNode.isDelta()) {
            return this.naiveCopyCompleteSubtree(iPath);
        }
        return abstractDataTreeNode.copy();
    }

    public void createChild(IPath iPath, String string) {
        this.createChild(iPath, string, null);
    }

    public void createChild(IPath iPath, String string, Object object) {
        if (this.isImmutable()) {
            DeltaDataTree.handleImmutableTree();
        }
        this.addChild(iPath, string, new DataTreeNode(string, object));
    }

    static DeltaDataTree createEmptyDelta() {
        DeltaDataTree deltaDataTree = new DeltaDataTree();
        deltaDataTree.emptyDelta();
        return deltaDataTree;
    }

    protected AbstractDataTree createInstance() {
        return new DeltaDataTree();
    }

    public void createSubtree(IPath iPath, AbstractDataTreeNode abstractDataTreeNode) {
        if (this.isImmutable()) {
            DeltaDataTree.handleImmutableTree();
        }
        if (iPath.isRoot()) {
            this.setParent(null);
            this.setRootNode(abstractDataTreeNode);
        } else {
            this.addChild(iPath.removeLastSegments(1), iPath.lastSegment(), abstractDataTreeNode);
        }
    }

    public void deleteChild(IPath iPath, String string) {
        IPath iPath2;
        if (this.isImmutable()) {
            DeltaDataTree.handleImmutableTree();
        }
        if (!this.includes(iPath2 = iPath.append(string))) {
            DeltaDataTree.handleNotFound(iPath2);
        }
        this.assembleNode(iPath, new NoDataDeltaNode(iPath.lastSegment(), new DeletedNode(string)));
    }

    public void empty() {
        this.rootNode = new DataTreeNode(null, (Object)null);
        this.parent = null;
    }

    void emptyDelta() {
        this.rootNode = new NoDataDeltaNode(null);
    }

    public AbstractDataTreeNode findNodeAt(IPath iPath) {
        AbstractDataTreeNode abstractDataTreeNode = this.rootNode;
        int n = iPath.segmentCount();
        int n2 = 0;
        while (n2 < n) {
            if ((abstractDataTreeNode = abstractDataTreeNode.childAtOrNull(iPath.segment(n2))) == null) {
                return null;
            }
            ++n2;
        }
        return abstractDataTreeNode;
    }

    public DeltaDataTree forwardDeltaWith(DeltaDataTree deltaDataTree, IComparator iComparator) {
        DeltaDataTree deltaDataTree2;
        if (this == deltaDataTree) {
            deltaDataTree2 = this.newEmptyDeltaTree();
        } else if (deltaDataTree.hasAncestor(this)) {
            AbstractDataTreeNode abstractDataTreeNode = deltaDataTree.getRootNode();
            DeltaDataTree deltaDataTree3 = deltaDataTree;
            while ((deltaDataTree3 = deltaDataTree3.getParent()) != this) {
                abstractDataTreeNode = deltaDataTree3.getRootNode().assembleWith(abstractDataTreeNode);
            }
            deltaDataTree2 = new DeltaDataTree(abstractDataTreeNode, this);
            deltaDataTree2.simplify(iComparator);
        } else if (this.hasAncestor(deltaDataTree)) {
            deltaDataTree2 = deltaDataTree.forwardDeltaWith(this, iComparator);
            deltaDataTree2 = deltaDataTree2.asBackwardDelta();
        } else {
            DataTreeNode dataTreeNode = (DataTreeNode)this.copyCompleteSubtree(this.rootKey());
            DataTreeNode dataTreeNode2 = (DataTreeNode)deltaDataTree.copyCompleteSubtree(this.rootKey());
            AbstractDataTreeNode abstractDataTreeNode = dataTreeNode.forwardDeltaWith(dataTreeNode2, iComparator);
            deltaDataTree2 = new DeltaDataTree(abstractDataTreeNode, this);
        }
        deltaDataTree2.immutable();
        return deltaDataTree2;
    }

    public int getChildCount(IPath iPath) {
        return this.getChildNodes(iPath).length;
    }

    protected AbstractDataTreeNode[] getChildNodes(IPath iPath) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray = null;
        int n = iPath.segmentCount();
        DeltaDataTree deltaDataTree = this;
        while (deltaDataTree != null) {
            AbstractDataTreeNode abstractDataTreeNode = deltaDataTree.rootNode;
            boolean bl = !abstractDataTreeNode.isDelta();
            int n2 = 0;
            while (n2 < n) {
                if ((abstractDataTreeNode = abstractDataTreeNode.childAtOrNull(iPath.segment(n2))) == null) break;
                if (!abstractDataTreeNode.isDelta()) {
                    bl = true;
                }
                ++n2;
            }
            if (abstractDataTreeNode != null) {
                if (abstractDataTreeNode.isDeleted()) break;
                abstractDataTreeNodeArray = abstractDataTreeNodeArray == null ? abstractDataTreeNode.children : AbstractDataTreeNode.assembleWith(abstractDataTreeNode.children, abstractDataTreeNodeArray, !bl);
            }
            if (bl) {
                if (abstractDataTreeNodeArray == null) break;
                return abstractDataTreeNodeArray;
            }
            deltaDataTree = deltaDataTree.parent;
        }
        if (abstractDataTreeNodeArray != null) {
            Assert.isTrue((boolean)false, (String)Messages.dtree_malformedTree);
        }
        DeltaDataTree.handleNotFound(iPath);
        return null;
    }

    public IPath[] getChildren(IPath iPath) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray = this.getChildNodes(iPath);
        int n = abstractDataTreeNodeArray.length;
        if (n == 0) {
            return NO_CHILDREN;
        }
        IPath[] iPathArray = new IPath[n];
        int n2 = 0;
        while (n2 < n) {
            iPathArray[n2] = iPath.append(abstractDataTreeNodeArray[n2].name);
            ++n2;
        }
        return iPathArray;
    }

    public Object getData(IPath iPath) {
        int n = iPath.segmentCount();
        DeltaDataTree deltaDataTree = this;
        while (deltaDataTree != null) {
            AbstractDataTreeNode abstractDataTreeNode = deltaDataTree.rootNode;
            boolean bl = !abstractDataTreeNode.isDelta();
            int n2 = 0;
            while (n2 < n) {
                if ((abstractDataTreeNode = abstractDataTreeNode.childAtOrNull(iPath.segment(n2))) == null) break;
                if (!abstractDataTreeNode.isDelta()) {
                    bl = true;
                }
                ++n2;
            }
            if (abstractDataTreeNode != null) {
                if (abstractDataTreeNode.hasData()) {
                    return abstractDataTreeNode.getData();
                }
                if (abstractDataTreeNode.isDeleted()) break;
            }
            if (bl) break;
            deltaDataTree = deltaDataTree.parent;
        }
        DeltaDataTree.handleNotFound(iPath);
        return null;
    }

    public String getNameOfChild(IPath iPath, int n) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray = this.getChildNodes(iPath);
        return abstractDataTreeNodeArray[n].name;
    }

    public String[] getNamesOfChildren(IPath iPath) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray = this.getChildNodes(iPath);
        int n = abstractDataTreeNodeArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = abstractDataTreeNodeArray[n2].name;
            ++n2;
        }
        return stringArray;
    }

    public DeltaDataTree getParent() {
        return this.parent;
    }

    protected AbstractDataTreeNode getRootNode() {
        return this.rootNode;
    }

    protected boolean hasAncestor(DeltaDataTree deltaDataTree) {
        DeltaDataTree deltaDataTree2 = this;
        while ((deltaDataTree2 = deltaDataTree2.getParent()) != null) {
            if (deltaDataTree2 != deltaDataTree) continue;
            return true;
        }
        return false;
    }

    public boolean includes(IPath iPath) {
        return this.searchNodeAt(iPath) != null;
    }

    public boolean isEmptyDelta() {
        return this.rootNode.getChildren().length == 0;
    }

    public DataTreeLookup lookup(IPath iPath) {
        int n = iPath.segmentCount();
        DeltaDataTree deltaDataTree = this;
        while (deltaDataTree != null) {
            AbstractDataTreeNode abstractDataTreeNode = deltaDataTree.rootNode;
            boolean bl = !abstractDataTreeNode.isDelta();
            int n2 = 0;
            while (n2 < n) {
                if ((abstractDataTreeNode = abstractDataTreeNode.childAtOrNull(iPath.segment(n2))) == null) break;
                bl |= !abstractDataTreeNode.isDelta();
                ++n2;
            }
            if (abstractDataTreeNode != null) {
                if (abstractDataTreeNode.hasData()) {
                    return DataTreeLookup.newLookup(iPath, true, abstractDataTreeNode.getData(), deltaDataTree == this);
                }
                if (abstractDataTreeNode.isDeleted()) break;
            }
            if (bl) break;
            deltaDataTree = deltaDataTree.parent;
        }
        return DataTreeLookup.newLookup(iPath, false, null);
    }

    public DataTreeLookup lookupIgnoreCase(IPath iPath) {
        int n = iPath.segmentCount();
        DeltaDataTree deltaDataTree = this;
        while (deltaDataTree != null) {
            AbstractDataTreeNode abstractDataTreeNode = deltaDataTree.rootNode;
            boolean bl = !abstractDataTreeNode.isDelta();
            int n2 = 0;
            while (n2 < n) {
                if ((abstractDataTreeNode = abstractDataTreeNode.childAtIgnoreCase(iPath.segment(n2))) == null) break;
                bl |= !abstractDataTreeNode.isDelta();
                ++n2;
            }
            if (abstractDataTreeNode != null) {
                if (abstractDataTreeNode.hasData()) {
                    return DataTreeLookup.newLookup(iPath, true, abstractDataTreeNode.getData(), deltaDataTree == this);
                }
                if (abstractDataTreeNode.isDeleted()) break;
            }
            if (bl) break;
            deltaDataTree = deltaDataTree.parent;
        }
        return DataTreeLookup.newLookup(iPath, false, null);
    }

    public void makeComplete() {
        AbstractDataTreeNode abstractDataTreeNode = this.getRootNode();
        DeltaDataTree deltaDataTree = this.getParent();
        while (deltaDataTree != null) {
            abstractDataTreeNode = deltaDataTree.getRootNode().assembleWith(abstractDataTreeNode);
            deltaDataTree = deltaDataTree.getParent();
        }
        this.setRootNode(abstractDataTreeNode);
        this.setParent(null);
    }

    protected AbstractDataTreeNode naiveCopyCompleteSubtree(IPath iPath) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray;
        String[] stringArray = this.getNamesOfChildren(iPath);
        int n = stringArray.length;
        if (n == 0) {
            abstractDataTreeNodeArray = AbstractDataTreeNode.NO_CHILDREN;
        } else {
            abstractDataTreeNodeArray = new AbstractDataTreeNode[n];
            int n2 = n;
            while (--n2 >= 0) {
                abstractDataTreeNodeArray[n2] = this.copyCompleteSubtree(iPath.append(stringArray[n2]));
            }
        }
        return new DataTreeNode(iPath.lastSegment(), this.getData(iPath), abstractDataTreeNodeArray);
    }

    public DeltaDataTree newEmptyDeltaTree() {
        if (!this.isImmutable()) {
            throw new IllegalArgumentException(Messages.dtree_notImmutable);
        }
        DeltaDataTree deltaDataTree = (DeltaDataTree)this.copy();
        deltaDataTree.setParent(this);
        deltaDataTree.emptyDelta();
        return deltaDataTree;
    }

    public DeltaDataTree reroot() {
        this.reroot(this);
        return this;
    }

    protected void reroot(DeltaDataTree deltaDataTree) {
        DeltaDataTree deltaDataTree2;
        if (!deltaDataTree.isImmutable()) {
            DeltaDataTree.handleImmutableTree();
        }
        if ((deltaDataTree2 = deltaDataTree.getParent()) == null) {
            return;
        }
        this.reroot(deltaDataTree2);
        DeltaDataTree deltaDataTree3 = deltaDataTree.asBackwardDelta();
        DeltaDataTree deltaDataTree4 = deltaDataTree2.assembleWithForwardDelta(deltaDataTree);
        deltaDataTree.setRootNode(deltaDataTree4.getRootNode());
        deltaDataTree.setParent(null);
        deltaDataTree2.setRootNode(deltaDataTree3.getRootNode());
        deltaDataTree2.setParent(deltaDataTree);
    }

    public AbstractDataTreeNode safeCopyCompleteSubtree(IPath iPath) {
        AbstractDataTreeNode abstractDataTreeNode = this.searchNodeAt(iPath);
        if (abstractDataTreeNode == null) {
            return null;
        }
        if (abstractDataTreeNode.isDelta()) {
            return this.safeNaiveCopyCompleteSubtree(iPath);
        }
        return abstractDataTreeNode.copy();
    }

    protected AbstractDataTreeNode safeNaiveCopyCompleteSubtree(IPath iPath) {
        try {
            AbstractDataTreeNode[] abstractDataTreeNodeArray;
            String[] stringArray = this.getNamesOfChildren(iPath);
            int n = stringArray.length;
            if (n == 0) {
                abstractDataTreeNodeArray = AbstractDataTreeNode.NO_CHILDREN;
            } else {
                abstractDataTreeNodeArray = new AbstractDataTreeNode[n];
                int n2 = 0;
                int n3 = n;
                while (--n3 >= 0) {
                    abstractDataTreeNodeArray[n3] = this.safeCopyCompleteSubtree(iPath.append(stringArray[n3]));
                    if (abstractDataTreeNodeArray[n3] == null) continue;
                    ++n2;
                }
                if (n2 < n) {
                    AbstractDataTreeNode[] abstractDataTreeNodeArray2 = new AbstractDataTreeNode[n2];
                    int n4 = 0;
                    int n5 = 0;
                    while (n4 < n) {
                        if (abstractDataTreeNodeArray[n4] != null) {
                            abstractDataTreeNodeArray2[n5++] = abstractDataTreeNodeArray[n4];
                        }
                        ++n4;
                    }
                    abstractDataTreeNodeArray = abstractDataTreeNodeArray2;
                }
            }
            return new DataTreeNode(iPath.lastSegment(), this.getData(iPath), abstractDataTreeNodeArray);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return null;
        }
    }

    protected AbstractDataTreeNode searchNodeAt(IPath iPath) {
        int n = iPath.segmentCount();
        DeltaDataTree deltaDataTree = this;
        while (deltaDataTree != null) {
            AbstractDataTreeNode abstractDataTreeNode = deltaDataTree.rootNode;
            boolean bl = !abstractDataTreeNode.isDelta();
            int n2 = 0;
            while (n2 < n) {
                if ((abstractDataTreeNode = abstractDataTreeNode.childAtOrNull(iPath.segment(n2))) == null) break;
                if (!abstractDataTreeNode.isDelta()) {
                    bl = true;
                }
                ++n2;
            }
            if (abstractDataTreeNode != null) {
                if (abstractDataTreeNode.isDeleted()) break;
                return abstractDataTreeNode;
            }
            if (bl) break;
            deltaDataTree = deltaDataTree.parent;
        }
        return null;
    }

    public void setData(IPath iPath, Object object) {
        if (this.isImmutable()) {
            DeltaDataTree.handleImmutableTree();
        }
        if (!this.includes(iPath)) {
            DeltaDataTree.handleNotFound(iPath);
        }
        this.assembleNode(iPath, new DataDeltaNode(iPath.lastSegment(), object));
    }

    protected void setParent(DeltaDataTree deltaDataTree) {
        this.parent = deltaDataTree;
    }

    void setRootNode(AbstractDataTreeNode abstractDataTreeNode) {
        this.rootNode = abstractDataTreeNode;
    }

    protected void simplify(IComparator iComparator) {
        if (this.parent == null) {
            return;
        }
        this.setRootNode(this.rootNode.simplifyWithParent(this.rootKey(), this.parent, iComparator));
    }

    public void storeStrings(StringPool stringPool) {
        AbstractDataTreeNode abstractDataTreeNode = null;
        DeltaDataTree deltaDataTree = this;
        while (deltaDataTree != null) {
            abstractDataTreeNode = deltaDataTree.getRootNode();
            if (abstractDataTreeNode != null) {
                abstractDataTreeNode.storeStrings(stringPool);
            }
            deltaDataTree = deltaDataTree.getParent();
        }
    }
}

