/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dtree;

import org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import org.eclipse.core.internal.dtree.DataTreeNode;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.dtree.IComparator;
import org.eclipse.core.internal.dtree.NodeComparison;
import org.eclipse.core.runtime.IPath;

public class NoDataDeltaNode
extends AbstractDataTreeNode {
    public NoDataDeltaNode(String string) {
        this(string, NO_CHILDREN);
    }

    public NoDataDeltaNode(String string, AbstractDataTreeNode[] abstractDataTreeNodeArray) {
        super(string, abstractDataTreeNodeArray);
    }

    NoDataDeltaNode(String string, AbstractDataTreeNode abstractDataTreeNode) {
        super(string, new AbstractDataTreeNode[]{abstractDataTreeNode});
    }

    AbstractDataTreeNode asBackwardDelta(DeltaDataTree deltaDataTree, DeltaDataTree deltaDataTree2, IPath iPath) {
        int n = this.children.length;
        if (n == 0) {
            return new NoDataDeltaNode(this.name, NO_CHILDREN);
        }
        AbstractDataTreeNode[] abstractDataTreeNodeArray = new AbstractDataTreeNode[n];
        int n2 = n;
        while (--n2 >= 0) {
            abstractDataTreeNodeArray[n2] = this.children[n2].asBackwardDelta(deltaDataTree, deltaDataTree2, iPath.append(this.children[n2].getName()));
        }
        return new NoDataDeltaNode(this.name, abstractDataTreeNodeArray);
    }

    AbstractDataTreeNode compareWithParent(IPath iPath, DeltaDataTree deltaDataTree, IComparator iComparator) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray = NoDataDeltaNode.compareWithParent(this.children, iPath, deltaDataTree, iComparator);
        Object object = deltaDataTree.getData(iPath);
        return new DataTreeNode(iPath.lastSegment(), new NodeComparison(object, object, 4, 0), abstractDataTreeNodeArray);
    }

    AbstractDataTreeNode copy() {
        AbstractDataTreeNode[] abstractDataTreeNodeArray;
        if (this.children.length == 0) {
            abstractDataTreeNodeArray = NO_CHILDREN;
        } else {
            abstractDataTreeNodeArray = new AbstractDataTreeNode[this.children.length];
            System.arraycopy(this.children, 0, abstractDataTreeNodeArray, 0, this.children.length);
        }
        return new NoDataDeltaNode(this.name, abstractDataTreeNodeArray);
    }

    boolean isDelta() {
        return true;
    }

    boolean isEmptyDelta() {
        return this.size() == 0;
    }

    AbstractDataTreeNode simplifyWithParent(IPath iPath, DeltaDataTree deltaDataTree, IComparator iComparator) {
        AbstractDataTreeNode[] abstractDataTreeNodeArray = NoDataDeltaNode.simplifyWithParent(this.children, iPath, deltaDataTree, iComparator);
        return new NoDataDeltaNode(this.name, abstractDataTreeNodeArray);
    }

    public String toString() {
        return "a NoDataDeltaNode(" + this.getName() + ") with " + this.getChildren().length + " children.";
    }

    int type() {
        return 3;
    }
}

