/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dtree;

import org.eclipse.core.internal.dtree.IComparator;

public final class NodeComparison {
    private Object oldData;
    private Object newData;
    private int comparison;
    private int userInt;
    public static final int K_ADDED = 1;
    public static final int K_REMOVED = 2;
    public static final int K_CHANGED = 4;

    NodeComparison(Object object, Object object2, int n, int n2) {
        this.oldData = object;
        this.newData = object2;
        this.comparison = n;
        this.userInt = n2;
    }

    NodeComparison asReverseComparison(IComparator iComparator) {
        Object object = this.oldData;
        this.oldData = this.newData;
        this.newData = object;
        this.userInt = iComparator.compare(this.oldData, this.newData);
        if (this.comparison == 1) {
            this.comparison = 2;
        } else if (this.comparison == 2) {
            this.comparison = 1;
        }
        return this;
    }

    public int getComparison() {
        return this.comparison;
    }

    public Object getNewData() {
        return this.newData;
    }

    public Object getOldData() {
        return this.oldData;
    }

    public int getUserComparison() {
        return this.userInt;
    }

    boolean isUnchanged() {
        return this.userInt == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NodeComparison(");
        switch (this.comparison) {
            case 1: {
                stringBuffer.append("Added, ");
                break;
            }
            case 2: {
                stringBuffer.append("Removed, ");
                break;
            }
            case 4: {
                stringBuffer.append("Changed, ");
                break;
            }
            case 0: {
                stringBuffer.append("No change, ");
                break;
            }
            default: {
                stringBuffer.append("Corrupt(" + this.comparison + "), ");
            }
        }
        stringBuffer.append(this.userInt);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

