/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;

class AutoBuildJob
extends Job
implements Preferences.IPropertyChangeListener {
    private boolean avoidBuild = false;
    private boolean buildNeeded = false;
    private boolean forceBuild = false;
    private boolean interrupted = false;
    private boolean isAutoBuilding = false;
    private long lastBuild = 0L;
    private Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
    private final Bundle systemBundle = Platform.getBundle((String)"org.eclipse.osgi");
    private Workspace workspace;

    AutoBuildJob(Workspace workspace) {
        super(Messages.events_building_0);
        this.setRule(workspace.getRoot());
        this.setPriority(40);
        this.isAutoBuilding = workspace.isAutoBuilding();
        this.workspace = workspace;
        this.preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    synchronized void avoidBuild() {
        this.avoidBuild = true;
    }

    public boolean belongsTo(Object object) {
        return object == ResourcesPlugin.FAMILY_AUTO_BUILD;
    }

    synchronized void build(boolean bl) {
        this.buildNeeded |= bl;
        long l = this.computeScheduleDelay();
        int n = this.getState();
        if (Policy.DEBUG_BUILD_NEEDED) {
            Policy.debug("Build requested, needsBuild: " + bl + " state: " + n + " delay: " + l);
        }
        if (bl && Policy.DEBUG_BUILD_NEEDED_STACK && n != 4) {
            new RuntimeException("Build Needed").printStackTrace();
        }
        if (n != 4) {
            this.setInterrupted(false);
        }
        switch (n) {
            case 1: {
                this.wakeUp(l);
                break;
            }
            case 0: {
                this.setSystem(!this.isAutoBuilding);
                this.schedule(l);
            }
        }
    }

    private long computeScheduleDelay() {
        long l = Math.min(1000L, 1000L + this.lastBuild - System.currentTimeMillis());
        return Math.max(100L, l);
    }

    private synchronized IStatus canceled() {
        this.buildNeeded = true;
        if (this.interrupted) {
            if (Policy.DEBUG_BUILD_INTERRUPT) {
                System.out.println("Scheduling rebuild due to interruption");
            }
            this.setInterrupted(false);
            this.schedule(this.computeScheduleDelay());
        }
        return Status.CANCEL_STATUS;
    }

    private void doBuild(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", Policy.opWork);
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().buildRule();
            try {
                this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                this.workspace.beginOperation(true);
                this.workspace.broadcastBuildEvent(this.workspace, 8, 9);
                IStatus iStatus = Status.OK_STATUS;
                try {
                    if (this.shouldBuild()) {
                        iStatus = this.workspace.getBuildManager().build(9, Policy.subMonitorFor(iProgressMonitor, Policy.opWork));
                    }
                }
                finally {
                    this.workspace.broadcastBuildEvent(this.workspace, 16, 9);
                }
                if (!iStatus.isOK()) {
                    throw new ResourceException(iStatus);
                }
                this.buildNeeded = false;
            }
            finally {
                if (this.workspace.getElementTree().isImmutable()) {
                    this.workspace.newWorkingTree();
                }
                this.workspace.endOperation(iSchedulingRule, false, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void forceBuild() {
        this.forceBuild = true;
    }

    synchronized void interrupt() {
        if (this.interrupted) {
            return;
        }
        switch (this.getState()) {
            case 0: {
                return;
            }
            case 2: {
                this.setInterrupted(!this.sleep());
                break;
            }
            case 4: {
                if (Job.getJobManager().currentJob() == this) {
                    return;
                }
                this.setInterrupted(true);
                if (!this.interrupted || !Policy.DEBUG_BUILD_INTERRUPT) break;
                System.out.println("Autobuild was interrupted:");
                new Exception().fillInStackTrace().printStackTrace();
            }
        }
        if (this.interrupted) {
            this.avoidBuild = false;
        }
    }

    synchronized boolean isInterrupted() {
        if (this.interrupted) {
            return true;
        }
        if (this.isBlocking()) {
            this.setInterrupted(true);
        }
        return this.interrupted;
    }

    public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getProperty().equals("description.autobuilding")) {
            return;
        }
        boolean bl = this.isAutoBuilding;
        this.isAutoBuilding = this.preferences.getBoolean("description.autobuilding");
        if (!this.forceBuild && !bl && this.isAutoBuilding) {
            this.forceBuild = true;
            this.build(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor iProgressMonitor) {
        AutoBuildJob autoBuildJob = this;
        synchronized (autoBuildJob) {
            if (iProgressMonitor.isCanceled()) {
                return this.canceled();
            }
        }
        if (this.systemBundle.getState() == 16) {
            return Status.OK_STATUS;
        }
        try {
            this.doBuild(iProgressMonitor);
            this.lastBuild = System.currentTimeMillis();
            this.setInterrupted(false);
            return Status.OK_STATUS;
        }
        catch (OperationCanceledException operationCanceledException) {
            return this.canceled();
        }
        catch (CoreException coreException) {
            return coreException.getStatus();
        }
    }

    private synchronized void setInterrupted(boolean bl) {
        this.interrupted = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean shouldBuild() {
        try {
            if (!this.workspace.isAutoBuilding()) {
                return false;
            }
            if (this.forceBuild) {
                return true;
            }
            if (this.avoidBuild) {
                return false;
            }
            boolean bl = this.buildNeeded;
            return bl;
        }
        finally {
            this.buildNeeded = false;
            this.avoidBuild = false;
            this.forceBuild = false;
        }
    }
}

