/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.resources.ModelObject;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class BuildCommand
extends ModelObject
implements ICommand {
    private static final int MASK_AUTO = 1;
    private static final int MASK_INCREMENTAL = 2;
    private static final int MASK_FULL = 4;
    private static final int MASK_CLEAN = 8;
    private static final int MASK_CONFIGURABLE = 16;
    private static final int MASK_CONFIG_COMPUTED = 32;
    private static final int ALL_TRIGGERS = 15;
    protected HashMap arguments = new HashMap(0);
    protected IncrementalProjectBuilder builder;
    private int triggers = 15;

    private static int maskForTrigger(int n) {
        switch (n) {
            case 9: {
                return 1;
            }
            case 10: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 15: {
                return 8;
            }
        }
        return 0;
    }

    public BuildCommand() {
        super("");
    }

    public Object clone() {
        BuildCommand buildCommand = null;
        buildCommand = (BuildCommand)super.clone();
        if (buildCommand == null) {
            return null;
        }
        buildCommand.setArguments(this.getArguments());
        buildCommand.setBuilder(null);
        return buildCommand;
    }

    private void computeIsConfigurable() {
        IConfigurationElement[] iConfigurationElementArray;
        this.triggers |= 0x20;
        IExtension iExtension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.resources", "builders", this.name);
        if (iExtension != null && (iConfigurationElementArray = iExtension.getConfigurationElements()).length != 0) {
            String string = iConfigurationElementArray[0].getAttribute("isConfigurable");
            this.setConfigurable(string != null && string.equalsIgnoreCase(Boolean.TRUE.toString()));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BuildCommand)) {
            return false;
        }
        BuildCommand buildCommand = (BuildCommand)object;
        return this.getBuilderName().equals(buildCommand.getBuilderName()) && this.getArguments(false).equals(buildCommand.getArguments(false)) && this.triggers == buildCommand.triggers;
    }

    public Map getArguments() {
        return this.getArguments(true);
    }

    public Map getArguments(boolean bl) {
        return this.arguments == null ? null : (bl ? (Map)this.arguments.clone() : this.arguments);
    }

    public IncrementalProjectBuilder getBuilder() {
        return this.builder;
    }

    public String getBuilderName() {
        return this.getName();
    }

    public int hashCode() {
        return 37 * this.getName().hashCode() + this.triggers;
    }

    public boolean isBuilding(int n) {
        return (this.triggers & BuildCommand.maskForTrigger(n)) != 0;
    }

    public boolean isConfigurable() {
        if ((this.triggers & 0x20) == 0) {
            this.computeIsConfigurable();
        }
        return (this.triggers & 0x10) != 0;
    }

    public void setArguments(Map map) {
        this.arguments = map == null ? null : new HashMap(map);
    }

    public void setBuilder(IncrementalProjectBuilder incrementalProjectBuilder) {
        this.builder = incrementalProjectBuilder;
    }

    public void setBuilderName(String string) {
        this.setName(string == null ? "" : string);
    }

    public void setBuilding(int n, boolean bl) {
        if (!this.isConfigurable()) {
            return;
        }
        this.triggers = bl ? (this.triggers |= BuildCommand.maskForTrigger(n)) : (this.triggers &= ~BuildCommand.maskForTrigger(n));
    }

    public void setConfigurable(boolean bl) {
        this.triggers |= 0x20;
        this.triggers = bl ? (this.triggers |= 0x10) : 15;
    }

    public String toString() {
        return "BuildCommand(" + this.getName() + ")";
    }
}

