/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.events.AutoBuildJob;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.events.BuilderPersistentInfo;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.InternalBuilder;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.events.ResourceDeltaFactory;
import org.eclipse.core.internal.events.ResourceStats;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class BuildManager
implements ICoreConstants,
IManager,
ILifecycleListener {
    private static final int TOTAL_BUILD_WORK = 100000;
    final AutoBuildJob autoBuildJob;
    private boolean building = false;
    private final ArrayList builtProjects = new ArrayList();
    protected InternalBuilder currentBuilder;
    private DeltaDataTree currentDelta;
    private ElementTree currentLastBuiltTree;
    private ElementTree currentTree;
    private final DeltaCache deltaCache = new DeltaCache();
    private final DeltaCache deltaTreeCache = new DeltaCache();
    private ILock lock;
    private boolean rebuildRequested = false;
    private final Bundle systemBundle = Platform.getBundle((String)"org.eclipse.osgi");
    private long timeStamp = -1L;
    private Workspace workspace;

    public BuildManager(Workspace workspace, ILock iLock) {
        this.workspace = workspace;
        this.autoBuildJob = new AutoBuildJob(workspace);
        this.lock = iLock;
        InternalBuilder.buildManager = this;
    }

    private void basicBuild(int n, IncrementalProjectBuilder incrementalProjectBuilder, Map map, MultiStatus multiStatus, IProgressMonitor iProgressMonitor) {
        try {
            this.currentBuilder = incrementalProjectBuilder;
            this.currentBuilder.clearForgetLastBuiltState();
            boolean bl = n == 15;
            this.currentLastBuiltTree = this.currentBuilder.getLastBuiltTree();
            if (!bl && this.currentLastBuiltTree == null) {
                n = 6;
            }
            if (!incrementalProjectBuilder.getCommand().isBuilding(n)) {
                if (bl) {
                    this.currentBuilder.setLastBuiltTree(null);
                }
                return;
            }
            this.currentTree = n == 6 || bl ? null : this.workspace.getElementTree();
            int n2 = -1;
            try {
                if (!this.needsBuild(this.currentBuilder, n)) {
                    iProgressMonitor.beginTask("", 1);
                    iProgressMonitor.done();
                    return;
                }
                String string = this.currentBuilder.getLabel();
                String string2 = string != null ? NLS.bind((String)Messages.events_invoking_2, (Object)string, (Object)incrementalProjectBuilder.getProject().getFullPath()) : NLS.bind((String)Messages.events_invoking_1, (Object)incrementalProjectBuilder.getProject().getFullPath());
                iProgressMonitor.subTask(string2);
                this.hookStartBuild(incrementalProjectBuilder, n);
                n2 = this.getWorkManager().beginUnprotected();
                SafeRunner.run((ISafeRunnable)this.getSafeRunnable(n, map, multiStatus, iProgressMonitor));
            }
            finally {
                if (n2 >= 0) {
                    this.getWorkManager().endUnprotected(n2);
                }
                if (bl || this.currentBuilder.wasForgetStateRequested()) {
                    this.currentBuilder.setLastBuiltTree(null);
                } else {
                    ElementTree elementTree = this.workspace.getElementTree();
                    elementTree.immutable();
                    this.currentBuilder.setLastBuiltTree(elementTree);
                }
                this.hookEndBuild(incrementalProjectBuilder);
            }
        }
        finally {
            this.currentBuilder = null;
            this.currentTree = null;
            this.currentLastBuiltTree = null;
            this.currentDelta = null;
        }
    }

    protected void basicBuild(IProject iProject, int n, ICommand[] iCommandArray, MultiStatus multiStatus, IProgressMonitor iProgressMonitor) {
        try {
            int n2 = 0;
            while (n2 < iCommandArray.length) {
                this.checkCanceled(n, iProgressMonitor);
                BuildCommand buildCommand = (BuildCommand)iCommandArray[n2];
                IProgressMonitor iProgressMonitor2 = Policy.subMonitorFor(iProgressMonitor, 1);
                IncrementalProjectBuilder incrementalProjectBuilder = this.getBuilder(iProject, buildCommand, n2, multiStatus);
                if (incrementalProjectBuilder != null) {
                    this.basicBuild(n, incrementalProjectBuilder, buildCommand.getArguments(false), multiStatus, iProgressMonitor2);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            multiStatus.add(coreException.getStatus());
        }
    }

    private IStatus basicBuild(IProject iProject, int n, IProgressMonitor iProgressMonitor) {
        if (!this.canRun(n)) {
            return Status.OK_STATUS;
        }
        try {
            this.hookStartBuild(n);
            MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 566, Messages.events_errors, null);
            this.basicBuild(iProject, n, multiStatus, iProgressMonitor);
            MultiStatus multiStatus2 = multiStatus;
            return multiStatus2;
        }
        finally {
            this.hookEndBuild(n);
        }
    }

    private void basicBuild(final IProject iProject, final int n, final MultiStatus multiStatus, final IProgressMonitor iProgressMonitor) {
        try {
            final ICommand[] iCommandArray = iProject.isAccessible() ? ((Project)iProject).internalGetDescription().getBuildSpec(false) : (ICommand[])null;
            int n2 = iCommandArray == null ? 0 : iCommandArray.length;
            iProgressMonitor.beginTask(NLS.bind((String)Messages.events_building_1, (Object)iProject.getFullPath()), n2);
            if (n2 == 0) {
                return;
            }
            ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    if (throwable instanceof OperationCanceledException) {
                        if (Policy.DEBUG_BUILD_INVOKING) {
                            Policy.debug("Build canceled");
                        }
                        throw (OperationCanceledException)throwable;
                    }
                    String string = throwable.getMessage();
                    if (string == null) {
                        string = NLS.bind((String)Messages.events_unknown, (Object)throwable.getClass().getName(), (Object)iProject.getName());
                    }
                    multiStatus.add((IStatus)new Status(2, "org.eclipse.core.resources", 566, string, throwable));
                }

                public void run() throws Exception {
                    BuildManager.this.basicBuild(iProject, n, iCommandArray, multiStatus, iProgressMonitor);
                }
            };
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private IStatus basicBuild(IProject iProject, int n, String string, Map map, IProgressMonitor iProgressMonitor) {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string2 = NLS.bind((String)Messages.events_building_1, (Object)iProject.getFullPath());
            iProgressMonitor.beginTask(string2, 1);
            if (!this.canRun(n)) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            try {
                this.hookStartBuild(n);
                MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 566, Messages.events_errors, null);
                ICommand iCommand = this.getCommand(iProject, string, map);
                try {
                    IncrementalProjectBuilder incrementalProjectBuilder = this.getBuilder(iProject, iCommand, -1, multiStatus);
                    if (incrementalProjectBuilder != null) {
                        this.basicBuild(n, incrementalProjectBuilder, map, multiStatus, Policy.subMonitorFor(iProgressMonitor, 1));
                    }
                }
                catch (CoreException coreException) {
                    multiStatus.add(coreException.getStatus());
                }
                MultiStatus multiStatus2 = multiStatus;
                this.hookEndBuild(n);
                return multiStatus2;
            }
            catch (Throwable throwable) {
                this.hookEndBuild(n);
                throw throwable;
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void basicBuildLoop(IProject[] iProjectArray, IProject[] iProjectArray2, int n, MultiStatus multiStatus, IProgressMonitor iProgressMonitor) {
        int n2;
        int n3 = iProjectArray.length + iProjectArray2.length;
        if (n3 > 0) {
            n3 = 100000 / n3;
        }
        if ((n2 = this.workspace.getDescription().getMaxBuildIterations()) <= 0) {
            n2 = 1;
        }
        this.rebuildRequested = true;
        int n4 = 0;
        while (this.rebuildRequested && n4 < n2) {
            this.rebuildRequested = false;
            this.builtProjects.clear();
            int n5 = 0;
            while (n5 < iProjectArray.length) {
                if (iProjectArray[n5].isAccessible()) {
                    this.basicBuild(iProjectArray[n5], n, multiStatus, Policy.subMonitorFor(iProgressMonitor, n3));
                    this.builtProjects.add(iProjectArray[n5]);
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < iProjectArray2.length) {
                if (iProjectArray2[n5].isAccessible()) {
                    this.basicBuild(iProjectArray2[n5], n, multiStatus, Policy.subMonitorFor(iProgressMonitor, n3));
                    this.builtProjects.add(iProjectArray2[n5]);
                }
                ++n5;
            }
            n = 10;
            ++n4;
        }
    }

    public IStatus build(int n, IProgressMonitor iProgressMonitor) {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask(Messages.events_building_0, 100000);
            if (!this.canRun(n)) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            try {
                this.hookStartBuild(n);
                IProject[] iProjectArray = this.workspace.getBuildOrder();
                HashSet<IProject> hashSet = new HashSet<IProject>(Arrays.asList(this.workspace.getRoot().getProjects(8)));
                hashSet.removeAll(Arrays.asList(iProjectArray));
                IProject[] iProjectArray2 = hashSet.toArray(new IProject[hashSet.size()]);
                MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 75, Messages.events_errors, null);
                this.basicBuildLoop(iProjectArray, iProjectArray2, n, multiStatus, iProgressMonitor);
                MultiStatus multiStatus2 = multiStatus;
                this.hookEndBuild(n);
                return multiStatus2;
            }
            catch (Throwable throwable) {
                this.hookEndBuild(n);
                throw throwable;
            }
        }
        finally {
            iProgressMonitor.done();
            if (n == 10 || n == 6) {
                this.autoBuildJob.avoidBuild();
            }
        }
    }

    public IStatus build(IProject iProject, int n, String string, Map map, IProgressMonitor iProgressMonitor) {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        if (string == null) {
            return this.basicBuild(iProject, n, iProgressMonitor);
        }
        return this.basicBuild(iProject, n, string, map, iProgressMonitor);
    }

    private boolean canRun(int n) {
        return !this.building;
    }

    private void checkCanceled(int n, IProgressMonitor iProgressMonitor) {
        if (this.systemBundle.getState() == 16) {
            throw new OperationCanceledException();
        }
        Policy.checkCanceled(iProgressMonitor);
        if (n != 9) {
            return;
        }
        if (this.autoBuildJob.isInterrupted()) {
            throw new OperationCanceledException();
        }
    }

    public ArrayList createBuildersPersistentInfo(IProject iProject) throws CoreException {
        ArrayList arrayList = this.getBuildersPersistentInfo(iProject);
        ICommand[] iCommandArray = ((Project)iProject).internalGetDescription().getBuildSpec(false);
        if (iCommandArray.length == 0) {
            return null;
        }
        ArrayList<BuilderPersistentInfo> arrayList2 = new ArrayList<BuilderPersistentInfo>(iCommandArray.length);
        int n = 0;
        while (n < iCommandArray.length) {
            ElementTree elementTree;
            String string = iCommandArray[n].getBuilderName();
            BuilderPersistentInfo builderPersistentInfo = null;
            IncrementalProjectBuilder incrementalProjectBuilder = ((BuildCommand)iCommandArray[n]).getBuilder();
            if (incrementalProjectBuilder == null) {
                if (arrayList != null) {
                    builderPersistentInfo = this.getBuilderInfo(arrayList, string, n);
                }
            } else if (!(incrementalProjectBuilder instanceof MissingBuilder) && (elementTree = incrementalProjectBuilder.getLastBuiltTree()) != null) {
                builderPersistentInfo = new BuilderPersistentInfo(iProject.getName(), string, n);
                builderPersistentInfo.setLastBuildTree(elementTree);
                builderPersistentInfo.setInterestingProjects(incrementalProjectBuilder.getInterestingProjects());
            }
            if (builderPersistentInfo != null) {
                arrayList2.add(builderPersistentInfo);
            }
            ++n;
        }
        return arrayList2;
    }

    private String debugBuilder() {
        return this.currentBuilder == null ? "<no builder>" : this.currentBuilder.getClass().getName();
    }

    private String debugProject() {
        if (this.currentBuilder == null) {
            return "<no project>";
        }
        return this.currentBuilder.getProject().getFullPath().toString();
    }

    private String debugTrigger(int n) {
        switch (n) {
            case 6: {
                return "FULL_BUILD";
            }
            case 15: {
                return "CLEAN_BUILD";
            }
        }
        return "INCREMENTAL_BUILD";
    }

    public void endTopLevel(boolean bl) {
        this.autoBuildJob.build(bl);
    }

    private boolean getBooleanAttribute(IConfigurationElement iConfigurationElement, String string) {
        String string2 = iConfigurationElement.getAttribute(string);
        return string2 != null && string2.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    private IncrementalProjectBuilder getBuilder(IProject iProject, ICommand iCommand, int n, MultiStatus multiStatus) throws CoreException {
        IncrementalProjectBuilder incrementalProjectBuilder = ((BuildCommand)iCommand).getBuilder();
        if (incrementalProjectBuilder == null) {
            incrementalProjectBuilder = this.initializeBuilder(iCommand.getBuilderName(), iProject, n, multiStatus);
            ((BuildCommand)iCommand).setBuilder(incrementalProjectBuilder);
            incrementalProjectBuilder.setCommand(iCommand);
            incrementalProjectBuilder.setProject(iProject);
            ((InternalBuilder)incrementalProjectBuilder).startupOnInitialize();
        }
        if (!this.validateNature(incrementalProjectBuilder, iCommand.getBuilderName())) {
            incrementalProjectBuilder.setLastBuiltTree(null);
            return null;
        }
        return incrementalProjectBuilder;
    }

    private BuilderPersistentInfo getBuilderInfo(ArrayList arrayList, String string, int n) {
        BuilderPersistentInfo builderPersistentInfo = null;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            BuilderPersistentInfo builderPersistentInfo2 = (BuilderPersistentInfo)iterator.next();
            if (!builderPersistentInfo2.getBuilderName().equals(string)) continue;
            if (builderPersistentInfo == null) {
                builderPersistentInfo = builderPersistentInfo2;
            }
            if (n != -1 && builderPersistentInfo2.getBuildSpecIndex() != -1 && n != builderPersistentInfo2.getBuildSpecIndex()) continue;
            return builderPersistentInfo2;
        }
        return builderPersistentInfo;
    }

    public ArrayList getBuildersPersistentInfo(IProject iProject) throws CoreException {
        return (ArrayList)iProject.getSessionProperty(K_BUILD_LIST);
    }

    private ICommand getCommand(IProject iProject, String string, Map map) {
        ICommand[] iCommandArray = ((Project)iProject).internalGetDescription().getBuildSpec(false);
        int n = 0;
        while (n < iCommandArray.length) {
            if (iCommandArray[n].getBuilderName().equals(string)) {
                return iCommandArray[n];
            }
            ++n;
        }
        BuildCommand buildCommand = new BuildCommand();
        buildCommand.setBuilderName(string);
        buildCommand.setArguments(map);
        return buildCommand;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    IResourceDelta getDelta(IProject iProject) {
        try {
            this.lock.acquire();
            if (this.currentTree == null) {
                if (!Policy.DEBUG_BUILD_FAILURE) return null;
                Policy.debug("Build: no tree for delta " + this.debugBuilder() + " [" + this.debugProject() + "]");
                return null;
            }
            if (!this.isInterestingProject(iProject)) {
                if (!Policy.DEBUG_BUILD_FAILURE) return null;
                Policy.debug("Build: project not interesting for this builder " + this.debugBuilder() + " [" + this.debugProject() + "] " + iProject.getFullPath());
                return null;
            }
            if (this.currentDelta != null && this.currentDelta.findNodeAt(iProject.getFullPath()) == null) {
                if (!iProject.exists()) {
                    return null;
                }
                IResourceDelta iResourceDelta = ResourceDeltaFactory.newEmptyDelta(iProject);
                return iResourceDelta;
            }
            IResourceDelta iResourceDelta = (IResourceDelta)this.deltaCache.getDelta(iProject.getFullPath(), this.currentLastBuiltTree, this.currentTree);
            if (iResourceDelta != null) {
                IResourceDelta iResourceDelta2 = iResourceDelta;
                return iResourceDelta2;
            }
            long l = 0L;
            if (Policy.DEBUG_BUILD_DELTA) {
                l = System.currentTimeMillis();
                Policy.debug("Computing delta for project: " + iProject.getName());
            }
            iResourceDelta = ResourceDeltaFactory.computeDelta(this.workspace, this.currentLastBuiltTree, this.currentTree, iProject.getFullPath(), -1L);
            this.deltaCache.cache(iProject.getFullPath(), this.currentLastBuiltTree, this.currentTree, iResourceDelta);
            if (Policy.DEBUG_BUILD_FAILURE && iResourceDelta == null) {
                Policy.debug("Build: no delta " + this.debugBuilder() + " [" + this.debugProject() + "] " + iProject.getFullPath());
            }
            if (Policy.DEBUG_BUILD_DELTA) {
                Policy.debug("Finished computing delta, time: " + (System.currentTimeMillis() - l) + "ms");
            }
            IResourceDelta iResourceDelta3 = iResourceDelta;
            return iResourceDelta3;
        }
        finally {
            this.lock.release();
        }
    }

    private ISafeRunnable getSafeRunnable(final int n, final Map map, final MultiStatus multiStatus, final IProgressMonitor iProgressMonitor) {
        return new ISafeRunnable(){

            public void handleException(Throwable throwable) {
                if (throwable instanceof OperationCanceledException) {
                    if (Policy.DEBUG_BUILD_INVOKING) {
                        Policy.debug("Build canceled");
                    }
                    BuildManager.this.currentBuilder.forgetLastBuiltState();
                    throw (OperationCanceledException)throwable;
                }
                String string = BuildManager.this.currentBuilder.getLabel();
                if (string == null || string.length() == 0) {
                    string = BuildManager.this.currentBuilder.getClass().getName();
                }
                String string2 = BuildManager.this.currentBuilder.getPluginId();
                String string3 = NLS.bind((String)Messages.events_builderError, (Object)string, (Object)BuildManager.this.currentBuilder.getProject().getName());
                multiStatus.add((IStatus)new Status(2, string2, 75, string3, null));
                if (throwable instanceof CoreException) {
                    multiStatus.add(((CoreException)throwable).getStatus());
                } else {
                    string3 = throwable.getMessage();
                    if (string3 == null) {
                        string3 = NLS.bind((String)Messages.events_unknown, (Object)throwable.getClass().getName(), (Object)string);
                    }
                    multiStatus.add((IStatus)new Status(2, string2, 75, string3, throwable));
                }
            }

            public void run() throws Exception {
                IProject[] iProjectArray = null;
                if (n != 15) {
                    iProjectArray = BuildManager.this.currentBuilder.build(n, map, iProgressMonitor);
                } else {
                    BuildManager.this.currentBuilder.clean(iProgressMonitor);
                }
                if (iProjectArray == null) {
                    iProjectArray = new IProject[]{};
                }
                BuildManager.this.currentBuilder.setInterestingProjects((IProject[])iProjectArray.clone());
            }
        };
    }

    private WorkManager getWorkManager() {
        try {
            return this.workspace.getWorkManager();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void handleEvent(LifecycleEvent lifecycleEvent) {
        IProject iProject = null;
        switch (lifecycleEvent.kind) {
            case 16: 
            case 64: {
                iProject = (IProject)lifecycleEvent.resource;
                if (!iProject.isAccessible()) break;
                this.setBuildersPersistentInfo(iProject, null);
            }
        }
    }

    boolean hasBeenBuilt(IProject iProject) {
        return this.builtProjects.contains(iProject);
    }

    private void hookEndBuild(IncrementalProjectBuilder incrementalProjectBuilder) {
        if (ResourceStats.TRACE_BUILDERS) {
            ResourceStats.endBuild();
        }
        if (!Policy.DEBUG_BUILD_INVOKING || this.timeStamp == -1L) {
            return;
        }
        Policy.debug("Builder finished: " + this.toString(incrementalProjectBuilder) + " time: " + (System.currentTimeMillis() - this.timeStamp) + "ms");
        this.timeStamp = -1L;
    }

    private void hookEndBuild(int n) {
        this.building = false;
        this.builtProjects.clear();
        this.deltaCache.flush();
        this.deltaTreeCache.flush();
        if (n == 15) {
            this.autoBuildJob.forceBuild();
        }
    }

    private void hookStartBuild(IncrementalProjectBuilder incrementalProjectBuilder, int n) {
        if (ResourceStats.TRACE_BUILDERS) {
            ResourceStats.startBuild(incrementalProjectBuilder);
        }
        if (Policy.DEBUG_BUILD_INVOKING) {
            this.timeStamp = System.currentTimeMillis();
            Policy.debug("Invoking (" + this.debugTrigger(n) + ") on builder: " + this.toString(incrementalProjectBuilder));
        }
    }

    private void hookStartBuild(int n) {
        this.building = true;
        if (Policy.DEBUG_BUILD_STACK) {
            Status status = new Status(1, "org.eclipse.core.resources", 1, "Starting build: " + this.debugTrigger(n), new RuntimeException().fillInStackTrace());
            Policy.log((IStatus)status);
        }
    }

    private IncrementalProjectBuilder initializeBuilder(String string, IProject iProject, int n, MultiStatus multiStatus) throws CoreException {
        ArrayList arrayList;
        IncrementalProjectBuilder incrementalProjectBuilder = null;
        try {
            incrementalProjectBuilder = this.instantiateBuilder(string);
        }
        catch (CoreException coreException) {
            multiStatus.add((IStatus)new ResourceStatus(75, iProject.getFullPath(), NLS.bind((String)Messages.events_instantiate_1, (Object)string), coreException));
            multiStatus.add(coreException.getStatus());
        }
        if (incrementalProjectBuilder == null) {
            incrementalProjectBuilder = new MissingBuilder(string);
        }
        if ((arrayList = this.getBuildersPersistentInfo(iProject)) != null) {
            BuilderPersistentInfo builderPersistentInfo = this.getBuilderInfo(arrayList, string, n);
            if (builderPersistentInfo != null) {
                arrayList.remove(builderPersistentInfo);
                ElementTree elementTree = builderPersistentInfo.getLastBuiltTree();
                if (elementTree != null) {
                    incrementalProjectBuilder.setLastBuiltTree(elementTree);
                }
                incrementalProjectBuilder.setInterestingProjects(builderPersistentInfo.getInterestingProjects());
            }
            if (arrayList.size() == 0) {
                this.setBuildersPersistentInfo(iProject, null);
            }
        }
        return incrementalProjectBuilder;
    }

    private IncrementalProjectBuilder instantiateBuilder(String string) throws CoreException {
        Object object;
        IExtension iExtension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.resources", "builders", string);
        if (iExtension == null) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        if (iConfigurationElementArray.length == 0) {
            return null;
        }
        String string2 = null;
        if (this.getBooleanAttribute(iConfigurationElementArray[0], "hasNature")) {
            object = iExtension.getUniqueIdentifier();
            string2 = this.workspace.getNatureManager().findNatureForBuilder((String)object);
            if (string2 == null) {
                return null;
            }
        }
        object = (InternalBuilder)iConfigurationElementArray[0].createExecutableExtension("run");
        ((InternalBuilder)object).setPluginId(iExtension.getContributor().getName());
        ((InternalBuilder)object).setLabel(iExtension.getLabel());
        ((InternalBuilder)object).setNatureId(string2);
        ((InternalBuilder)object).setCallOnEmptyDelta(this.getBooleanAttribute(iConfigurationElementArray[0], "callOnEmptyDelta"));
        return (IncrementalProjectBuilder)object;
    }

    public void interrupt() {
        this.autoBuildJob.interrupt();
    }

    private boolean isInterestingProject(IProject iProject) {
        if (iProject.equals(this.currentBuilder.getProject())) {
            return true;
        }
        IProject[] iProjectArray = this.currentBuilder.getInterestingProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            if (iProjectArray[n].equals(iProject)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean needsBuild(InternalBuilder internalBuilder, int n) {
        Object object;
        switch (n) {
            case 15: {
                return true;
            }
            case 6: {
                return true;
            }
            case 10: {
                if (!this.currentBuilder.callOnEmptyDelta()) break;
                return true;
            }
        }
        ElementTree elementTree = internalBuilder.getLastBuiltTree();
        ElementTree elementTree2 = this.workspace.getElementTree();
        long l = System.currentTimeMillis();
        this.currentDelta = (DeltaDataTree)this.deltaTreeCache.getDelta(null, elementTree, elementTree2);
        if (this.currentDelta == null) {
            if (Policy.DEBUG_BUILD_NEEDED) {
                object = "Checking if need to build. Starting delta computation between: " + elementTree.toString() + " and " + elementTree2.toString();
                Policy.debug((String)object);
            }
            this.currentDelta = elementTree2.getDataTree().forwardDeltaWith(elementTree.getDataTree(), ResourceComparator.getBuildComparator());
            if (Policy.DEBUG_BUILD_NEEDED) {
                Policy.debug("End delta computation. (" + (System.currentTimeMillis() - l) + "ms).");
            }
            this.deltaTreeCache.cache(null, elementTree, elementTree2, this.currentDelta);
        }
        if (this.currentDelta.findNodeAt(internalBuilder.getProject().getFullPath()) != null) {
            if (Policy.DEBUG_BUILD_NEEDED) {
                Policy.debug(String.valueOf(this.toString(internalBuilder)) + " needs building because of changes in: " + internalBuilder.getProject().getName());
            }
            return true;
        }
        object = internalBuilder.getInterestingProjects();
        int n2 = 0;
        while (n2 < ((IProject[])object).length) {
            if (this.currentDelta.findNodeAt(object[n2].getFullPath()) != null) {
                if (Policy.DEBUG_BUILD_NEEDED) {
                    Policy.debug(String.valueOf(this.toString(internalBuilder)) + " needs building because of changes in: " + object[n2].getName());
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void removeBuilders(IProject iProject, String string) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        int n = iCommandArray.length;
        if (n == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < iCommandArray.length) {
            if (iCommandArray[n3].getBuilderName().equals(string)) {
                iCommandArray[n3] = null;
            } else {
                ++n2;
            }
            ++n3;
        }
        if (n2 == iCommandArray.length) {
            return;
        }
        ICommand[] iCommandArray2 = new ICommand[n2];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            if (iCommandArray[n4] != null) {
                iCommandArray2[n5++] = iCommandArray[n4];
            }
            ++n4;
        }
        iProjectDescription.setBuildSpec(iCommandArray2);
        iProject.setDescription(iProjectDescription, 0, null);
    }

    void requestRebuild() {
        this.rebuildRequested = true;
    }

    public void setBuildersPersistentInfo(IProject iProject, ArrayList arrayList) {
        try {
            iProject.setSessionProperty(K_BUILD_LIST, arrayList);
        }
        catch (CoreException coreException) {
            Policy.log(new ResourceStatus(4, 1, iProject.getFullPath(), "Project missing in setBuildersPersistentInfo", null));
        }
    }

    public void shutdown(IProgressMonitor iProgressMonitor) {
        this.autoBuildJob.cancel();
    }

    public void startup(IProgressMonitor iProgressMonitor) {
        this.workspace.addLifecycleListener(this);
    }

    private String toString(InternalBuilder internalBuilder) {
        String string = internalBuilder.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return String.valueOf(string) + "(" + internalBuilder.getProject().getName() + ")";
    }

    private boolean validateNature(InternalBuilder internalBuilder, String string) throws CoreException {
        String string2 = internalBuilder.getNatureId();
        if (string2 == null) {
            return true;
        }
        IProject iProject = internalBuilder.getProject();
        if (!iProject.hasNature(string2)) {
            this.removeBuilders(iProject, string);
            return false;
        }
        return iProject.isNatureEnabled(string2);
    }

    public ISchedulingRule getRule(IProject iProject, int n, String string, Map map) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 566, Messages.events_errors, null);
        if (string == null) {
            if (iProject.isAccessible()) {
                HashSet<ISchedulingRule> hashSet = new HashSet<ISchedulingRule>();
                ICommand[] iCommandArray = ((Project)iProject).internalGetDescription().getBuildSpec(false);
                int n2 = 0;
                while (n2 < iCommandArray.length) {
                    BuildCommand buildCommand = (BuildCommand)iCommandArray[n2];
                    try {
                        IncrementalProjectBuilder incrementalProjectBuilder = this.getBuilder(iProject, buildCommand, n2, multiStatus);
                        if (incrementalProjectBuilder != null) {
                            hashSet.add(incrementalProjectBuilder.getRule());
                        }
                    }
                    catch (CoreException coreException) {
                        multiStatus.add(coreException.getStatus());
                    }
                    ++n2;
                }
                return new MultiRule(hashSet.toArray(new ISchedulingRule[hashSet.size()]));
            }
        } else {
            ICommand iCommand = this.getCommand(iProject, string, map);
            try {
                IncrementalProjectBuilder incrementalProjectBuilder = this.getBuilder(iProject, iCommand, -1, multiStatus);
                if (incrementalProjectBuilder != null) {
                    return incrementalProjectBuilder.getRule();
                }
            }
            catch (CoreException coreException) {
                multiStatus.add(coreException.getStatus());
            }
        }
        if (!multiStatus.isOK()) {
            Policy.log((IStatus)multiStatus);
        }
        return this.workspace.getRoot();
    }

    class DeltaCache {
        private Object delta;
        private ElementTree newTree;
        private ElementTree oldTree;
        private IPath projectPath;

        DeltaCache() {
        }

        public void cache(IPath iPath, ElementTree elementTree, ElementTree elementTree2, Object object) {
            this.projectPath = iPath;
            this.oldTree = elementTree;
            this.newTree = elementTree2;
            this.delta = object;
        }

        public void flush() {
            this.projectPath = null;
            this.oldTree = null;
            this.newTree = null;
            this.delta = null;
        }

        public Object getDelta(IPath iPath, ElementTree elementTree, ElementTree elementTree2) {
            boolean bl;
            if (this.delta == null) {
                return null;
            }
            boolean bl2 = this.projectPath == null ? iPath == null : (bl = this.projectPath.equals((Object)iPath));
            if (bl && this.oldTree == elementTree && this.newTree == elementTree2) {
                return this.delta;
            }
            return null;
        }
    }

    class MissingBuilder
    extends IncrementalProjectBuilder {
        private boolean hasBeenBuilt = false;
        private String name;

        MissingBuilder(String string) {
            this.name = string;
        }

        protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) {
            if (!this.hasBeenBuilt && Policy.DEBUG_BUILD_FAILURE) {
                this.hasBeenBuilt = true;
                String string = NLS.bind((String)Messages.events_skippingBuilder, (Object)this.name, (Object)this.getProject().getName());
                Policy.log(2, string, null);
            }
            return null;
        }
    }
}

