/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import org.eclipse.core.runtime.IPath;

public class NodeIDMap {
    private static final int[] SIZES = new int[]{13, 29, 71, 173, 349, 733, 1511, 3079, 6133, 16381, 32653, 65543, 131111, 262139, 524287, 1051601};
    private static final double LOAD_FACTOR = 0.75;
    private static final long LARGE_NUMBER = 2654435761L;
    int sizeOffset = 0;
    protected int elementCount = 0;
    protected long[] ids = new long[SIZES[this.sizeOffset]];
    protected IPath[] oldPaths = new IPath[SIZES[this.sizeOffset]];
    protected IPath[] newPaths = new IPath[SIZES[this.sizeOffset]];

    protected void expand() {
        int n;
        try {
            n = SIZES[++this.sizeOffset];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = this.ids.length * 2;
        }
        long[] lArray = new long[n];
        IPath[] iPathArray = new IPath[n];
        IPath[] iPathArray2 = new IPath[n];
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < this.ids.length) {
            long l = this.ids[n3];
            if (l != 0L) {
                int n4 = this.hashFor(l, n);
                while (lArray[n4] != 0L) {
                    if (++n4 <= n2) continue;
                    n4 = 0;
                }
                lArray[n4] = l;
                iPathArray[n4] = this.oldPaths[n3];
                iPathArray2[n4] = this.newPaths[n3];
            }
            ++n3;
        }
        this.ids = lArray;
        this.oldPaths = iPathArray;
        this.newPaths = iPathArray2;
    }

    private int getIndex(long l) {
        int n;
        int n2 = this.ids.length;
        int n3 = n = this.hashFor(l, n2);
        while (n3 < n2) {
            if (this.ids[n3] == l) {
                return n3;
            }
            if (this.ids[n3] == 0L) {
                return -1;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n - 1) {
            if (this.ids[n3] == l) {
                return n3;
            }
            if (this.ids[n3] == 0L) {
                return -1;
            }
            ++n3;
        }
        return -1;
    }

    public IPath getNewPath(long l) {
        int n = this.getIndex(l);
        if (n == -1) {
            return null;
        }
        return this.newPaths[n];
    }

    public IPath getOldPath(long l) {
        int n = this.getIndex(l);
        if (n == -1) {
            return null;
        }
        return this.oldPaths[n];
    }

    private int hashFor(long l, int n) {
        return (int)Math.abs(l * 2654435761L % (long)n);
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    private void put(long l, IPath iPath, IPath iPath2) {
        int n;
        if (iPath == null && iPath2 == null) {
            return;
        }
        int n2 = n = this.hashFor(l, this.ids.length);
        while (n2 < this.ids.length) {
            if (this.ids[n2] == l) {
                if (iPath != null) {
                    this.oldPaths[n2] = iPath;
                }
                if (iPath2 != null) {
                    this.newPaths[n2] = iPath2;
                }
                return;
            }
            if (this.ids[n2] == 0L) {
                this.ids[n2] = l;
                if (iPath != null) {
                    this.oldPaths[n2] = iPath;
                }
                if (iPath2 != null) {
                    this.newPaths[n2] = iPath2;
                }
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            if (this.ids[n2] == l) {
                if (iPath != null) {
                    this.oldPaths[n2] = iPath;
                }
                if (iPath2 != null) {
                    this.newPaths[n2] = iPath2;
                }
                return;
            }
            if (this.ids[n2] == 0L) {
                this.ids[n2] = l;
                if (iPath != null) {
                    this.oldPaths[n2] = iPath;
                }
                if (iPath2 != null) {
                    this.newPaths[n2] = iPath2;
                }
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return;
            }
            ++n2;
        }
        this.expand();
        this.put(l, iPath, iPath2);
    }

    public void putOldPath(long l, IPath iPath) {
        this.put(l, iPath, null);
    }

    public void putNewPath(long l, IPath iPath) {
        this.put(l, null, iPath);
    }

    private boolean shouldGrow() {
        return (double)this.elementCount > (double)this.ids.length * 0.75;
    }
}

