/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.events.ResourceChangeEvent;
import org.eclipse.core.internal.events.ResourceChangeListenerList;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.internal.events.ResourceDeltaFactory;
import org.eclipse.core.internal.events.ResourceStats;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class NotificationManager
implements IManager,
ILifecycleListener {
    private static final long NOTIFICATION_DELAY = 1500L;
    private Set avoidNotify = new HashSet();
    protected boolean isNotifying;
    private ResourceDelta lastDelta;
    private long lastDeltaId;
    private ElementTree lastDeltaState;
    protected long lastNotifyDuration = 0L;
    private long lastPostBuildId = 0L;
    private ElementTree lastPostBuildTree;
    private long lastPostChangeId = 0L;
    private ElementTree lastPostChangeTree;
    private ResourceChangeListenerList listeners;
    protected boolean notificationRequested = false;
    private Job notifyJob;
    Workspace workspace;

    public NotificationManager(Workspace workspace) {
        this.workspace = workspace;
        this.listeners = new ResourceChangeListenerList();
        this.notifyJob = new NotifyJob();
    }

    public void addListener(IResourceChangeListener iResourceChangeListener, int n) {
        this.listeners.add(iResourceChangeListener, n);
        if (ResourceStats.TRACE_LISTENERS) {
            ResourceStats.listenerAdded(iResourceChangeListener);
        }
    }

    public boolean beginAvoidNotify() {
        return this.avoidNotify.add(Thread.currentThread());
    }

    public void beginNotify() {
        this.notifyJob.cancel();
        this.notificationRequested = false;
    }

    public void broadcastChanges(ElementTree elementTree, ResourceChangeEvent resourceChangeEvent, boolean bl) {
        int n = resourceChangeEvent.getType();
        try {
            int n2;
            if (!this.listeners.hasListenerFor(n)) {
                return;
            }
            this.isNotifying = true;
            ResourceDelta resourceDelta = this.getDelta(elementTree, n);
            if (!(resourceDelta != null && resourceDelta.getKind() != 0 || (n2 = resourceChangeEvent.getBuildKind()) != 9 && n2 != 0)) {
                return;
            }
            resourceChangeEvent.setDelta(resourceDelta);
            long l = System.currentTimeMillis();
            this.notify(this.getListeners(), resourceChangeEvent, bl);
            this.lastNotifyDuration = System.currentTimeMillis() - l;
        }
        finally {
            this.isNotifying = false;
            this.cleanUp(elementTree, n);
        }
    }

    private void cleanUp(ElementTree elementTree, int n) {
        boolean bl;
        boolean bl2 = bl = n == 1;
        if (bl || n == 16) {
            long l = this.workspace.getMarkerManager().getChangeId();
            elementTree.immutable();
            if (bl) {
                this.lastPostChangeTree = elementTree;
                this.lastPostChangeId = l;
            } else {
                this.lastPostBuildTree = elementTree;
                this.lastPostBuildId = l;
            }
            this.workspace.getMarkerManager().resetMarkerDeltas(Math.min(this.lastPostBuildId, this.lastPostChangeId));
            this.lastDelta = null;
            this.lastDeltaState = elementTree;
        }
    }

    public void broadcastChanges(IResourceChangeListener iResourceChangeListener, int n, IResourceDelta iResourceDelta) {
        ResourceChangeListenerList.ListenerEntry[] listenerEntryArray = new ResourceChangeListenerList.ListenerEntry[]{new ResourceChangeListenerList.ListenerEntry(iResourceChangeListener, n)};
        this.notify(listenerEntryArray, new ResourceChangeEvent(this.workspace, n, 0, iResourceDelta), false);
    }

    public void endAvoidNotify() {
        this.avoidNotify.remove(Thread.currentThread());
    }

    public void requestNotify() {
        if (this.isNotifying || this.avoidNotify.contains(Thread.currentThread())) {
            return;
        }
        long l = Math.max(1500L, this.lastNotifyDuration * 10L);
        if (this.notifyJob.getState() == 0) {
            this.notifyJob.schedule(l);
        }
    }

    protected ResourceDelta getDelta(ElementTree elementTree, int n) {
        boolean bl;
        long l = this.workspace.getMarkerManager().getChangeId();
        boolean bl2 = bl = n == 1;
        if (!bl && this.lastDelta != null && !ElementTree.hasChanges(elementTree, this.lastDeltaState, ResourceComparator.getNotificationComparator(), true)) {
            if (l != this.lastDeltaId) {
                Map map = this.workspace.getMarkerManager().getMarkerDeltas(this.lastPostBuildId);
                this.lastDelta.updateMarkers(map);
            }
        } else {
            ElementTree elementTree2 = bl ? this.lastPostChangeTree : this.lastPostBuildTree;
            long l2 = bl ? this.lastPostChangeId : this.lastPostBuildId;
            this.lastDelta = ResourceDeltaFactory.computeDelta(this.workspace, elementTree2, elementTree, (IPath)Path.ROOT, l2 + 1L);
        }
        this.lastDeltaState = elementTree;
        this.lastDeltaId = l;
        return this.lastDelta;
    }

    protected ResourceChangeListenerList.ListenerEntry[] getListeners() {
        return this.listeners.getListeners();
    }

    public void handleEvent(LifecycleEvent lifecycleEvent) {
        switch (lifecycleEvent.kind) {
            case 1: {
                if (!this.listeners.hasListenerFor(2)) {
                    return;
                }
                IProject iProject = (IProject)lifecycleEvent.resource;
                this.notify(this.getListeners(), new ResourceChangeEvent(this.workspace, 2, iProject), true);
                break;
            }
            case 64: {
                if (lifecycleEvent.resource.equals(lifecycleEvent.newResource)) {
                    return;
                }
            }
            case 16: {
                if (!this.listeners.hasListenerFor(4)) {
                    return;
                }
                IProject iProject = (IProject)lifecycleEvent.resource;
                this.notify(this.getListeners(), new ResourceChangeEvent(this.workspace, 4, iProject), true);
                break;
            }
            case 4096: {
                if (!this.listeners.hasListenerFor(32)) {
                    return;
                }
                if (lifecycleEvent.resource.getType() == 4) {
                    this.notify(this.getListeners(), new ResourceChangeEvent(lifecycleEvent.resource, 32, lifecycleEvent.resource), true);
                    break;
                }
                if (lifecycleEvent.resource.getType() != 8) break;
                this.notify(this.getListeners(), new ResourceChangeEvent(this.workspace, 32, null), true);
            }
        }
    }

    private void notify(ResourceChangeListenerList.ListenerEntry[] listenerEntryArray, final IResourceChangeEvent iResourceChangeEvent, boolean bl) {
        int n = iResourceChangeEvent.getType();
        boolean bl2 = this.workspace.isTreeLocked();
        if (bl) {
            this.workspace.setTreeLocked(true);
        }
        try {
            int n2 = 0;
            while (n2 < listenerEntryArray.length) {
                if ((n & listenerEntryArray[n2].eventMask) != 0) {
                    final IResourceChangeListener iResourceChangeListener = listenerEntryArray[n2].listener;
                    if (ResourceStats.TRACE_LISTENERS) {
                        ResourceStats.startNotify(iResourceChangeListener);
                    }
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable throwable) {
                        }

                        public void run() throws Exception {
                            iResourceChangeListener.resourceChanged(iResourceChangeEvent);
                        }
                    });
                    if (ResourceStats.TRACE_LISTENERS) {
                        ResourceStats.endNotify();
                    }
                }
                ++n2;
            }
        }
        finally {
            if (bl) {
                this.workspace.setTreeLocked(bl2);
            }
        }
    }

    public void removeListener(IResourceChangeListener iResourceChangeListener) {
        this.listeners.remove(iResourceChangeListener);
        if (ResourceStats.TRACE_LISTENERS) {
            ResourceStats.listenerRemoved(iResourceChangeListener);
        }
    }

    public boolean shouldNotify() {
        return !this.isNotifying && this.notificationRequested;
    }

    public void shutdown(IProgressMonitor iProgressMonitor) {
        this.listeners = new ResourceChangeListenerList();
    }

    public void startup(IProgressMonitor iProgressMonitor) {
        this.lastPostBuildTree = this.lastPostChangeTree = this.workspace.getElementTree();
        this.workspace.addLifecycleListener(this);
    }

    class NotifyJob
    extends Job {
        private final IWorkspaceRunnable noop = new IWorkspaceRunnable(this){
            final /* synthetic */ NotifyJob this$1;
            {
                this.this$1 = notifyJob;
            }

            public void run(IProgressMonitor iProgressMonitor) {
            }
        };

        public NotifyJob() {
            super(Messages.resources_updating);
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor iProgressMonitor) {
            if (iProgressMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            NotificationManager.this.notificationRequested = true;
            try {
                NotificationManager.this.workspace.run(this.noop, null, 0, null);
            }
            catch (CoreException coreException) {
                return coreException.getStatus();
            }
            return Status.OK_STATUS;
        }
    }
}

