/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.EventObject;
import org.eclipse.core.resources.IPathVariableChangeEvent;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.runtime.IPath;

public class PathVariableChangeEvent
extends EventObject
implements IPathVariableChangeEvent {
    private static final long serialVersionUID = 1L;
    private String variableName;
    private IPath value;
    private int type;

    public PathVariableChangeEvent(IPathVariableManager iPathVariableManager, String string, IPath iPath, int n) {
        super(iPathVariableManager);
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Invalid event type: " + n);
        }
        this.variableName = string;
        this.value = iPath;
        this.type = n;
    }

    public IPath getValue() {
        return this.value;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        String[] stringArray = new String[]{"VARIABLE_CHANGED", "VARIABLE_CREATED", "VARIABLE_DELETED"};
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("[variable = ");
        stringBuffer.append(this.variableName);
        stringBuffer.append(", type = ");
        stringBuffer.append(stringArray[this.type - 1]);
        if (this.type != 3) {
            stringBuffer.append(", value = ");
            stringBuffer.append(this.value);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

