/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.internal.events.ResourceDeltaInfo;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.MarkerDelta;
import org.eclipse.core.internal.resources.MarkerSet;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;

public class ResourceChangeEvent
extends EventObject
implements IResourceChangeEvent {
    private static final IMarkerDelta[] NO_MARKER_DELTAS = new IMarkerDelta[0];
    private static final long serialVersionUID = 1L;
    IResourceDelta delta;
    IResource resource;
    private int trigger = 0;
    int type;

    protected ResourceChangeEvent(Object object, int n, IResource iResource) {
        super(object);
        this.resource = iResource;
        this.type = n;
    }

    public ResourceChangeEvent(Object object, int n, int n2, IResourceDelta iResourceDelta) {
        super(object);
        this.delta = iResourceDelta;
        this.trigger = n2;
        this.type = n;
    }

    public IMarkerDelta[] findMarkerDeltas(String string, boolean bl) {
        if (this.delta == null) {
            return NO_MARKER_DELTAS;
        }
        ResourceDeltaInfo resourceDeltaInfo = ((ResourceDelta)this.delta).getDeltaInfo();
        if (resourceDeltaInfo == null) {
            return NO_MARKER_DELTAS;
        }
        Map map = resourceDeltaInfo.getMarkerDeltas();
        if (map == null || map.size() == 0) {
            return NO_MARKER_DELTAS;
        }
        ArrayList<MarkerDelta> arrayList = new ArrayList<MarkerDelta>();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            MarkerSet markerSet = (MarkerSet)iterator.next();
            IMarkerSetElement[] iMarkerSetElementArray = markerSet.elements();
            int n = 0;
            while (n < iMarkerSetElementArray.length) {
                MarkerDelta markerDelta = (MarkerDelta)iMarkerSetElementArray[n];
                if (string == null || (bl ? markerDelta.isSubtypeOf(string) : markerDelta.getType().equals(string))) {
                    arrayList.add(markerDelta);
                }
                ++n;
            }
        }
        return arrayList.toArray(new IMarkerDelta[arrayList.size()]);
    }

    public int getBuildKind() {
        return this.trigger;
    }

    public IResourceDelta getDelta() {
        return this.delta;
    }

    public IResource getResource() {
        return this.resource;
    }

    public int getType() {
        return this.type;
    }

    public void setDelta(IResourceDelta iResourceDelta) {
        this.delta = iResourceDelta;
    }
}

