/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.Assert;

public class ResourceChangeListenerList {
    private static final ListenerEntry[] EMPTY_ARRAY = new ListenerEntry[0];
    private int count1 = 0;
    private int count2 = 0;
    private int count4 = 0;
    private int count8 = 0;
    private int count16 = 0;
    private int count32 = 0;
    private volatile ListenerEntry[] listeners = EMPTY_ARRAY;

    public synchronized void add(IResourceChangeListener iResourceChangeListener, int n) {
        Assert.isNotNull((Object)iResourceChangeListener);
        if (n == 0) {
            this.remove(iResourceChangeListener);
            return;
        }
        ListenerEntry listenerEntry = new ListenerEntry(iResourceChangeListener, n);
        int n2 = this.listeners.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.listeners[n3].listener == iResourceChangeListener) {
                this.removing(this.listeners[n3].eventMask);
                this.adding(n);
                this.listeners[n3] = listenerEntry;
                return;
            }
            ++n3;
        }
        this.adding(n);
        ListenerEntry[] listenerEntryArray = new ListenerEntry[n2 + 1];
        System.arraycopy(this.listeners, 0, listenerEntryArray, 0, n2);
        listenerEntryArray[n2] = listenerEntry;
        this.listeners = listenerEntryArray;
    }

    private void adding(int n) {
        if ((n & 1) != 0) {
            ++this.count1;
        }
        if ((n & 2) != 0) {
            ++this.count2;
        }
        if ((n & 4) != 0) {
            ++this.count4;
        }
        if ((n & 8) != 0) {
            ++this.count8;
        }
        if ((n & 0x10) != 0) {
            ++this.count16;
        }
        if ((n & 0x20) != 0) {
            ++this.count32;
        }
    }

    public ListenerEntry[] getListeners() {
        return this.listeners;
    }

    public boolean hasListenerFor(int n) {
        if (n == 1) {
            return this.count1 > 0;
        }
        if (n == 2) {
            return this.count2 > 0;
        }
        if (n == 4) {
            return this.count4 > 0;
        }
        if (n == 8) {
            return this.count8 > 0;
        }
        if (n == 16) {
            return this.count16 > 0;
        }
        if (n == 32) {
            return this.count32 > 0;
        }
        return false;
    }

    public synchronized void remove(IResourceChangeListener iResourceChangeListener) {
        Assert.isNotNull((Object)iResourceChangeListener);
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.listeners[n2].listener == iResourceChangeListener) {
                this.removing(this.listeners[n2].eventMask);
                if (n == 1) {
                    this.listeners = EMPTY_ARRAY;
                } else {
                    ListenerEntry[] listenerEntryArray = new ListenerEntry[n - 1];
                    System.arraycopy(this.listeners, 0, listenerEntryArray, 0, n2);
                    System.arraycopy(this.listeners, n2 + 1, listenerEntryArray, n2, n - n2 - 1);
                    this.listeners = listenerEntryArray;
                }
                return;
            }
            ++n2;
        }
    }

    private void removing(int n) {
        if ((n & 1) != 0) {
            --this.count1;
        }
        if ((n & 2) != 0) {
            --this.count2;
        }
        if ((n & 4) != 0) {
            --this.count4;
        }
        if ((n & 8) != 0) {
            --this.count8;
        }
        if ((n & 0x10) != 0) {
            --this.count16;
        }
        if ((n & 0x20) != 0) {
            --this.count32;
        }
    }

    static class ListenerEntry {
        int eventMask;
        IResourceChangeListener listener;

        ListenerEntry(IResourceChangeListener iResourceChangeListener, int n) {
            this.listener = iResourceChangeListener;
            this.eventMask = n;
        }
    }
}

