/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.watson.IElementComparator;

public class ResourceComparator
implements IElementComparator,
ICoreConstants {
    protected static final ResourceComparator notificationSingleton = new ResourceComparator(true, false);
    protected static final ResourceComparator buildSingleton = new ResourceComparator(false, false);
    private boolean notification;
    private boolean save;

    public static ResourceComparator getSaveComparator() {
        return new ResourceComparator(false, true);
    }

    public static ResourceComparator getBuildComparator() {
        return buildSingleton;
    }

    public static ResourceComparator getNotificationComparator() {
        return notificationSingleton;
    }

    private ResourceComparator(boolean bl, boolean bl2) {
        this.notification = bl;
        this.save = bl2;
    }

    public int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        int n = 0;
        if (object == null) {
            return ((ResourceInfo)object2).isSet(8) ? 8 : 1;
        }
        if (object2 == null) {
            return ((ResourceInfo)object).isSet(8) ? 16 : 2;
        }
        if (!(object instanceof ResourceInfo) || !(object2 instanceof ResourceInfo)) {
            return 0;
        }
        ResourceInfo resourceInfo = (ResourceInfo)object;
        ResourceInfo resourceInfo2 = (ResourceInfo)object2;
        if (!resourceInfo.isSet(8) && resourceInfo2.isSet(8)) {
            return 2;
        }
        if (resourceInfo.isSet(8) && !resourceInfo2.isSet(8)) {
            return 1;
        }
        if (!this.compareOpen(resourceInfo, resourceInfo2)) {
            n |= 0x4000;
        }
        if (!this.compareContents(resourceInfo, resourceInfo2)) {
            if (resourceInfo.getType() == 4) {
                n |= 0x80000;
            } else if (resourceInfo2.getType() == 1 || resourceInfo.getType() == 1) {
                n |= 0x100;
            }
        }
        if (!this.compareType(resourceInfo, resourceInfo2)) {
            n |= 0x8000;
        }
        if (!this.compareNodeIDs(resourceInfo, resourceInfo2)) {
            n |= 0x40000;
            if (resourceInfo.getType() == 1 && resourceInfo2.getType() == 1) {
                n |= 0x100;
            }
        }
        if (this.compareLocal(resourceInfo, resourceInfo2)) {
            n |= 0x200000;
        }
        if (!this.compareCharsets(resourceInfo, resourceInfo2)) {
            n |= 0x100000;
        }
        if (this.notification && !this.compareSync(resourceInfo, resourceInfo2)) {
            n |= 0x10000;
        }
        if (this.notification && !this.compareMarkers(resourceInfo, resourceInfo2)) {
            n |= 0x20000;
        }
        if (this.save && !this.compareUsed(resourceInfo, resourceInfo2)) {
            n |= 4;
        }
        return n == 0 ? 0 : n | 4;
    }

    private boolean compareCharsets(ResourceInfo resourceInfo, ResourceInfo resourceInfo2) {
        return resourceInfo.getCharsetGenerationCount() == resourceInfo2.getCharsetGenerationCount();
    }

    private boolean compareContents(ResourceInfo resourceInfo, ResourceInfo resourceInfo2) {
        return resourceInfo.getContentId() == resourceInfo2.getContentId();
    }

    private boolean compareLocal(ResourceInfo resourceInfo, ResourceInfo resourceInfo2) {
        if (!resourceInfo.isSet(65536) || !resourceInfo2.isSet(65536)) {
            return false;
        }
        long l = resourceInfo.getModificationStamp();
        long l2 = resourceInfo2.getModificationStamp();
        return (l == -1L || l2 == -1L) && l != l2;
    }

    private boolean compareMarkers(ResourceInfo resourceInfo, ResourceInfo resourceInfo2) {
        boolean bl;
        boolean bl2 = bl = resourceInfo.getMarkers(false) == null && resourceInfo2.getMarkers(false) == null;
        return bl || resourceInfo.getMarkerGenerationCount() == resourceInfo2.getMarkerGenerationCount();
    }

    private boolean compareNodeIDs(ResourceInfo resourceInfo, ResourceInfo resourceInfo2) {
        return resourceInfo.getNodeId() == resourceInfo2.getNodeId();
    }

    private boolean compareOpen(ResourceInfo resourceInfo, ResourceInfo resourceInfo2) {
        return resourceInfo.isSet(1) == resourceInfo2.isSet(1);
    }

    private boolean compareSync(ResourceInfo resourceInfo, ResourceInfo resourceInfo2) {
        return resourceInfo.getSyncInfoGenerationCount() == resourceInfo2.getSyncInfoGenerationCount();
    }

    private boolean compareType(ResourceInfo resourceInfo, ResourceInfo resourceInfo2) {
        return resourceInfo.getType() == resourceInfo2.getType();
    }

    private boolean compareUsed(ResourceInfo resourceInfo, ResourceInfo resourceInfo2) {
        return resourceInfo.isSet(16) == resourceInfo2.isSet(16);
    }
}

