/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.events.NodeIDMap;
import org.eclipse.core.internal.events.ResourceDeltaInfo;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.MarkerSet;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;

public class ResourceDelta
extends PlatformObject
implements IResourceDelta {
    protected IPath path;
    protected ResourceDeltaInfo deltaInfo;
    protected int status;
    protected ResourceInfo oldInfo;
    protected ResourceInfo newInfo;
    protected ResourceDelta[] children;
    protected IResource cachedResource;
    protected static int KIND_MASK = 255;
    private static IMarkerDelta[] EMPTY_MARKER_DELTAS = new IMarkerDelta[0];

    protected ResourceDelta(IPath iPath, ResourceDeltaInfo resourceDeltaInfo) {
        this.path = iPath;
        this.deltaInfo = resourceDeltaInfo;
    }

    public void accept(IResourceDeltaVisitor iResourceDeltaVisitor) throws CoreException {
        this.accept(iResourceDeltaVisitor, 0);
    }

    public void accept(IResourceDeltaVisitor iResourceDeltaVisitor, boolean bl) throws CoreException {
        this.accept(iResourceDeltaVisitor, bl ? 1 : 0);
    }

    public void accept(IResourceDeltaVisitor iResourceDeltaVisitor, int n) throws CoreException {
        int n2;
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = (n & 8) != 0;
        int n3 = n2 = bl ? 31 : 7;
        if ((this.getKind() & n2) == 0) {
            return;
        }
        if (!iResourceDeltaVisitor.visit(this)) {
            return;
        }
        int n4 = 0;
        while (n4 < this.children.length) {
            ResourceDelta resourceDelta = this.children[n4];
            if (!(!bl2 && resourceDelta.isTeamPrivate() || !bl && resourceDelta.isPhantom() || !bl3 && resourceDelta.isHidden())) {
                resourceDelta.accept(iResourceDeltaVisitor, n);
            }
            ++n4;
        }
    }

    protected void checkForMarkerDeltas() {
        MarkerSet markerSet;
        if (this.deltaInfo.getMarkerDeltas() == null) {
            return;
        }
        int n = this.getKind();
        if ((this.path.isRoot() || n == 1 || n == 2) && (markerSet = (MarkerSet)this.deltaInfo.getMarkerDeltas().get(this.path)) != null && markerSet.size() > 0) {
            this.status |= 0x20000;
            if (n == 0) {
                this.status |= 4;
            }
        }
    }

    public IResourceDelta findMember(IPath iPath) {
        int n = iPath.segmentCount();
        if (n == 0) {
            return this;
        }
        ResourceDelta resourceDelta = this;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            ResourceDelta[] resourceDeltaArray;
            block4: {
                resourceDeltaArray = resourceDelta.children;
                n3 = 0;
                int n4 = resourceDeltaArray.length;
                while (n3 < n4) {
                    if (!resourceDeltaArray[n3].getFullPath().lastSegment().equals(iPath.segment(n2))) {
                        ++n3;
                        continue;
                    }
                    break block4;
                }
                return null;
            }
            resourceDelta = resourceDeltaArray[n3];
            ++n2;
        }
        return resourceDelta;
    }

    protected void fixMovesAndMarkers(ElementTree elementTree) {
        int n;
        NodeIDMap nodeIDMap = this.deltaInfo.getNodeIDMap();
        if (!this.path.isRoot() && !nodeIDMap.isEmpty()) {
            IPath iPath;
            n = this.getKind();
            switch (n) {
                case 1: 
                case 4: {
                    iPath = nodeIDMap.getOldPath(this.newInfo.getNodeId());
                    if (iPath == null || iPath.equals((Object)this.path)) break;
                    ResourceInfo resourceInfo = (ResourceInfo)elementTree.getElementData(iPath);
                    this.status = this.status & KIND_MASK | this.deltaInfo.getComparator().compare(resourceInfo, this.newInfo) & ~KIND_MASK;
                    this.status |= 0x1000;
                    if (n == 4) {
                        this.status = this.status | 0x40000 | 0x100;
                    }
                    if (this.oldInfo == null || this.newInfo == null || this.oldInfo.getType() == this.newInfo.getType()) break;
                    this.status |= 0x8000;
                }
            }
            switch (n) {
                case 2: 
                case 4: {
                    iPath = nodeIDMap.getNewPath(this.oldInfo.getNodeId());
                    if (iPath == null || iPath.equals((Object)this.path)) break;
                    this.status |= 0x2000;
                    if (n != 4) break;
                    this.status = this.status | 0x40000 | 0x100;
                }
            }
        }
        this.checkForMarkerDeltas();
        n = 0;
        while (n < this.children.length) {
            this.children[n].fixMovesAndMarkers(elementTree);
            ++n;
        }
    }

    public IResourceDelta[] getAffectedChildren() {
        return this.getAffectedChildren(7, 0);
    }

    public IResourceDelta[] getAffectedChildren(int n) {
        return this.getAffectedChildren(n, 0);
    }

    public IResourceDelta[] getAffectedChildren(int n, int n2) {
        boolean bl;
        int n3 = this.children.length;
        if (n3 == 0) {
            return this.children;
        }
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = (n2 & 2) != 0;
        boolean bl4 = bl = (n2 & 8) != 0;
        if (bl2) {
            n |= 0x18;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            if (!((this.children[n5].getKind() & n) == 0 || !bl2 && this.children[n5].isPhantom() || !bl3 && this.children[n5].isTeamPrivate() || !bl && this.children[n5].isHidden())) {
                ++n4;
            }
            ++n5;
        }
        if (n4 == n3) {
            IResourceDelta[] iResourceDeltaArray = new IResourceDelta[this.children.length];
            System.arraycopy(this.children, 0, iResourceDeltaArray, 0, this.children.length);
            return iResourceDeltaArray;
        }
        IResourceDelta[] iResourceDeltaArray = new IResourceDelta[n4];
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            if (!((this.children[n7].getKind() & n) == 0 || !bl2 && this.children[n7].isPhantom() || !bl3 && this.children[n7].isTeamPrivate() || !bl && this.children[n7].isHidden())) {
                iResourceDeltaArray[n6++] = this.children[n7];
            }
            ++n7;
        }
        return iResourceDeltaArray;
    }

    protected ResourceDeltaInfo getDeltaInfo() {
        return this.deltaInfo;
    }

    public int getFlags() {
        return this.status & ~KIND_MASK;
    }

    public IPath getFullPath() {
        return this.path;
    }

    public int getKind() {
        return this.status & KIND_MASK;
    }

    public IMarkerDelta[] getMarkerDeltas() {
        MarkerSet markerSet;
        Map map = this.deltaInfo.getMarkerDeltas();
        if (map == null) {
            return EMPTY_MARKER_DELTAS;
        }
        if (this.path == null) {
            this.path = Path.ROOT;
        }
        if ((markerSet = (MarkerSet)map.get(this.path)) == null) {
            return EMPTY_MARKER_DELTAS;
        }
        IMarkerSetElement[] iMarkerSetElementArray = markerSet.elements();
        IMarkerDelta[] iMarkerDeltaArray = new IMarkerDelta[iMarkerSetElementArray.length];
        int n = 0;
        while (n < iMarkerSetElementArray.length) {
            iMarkerDeltaArray[n] = (IMarkerDelta)((Object)iMarkerSetElementArray[n]);
            ++n;
        }
        return iMarkerDeltaArray;
    }

    public IPath getMovedFromPath() {
        if ((this.status & 0x1000) != 0) {
            return this.deltaInfo.getNodeIDMap().getOldPath(this.newInfo.getNodeId());
        }
        return null;
    }

    public IPath getMovedToPath() {
        if ((this.status & 0x2000) != 0) {
            return this.deltaInfo.getNodeIDMap().getNewPath(this.oldInfo.getNodeId());
        }
        return null;
    }

    public IPath getProjectRelativePath() {
        IPath iPath = this.getFullPath();
        int n = iPath.segmentCount();
        if (n < 0) {
            return null;
        }
        if (n <= 1) {
            return Path.EMPTY;
        }
        return iPath.removeFirstSegments(1);
    }

    public IResource getResource() {
        if (this.cachedResource != null) {
            return this.cachedResource;
        }
        if (this.path.segmentCount() == 0) {
            return this.deltaInfo.getWorkspace().getRoot();
        }
        ResourceInfo resourceInfo = null;
        resourceInfo = (this.getKind() & 0x12) != 0 ? this.oldInfo : this.newInfo;
        if (resourceInfo == null) {
            Assert.isNotNull(null, (String)("Do not have resource info for resource in delta: " + this.path));
        }
        this.cachedResource = this.deltaInfo.getWorkspace().newResource(this.path, resourceInfo.getType());
        return this.cachedResource;
    }

    protected boolean isPhantom() {
        if ((this.status & 0x12) != 0) {
            return ResourceInfo.isSet(this.oldInfo.getFlags(), 8);
        }
        return ResourceInfo.isSet(this.newInfo.getFlags(), 8);
    }

    protected boolean isTeamPrivate() {
        if ((this.status & 0x12) != 0) {
            return ResourceInfo.isSet(this.oldInfo.getFlags(), 32768);
        }
        return ResourceInfo.isSet(this.newInfo.getFlags(), 32768);
    }

    protected boolean isHidden() {
        if ((this.status & 0x12) != 0) {
            return ResourceInfo.isSet(this.oldInfo.getFlags(), 0x200000);
        }
        return ResourceInfo.isSet(this.newInfo.getFlags(), 0x200000);
    }

    protected void setChildren(ResourceDelta[] resourceDeltaArray) {
        this.children = resourceDeltaArray;
    }

    protected void setNewInfo(ResourceInfo resourceInfo) {
        this.newInfo = resourceInfo;
    }

    protected void setOldInfo(ResourceInfo resourceInfo) {
        this.oldInfo = resourceInfo;
    }

    protected void setStatus(int n) {
        this.status = n;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.writeDebugString(stringBuffer);
        return stringBuffer.toString();
    }

    public String toDeepDebugString() {
        StringBuffer stringBuffer = new StringBuffer("\n");
        this.writeDebugString(stringBuffer);
        int n = 0;
        while (n < this.children.length) {
            stringBuffer.append(this.children[n].toDeepDebugString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "ResourceDelta(" + this.path + ')';
    }

    public void updateMarkers(Map map) {
        this.deltaInfo.setMarkerDeltas(map);
    }

    public void writeDebugString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getFullPath());
        stringBuffer.append('[');
        switch (this.getKind()) {
            case 1: {
                stringBuffer.append('+');
                break;
            }
            case 8: {
                stringBuffer.append('>');
                break;
            }
            case 2: {
                stringBuffer.append('-');
                break;
            }
            case 16: {
                stringBuffer.append('<');
                break;
            }
            case 4: {
                stringBuffer.append('*');
                break;
            }
            case 0: {
                stringBuffer.append('~');
                break;
            }
            default: {
                stringBuffer.append('?');
            }
        }
        stringBuffer.append("]: {");
        int n = this.getFlags();
        boolean bl = false;
        if ((n & 0x100) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CONTENT");
            bl = true;
        }
        if ((n & 0x200000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("LOCAL_CHANGED");
            bl = true;
        }
        if ((n & 0x1000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("MOVED_FROM(" + this.getMovedFromPath() + ")");
            bl = true;
        }
        if ((n & 0x2000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("MOVED_TO(" + this.getMovedToPath() + ")");
            bl = true;
        }
        if ((n & 0x4000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("OPEN");
            bl = true;
        }
        if ((n & 0x8000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("TYPE");
            bl = true;
        }
        if ((n & 0x10000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("SYNC");
            bl = true;
        }
        if ((n & 0x20000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("MARKERS");
            this.writeMarkerDebugString(stringBuffer);
            bl = true;
        }
        if ((n & 0x40000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("REPLACED");
            bl = true;
        }
        if ((n & 0x80000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("DESCRIPTION");
            bl = true;
        }
        if ((n & 0x100000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("ENCODING");
            bl = true;
        }
        stringBuffer.append("}");
        if (this.isTeamPrivate()) {
            stringBuffer.append(" (team private)");
        }
        if (this.isHidden()) {
            stringBuffer.append(" (hidden)");
        }
    }

    public void writeMarkerDebugString(StringBuffer stringBuffer) {
        Map map = this.deltaInfo.getMarkerDeltas();
        if (map == null || map.isEmpty()) {
            return;
        }
        stringBuffer.append('[');
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            IPath iPath = (IPath)iterator.next();
            if (!this.getResource().getFullPath().equals((Object)iPath)) continue;
            IMarkerSetElement[] iMarkerSetElementArray = ((MarkerSet)map.get(iPath)).elements();
            boolean bl = false;
            int n = 0;
            while (n < iMarkerSetElementArray.length) {
                IMarkerDelta iMarkerDelta = (IMarkerDelta)((Object)iMarkerSetElementArray[n]);
                if (bl) {
                    stringBuffer.append(',');
                }
                switch (iMarkerDelta.getKind()) {
                    case 1: {
                        stringBuffer.append('+');
                        break;
                    }
                    case 2: {
                        stringBuffer.append('-');
                        break;
                    }
                    case 4: {
                        stringBuffer.append('*');
                    }
                }
                stringBuffer.append(iMarkerDelta.getId());
                bl = true;
                ++n;
            }
        }
        stringBuffer.append(']');
    }
}

