/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.Map;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.dtree.NodeComparison;
import org.eclipse.core.internal.events.NodeIDMap;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.internal.events.ResourceDeltaInfo;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ResourceDeltaFactory {
    protected static final ResourceDelta[] NO_CHILDREN = new ResourceDelta[0];

    public static ResourceDelta computeDelta(Workspace workspace, ElementTree elementTree, ElementTree elementTree2, IPath iPath, long l) {
        ResourceComparator resourceComparator = l >= 0L ? ResourceComparator.getNotificationComparator() : ResourceComparator.getBuildComparator();
        elementTree2.immutable();
        DeltaDataTree deltaDataTree = null;
        deltaDataTree = Path.ROOT.equals((Object)iPath) ? elementTree2.getDataTree().compareWith(elementTree.getDataTree(), resourceComparator) : elementTree2.getDataTree().compareWith(elementTree.getDataTree(), resourceComparator, iPath);
        deltaDataTree = deltaDataTree.asReverseComparisonTree(resourceComparator);
        Path path = iPath.isRoot() ? Path.ROOT : iPath;
        Path path2 = Path.ROOT;
        Map map = null;
        if (l >= 0L) {
            map = workspace.getMarkerManager().getMarkerDeltas(l);
        }
        ResourceDeltaInfo resourceDeltaInfo = new ResourceDeltaInfo(workspace, map, resourceComparator);
        ResourceDelta resourceDelta = ResourceDeltaFactory.createDelta(workspace, deltaDataTree, resourceDeltaInfo, (IPath)path, (IPath)path2);
        resourceDeltaInfo.setNodeIDMap(ResourceDeltaFactory.computeNodeIDMap(resourceDelta, new NodeIDMap()));
        resourceDelta.fixMovesAndMarkers(elementTree);
        int n = resourceDelta.getFullPath().segmentCount();
        if (n <= 1) {
            ResourceDeltaFactory.checkForOpen(resourceDelta, n);
        }
        return resourceDelta;
    }

    protected static void checkForOpen(ResourceDelta resourceDelta, int n) {
        if (resourceDelta.getKind() == 1 && resourceDelta.newInfo.isSet(1)) {
            resourceDelta.status |= 0x4000;
        }
        if (n == 1) {
            return;
        }
        ResourceDelta[] resourceDeltaArray = resourceDelta.children;
        int n2 = 0;
        while (n2 < resourceDeltaArray.length) {
            ResourceDeltaFactory.checkForOpen(resourceDeltaArray[n2], 1);
            ++n2;
        }
    }

    protected static NodeIDMap computeNodeIDMap(ResourceDelta resourceDelta, NodeIDMap nodeIDMap) {
        ResourceDelta[] resourceDeltaArray = resourceDelta.children;
        int n = 0;
        while (n < resourceDeltaArray.length) {
            ResourceDelta resourceDelta2 = resourceDeltaArray[n];
            IPath iPath = resourceDelta2.getFullPath();
            switch (resourceDelta2.getKind()) {
                case 1: {
                    nodeIDMap.putNewPath(resourceDelta2.newInfo.getNodeId(), iPath);
                    break;
                }
                case 2: {
                    nodeIDMap.putOldPath(resourceDelta2.oldInfo.getNodeId(), iPath);
                    break;
                }
                case 4: {
                    long l = resourceDelta2.oldInfo.getNodeId();
                    long l2 = resourceDelta2.newInfo.getNodeId();
                    if (l == l2) break;
                    nodeIDMap.putOldPath(l, iPath);
                    nodeIDMap.putNewPath(l2, iPath);
                }
            }
            ResourceDeltaFactory.computeNodeIDMap(resourceDelta2, nodeIDMap);
            ++n;
        }
        return nodeIDMap;
    }

    protected static ResourceDelta createDelta(Workspace workspace, DeltaDataTree deltaDataTree, ResourceDeltaInfo resourceDeltaInfo, IPath iPath, IPath iPath2) {
        IPath[] iPathArray;
        ResourceDelta resourceDelta = new ResourceDelta(iPath, resourceDeltaInfo);
        NodeComparison nodeComparison = (NodeComparison)deltaDataTree.getData(iPath2);
        int n = nodeComparison.getUserComparison();
        resourceDelta.setStatus(n);
        if (n == 0 || Path.ROOT.equals((Object)iPath)) {
            iPathArray = workspace.getResourceInfo(iPath, true, false);
            resourceDelta.setOldInfo((ResourceInfo)iPathArray);
            resourceDelta.setNewInfo((ResourceInfo)iPathArray);
        } else {
            resourceDelta.setOldInfo((ResourceInfo)nodeComparison.getOldData());
            resourceDelta.setNewInfo((ResourceInfo)nodeComparison.getNewData());
        }
        iPathArray = deltaDataTree.getChildren(iPath2);
        int n2 = iPathArray.length;
        if (n2 == 0) {
            resourceDelta.setChildren(NO_CHILDREN);
        } else {
            ResourceDelta[] resourceDeltaArray = new ResourceDelta[n2];
            int n3 = 0;
            while (n3 < n2) {
                IPath iPath3 = iPath == iPath2 ? iPathArray[n3] : iPath.append(iPathArray[n3].lastSegment());
                resourceDeltaArray[n3] = ResourceDeltaFactory.createDelta(workspace, deltaDataTree, resourceDeltaInfo, iPath3, iPathArray[n3]);
                ++n3;
            }
            resourceDelta.setChildren(resourceDeltaArray);
        }
        int n4 = resourceDelta.status;
        if ((n4 & 0x1F) == 0 && n2 != 0) {
            resourceDelta.setStatus(n4 |= 4);
        }
        return resourceDelta;
    }

    public static IResourceDelta newEmptyDelta(IProject iProject) {
        ResourceDelta resourceDelta = new ResourceDelta(iProject.getFullPath(), new ResourceDeltaInfo((Workspace)iProject.getWorkspace(), null, ResourceComparator.getBuildComparator()));
        resourceDelta.setStatus(0);
        resourceDelta.setChildren(NO_CHILDREN);
        ResourceInfo resourceInfo = ((Project)iProject).getResourceInfo(true, false);
        resourceDelta.setOldInfo(resourceInfo);
        resourceDelta.setNewInfo(resourceInfo);
        return resourceDelta;
    }
}

