/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class BlobStore {
    protected IFileStore localStore;
    protected byte mask;
    private static byte[] randomArray = new byte[]{-43, -25, 37, 85, -45, 29, -95, -81, -69, 3, -109, -10, -86, 30, -54, -73, -14, 47, -2, -67, 25, -8, -63, 2, 119, -123, 125, 12, 76, -43, -37, 79, 69, -123, -54, 80, -106, -66, -99, -66, 80, -66, -37, -106, -87, 117, 95, 10, 77, -42, -23, 70, 5, -68, 44, 91, -91, -107, -79, 93, 17, 112, 4, 41, -26, -108, -68, 107, -43, 31, 52, 60, 111, -10, -30, 121, -127, -59, -112, -8, 92, -123, 96, 116, 104, 67, 74, -112, -71, -115, 96, 34, -74, 90, 36, -39, 28, -51, 107, 52, -55, 14, 8, 1, 27, -40, 60, 35, -5, -62, 7, -100, 32, 5, -111, 29, 96, 61, 110, -111, 50, 56, -21, -17, -86, -118, 17, -45, 56, 98, 101, 126, 27, 57, -45, -112, -50, -49, -77, 111, -96, 50, -13, 69, 106, 118, -101, -97, 28, 57, 11, -81, 43, -83, 96, -75, 99, -87, -85, -100, -10, -13, 30, -58, -5, 81, 77, 92, -96, -21, -41, -69, 23, 71, 58, -9, 127, 56, 118, -124, 79, -68, 42, -68, -98, 121, -1, 65, -102, 118, -84, -39, 4, 47, 105, -52, -121, 27, 43, 90, 9, 31, 59, 115, -63, 28, 55, 101, 9, 117, -45, 112, 61, 55, 23, -21, 51, 104, 123, -118, 76, -108, 115, 119, 81, 54, 39, 46, -107, -65, 79, 16, -34, 69, -37, -120, -108, -75, 77, -6, 101, -33, -116, -62, -115, 44, -61, -39, 31, -33, -49, -107, -11, 115, -13, -73};

    public BlobStore(IFileStore iFileStore, int n) {
        Assert.isNotNull((Object)iFileStore);
        this.localStore = iFileStore;
        Assert.isTrue((boolean)this.localStore.fetchInfo().isDirectory());
        Assert.isTrue((n == 256 || n == 128 || n == 64 || n == 32 || n == 16 || n == 8 || n == 4 || n == 2 || n == 1 ? 1 : 0) != 0);
        this.mask = (byte)(n - 1);
    }

    public UniversalUniqueIdentifier addBlob(IFileStore iFileStore, boolean bl) throws CoreException {
        UniversalUniqueIdentifier universalUniqueIdentifier = new UniversalUniqueIdentifier();
        this.folderFor(universalUniqueIdentifier).mkdir(0, null);
        IFileStore iFileStore2 = this.fileFor(universalUniqueIdentifier);
        if (bl) {
            iFileStore.move(iFileStore2, 0, null);
        } else {
            iFileStore.copy(iFileStore2, 0, null);
        }
        return universalUniqueIdentifier;
    }

    private void appendByteString(StringBuffer stringBuffer, byte by) {
        String string = by < 0 ? Integer.toHexString(256 + by) : Integer.toHexString(by);
        if (string.length() == 1) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
    }

    private String bytesToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            this.appendByteString(stringBuffer, byArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void deleteBlob(UniversalUniqueIdentifier universalUniqueIdentifier) {
        Assert.isNotNull((Object)universalUniqueIdentifier);
        try {
            this.fileFor(universalUniqueIdentifier).delete(0, null);
        }
        catch (CoreException coreException) {}
    }

    public void deleteBlobs(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.deleteBlob((UniversalUniqueIdentifier)iterator.next());
        }
    }

    public IFileStore fileFor(UniversalUniqueIdentifier universalUniqueIdentifier) {
        IFileStore iFileStore = this.folderFor(universalUniqueIdentifier);
        return iFileStore.getChild(this.bytesToHexString(universalUniqueIdentifier.toBytes()));
    }

    public IFileStore folderFor(UniversalUniqueIdentifier universalUniqueIdentifier) {
        byte by = this.hashUUIDbytes(universalUniqueIdentifier);
        by = (byte)(by & this.mask);
        String string = Integer.toHexString(by + (0x80 & this.mask));
        return this.localStore.getChild(string);
    }

    public InputStream getBlob(UniversalUniqueIdentifier universalUniqueIdentifier) throws CoreException {
        IFileStore iFileStore = this.fileFor(universalUniqueIdentifier);
        return iFileStore.openInputStream(0, null);
    }

    protected byte hashUUIDbytes(UniversalUniqueIdentifier universalUniqueIdentifier) {
        byte[] byArray = universalUniqueIdentifier.toBytes();
        byte by = 0;
        int n = 0;
        while (n < byArray.length) {
            by = (byte)(by ^ randomArray[byArray[n] + 128]);
            ++n;
        }
        return by;
    }
}

