/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public abstract class Bucket {
    static final String INDEXES_DIR_NAME = ".indexes";
    private final Map entries = new HashMap();
    private File location;
    private boolean needSaving = false;
    protected String projectName;

    public final int accept(Visitor visitor, IPath iPath, int n) throws CoreException {
        if (this.entries.isEmpty()) {
            return 0;
        }
        try {
            Iterator iterator = this.entries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Path path = new Path((String)entry.getKey());
                int n2 = iPath.matchingFirstSegments((IPath)path);
                if (!iPath.isPrefixOf((IPath)path) || path.segmentCount() - n2 > n) continue;
                Entry entry2 = this.createEntry((IPath)path, entry.getValue());
                int n3 = visitor.visit(entry2);
                entry2.visited();
                if (entry2.isDeleted()) {
                    this.needSaving = true;
                    iterator.remove();
                } else if (entry2.isDirty()) {
                    this.needSaving = true;
                    entry.setValue(entry2.getValue());
                }
                if (n3 == 0) continue;
                int n4 = n3;
                return n4;
            }
            return 0;
        }
        finally {
            visitor.beforeSaving(this);
            this.save();
            visitor.afterSaving(this);
        }
    }

    private void cleanUp(File file) {
        if (!file.delete()) {
            return;
        }
        if (file.getName().equals(INDEXES_DIR_NAME)) {
            return;
        }
        this.cleanUp(file.getParentFile());
    }

    protected abstract Entry createEntry(IPath var1, Object var2);

    public void flush() {
        this.projectName = null;
        this.location = null;
        this.entries.clear();
        this.needSaving = false;
    }

    public final int getEntryCount() {
        return this.entries.size();
    }

    public final Object getEntryValue(String string) {
        return this.entries.get(string);
    }

    protected abstract String getIndexFileName();

    protected abstract byte getVersion();

    protected abstract String getVersionFileName();

    public void load(String string, File file) throws CoreException {
        this.load(string, file, false);
    }

    public void load(String string, File file, boolean bl) throws CoreException {
        try {
            if (!bl && this.location != null && file.equals(this.location.getParentFile()) && (this.projectName == null ? string == null : this.projectName.equals(string))) {
                this.projectName = string;
                return;
            }
            this.save();
            this.projectName = string;
            this.location = new File(file, this.getIndexFileName());
            this.entries.clear();
            if (!this.location.isFile()) {
                return;
            }
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.location), 8192));
            try {
                byte by = dataInputStream.readByte();
                if (by != this.getVersion()) {
                    String string2 = NLS.bind((String)Messages.resources_readMetaWrongVersion, (Object)this.location.getAbsolutePath(), (Object)Integer.toString(by));
                    ResourceStatus resourceStatus = new ResourceStatus(567, string2);
                    throw new ResourceException(resourceStatus);
                }
                int n = dataInputStream.readInt();
                int n2 = 0;
                while (n2 < n) {
                    this.entries.put(this.readEntryKey(dataInputStream), this.readEntryValue(dataInputStream));
                    ++n2;
                }
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            String string3 = NLS.bind((String)Messages.resources_readMeta, (Object)this.location.getAbsolutePath());
            ResourceStatus resourceStatus = new ResourceStatus(567, null, string3, iOException);
            throw new ResourceException(resourceStatus);
        }
    }

    private String readEntryKey(DataInputStream dataInputStream) throws IOException {
        if (this.projectName == null) {
            return dataInputStream.readUTF();
        }
        return String.valueOf('/') + this.projectName + dataInputStream.readUTF();
    }

    protected abstract Object readEntryValue(DataInputStream var1) throws IOException, CoreException;

    public void save() throws CoreException {
        if (!this.needSaving) {
            return;
        }
        try {
            if (this.entries.isEmpty()) {
                this.needSaving = false;
                this.cleanUp(this.location);
                return;
            }
            File file = this.location.getParentFile();
            if (file == null) {
                throw new IOException();
            }
            file.mkdirs();
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.location), 8192));
            try {
                dataOutputStream.write(this.getVersion());
                dataOutputStream.writeInt(this.entries.size());
                Iterator iterator = this.entries.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    this.writeEntryKey(dataOutputStream, (String)entry.getKey());
                    this.writeEntryValue(dataOutputStream, entry.getValue());
                }
            }
            finally {
                dataOutputStream.close();
            }
            this.needSaving = false;
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)Messages.resources_writeMeta, (Object)this.location.getAbsolutePath());
            ResourceStatus resourceStatus = new ResourceStatus(568, null, string, iOException);
            throw new ResourceException(resourceStatus);
        }
    }

    public final void setEntryValue(String string, Object object) {
        if (object == null) {
            this.entries.remove(string);
        } else {
            this.entries.put(string, object);
        }
        this.needSaving = true;
    }

    private void writeEntryKey(DataOutputStream dataOutputStream, String string) throws IOException {
        int n;
        if (this.projectName == null) {
            dataOutputStream.writeUTF(string);
            return;
        }
        int n2 = string.length();
        String string2 = n2 == (n = this.projectName.length()) + 1 ? "" : string.substring(n + 1);
        dataOutputStream.writeUTF(string2);
    }

    protected abstract void writeEntryValue(DataOutputStream var1, Object var2) throws IOException, CoreException;

    public static abstract class Entry {
        private static final int STATE_CLEAR = 0;
        private static final int STATE_DELETED = 2;
        private static final int STATE_DIRTY = 1;
        private IPath path;
        private byte state = 0;

        protected Entry(IPath iPath) {
            this.path = iPath;
        }

        public void delete() {
            this.state = (byte)2;
        }

        public abstract int getOccurrences();

        public IPath getPath() {
            return this.path;
        }

        public abstract Object getValue();

        public boolean isDeleted() {
            return this.state == 2;
        }

        public boolean isDirty() {
            return this.state == 1;
        }

        public boolean isEmpty() {
            return this.getOccurrences() == 0;
        }

        public void markDirty() {
            Assert.isTrue((this.state != 2 ? 1 : 0) != 0);
            this.state = 1;
        }

        public void visited() {
        }
    }

    public static abstract class Visitor {
        public static final int CONTINUE = 0;
        public static final int RETURN = 2;

        public void afterSaving(Bucket bucket) throws CoreException {
        }

        public void beforeSaving(Bucket bucket) throws CoreException {
        }

        public abstract int visit(Entry var1);
    }
}

