/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class BucketTree {
    public static final int DEPTH_INFINITE = Integer.MAX_VALUE;
    public static final int DEPTH_ONE = 1;
    public static final int DEPTH_ZERO = 0;
    private static final int SEGMENT_QUOTA = 256;
    private static final char[][] HEX_STRINGS = new char[256][];
    protected Bucket current;
    private Workspace workspace;

    static {
        int n = 0;
        while (n < HEX_STRINGS.length) {
            BucketTree.HEX_STRINGS[n] = Integer.toHexString(n).toCharArray();
            ++n;
        }
    }

    public BucketTree(Workspace workspace, Bucket bucket) {
        this.current = bucket;
        this.workspace = workspace;
    }

    public void accept(Bucket.Visitor visitor, IPath iPath, int n) throws CoreException {
        if (Path.ROOT.equals((Object)iPath)) {
            this.current.load(null, this.locationFor((IPath)Path.ROOT));
            if (this.current.accept(visitor, iPath, 0) != 0) {
                return;
            }
            if (n == 0) {
                return;
            }
            boolean bl = true;
            --n;
            IProject[] iProjectArray = this.workspace.getRoot().getProjects(8);
            int n2 = 0;
            while (bl && n2 < iProjectArray.length) {
                IPath iPath2 = iProjectArray[n2].getFullPath();
                bl = this.internalAccept(visitor, iPath2, this.locationFor(iPath2), n, 1);
                ++n2;
            }
        } else {
            this.internalAccept(visitor, iPath, this.locationFor(iPath), n, 0);
        }
    }

    public void close() throws CoreException {
        this.current.save();
        this.saveVersion();
    }

    public Bucket getCurrent() {
        return this.current;
    }

    public File getVersionFile() {
        return new File(this.locationFor((IPath)Path.ROOT), this.current.getVersionFileName());
    }

    private boolean internalAccept(Bucket.Visitor visitor, IPath iPath, File file, int n, int n2) throws CoreException {
        this.current.load(iPath.segment(0), file);
        int n3 = this.current.accept(visitor, iPath, n);
        if (n3 != 0) {
            return n3 == 2;
        }
        if (n <= n2) {
            return true;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return true;
        }
        int n4 = 0;
        while (n4 < fileArray.length) {
            if (fileArray[n4].isDirectory() && !this.internalAccept(visitor, iPath, fileArray[n4], n, n2 + 1)) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public void loadBucketFor(IPath iPath) throws CoreException {
        this.current.load(Path.ROOT.equals((Object)iPath) ? null : iPath.segment(0), this.locationFor(iPath));
    }

    private File locationFor(IPath iPath) {
        IPath iPath2 = this.workspace.getMetaArea().locationFor(iPath).removeTrailingSeparator();
        int n = iPath.segmentCount();
        String string = iPath2.toOSString();
        StringBuffer stringBuffer = new StringBuffer(string.length() + ".indexes".length() + 16);
        stringBuffer.append(string);
        stringBuffer.append(File.separatorChar);
        stringBuffer.append(".indexes");
        int n2 = 1;
        while (n2 < n - 1) {
            stringBuffer.append(File.separatorChar);
            stringBuffer.append(this.translateSegment(iPath.segment(n2)));
            ++n2;
        }
        return new File(stringBuffer.toString());
    }

    private void saveVersion() throws CoreException {
        File file = this.getVersionFile();
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(this.current.getVersion());
            }
            catch (IOException iOException) {
                bl = true;
                String string = NLS.bind((String)Messages.resources_writeWorkspaceMeta, (Object)file.getAbsolutePath());
                throw new ResourceException(568, null, string, iOException);
            }
        }
        finally {
            block12: {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    if (bl) break block12;
                    String string = NLS.bind((String)Messages.resources_writeWorkspaceMeta, (Object)file.getAbsolutePath());
                    throw new ResourceException(568, null, string, iOException);
                }
            }
        }
    }

    private char[] translateSegment(String string) {
        return HEX_STRINGS[Math.abs(string.hashCode()) % 256];
    }
}

