/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.localstore.RefreshLocalVisitor;
import org.eclipse.core.internal.localstore.UnifiedTreeNode;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;

public class CollectSyncStatusVisitor
extends RefreshLocalVisitor {
    protected List affectedResources;
    private boolean ignoreLocalDeletions = false;
    protected MultiStatus status;

    public CollectSyncStatusVisitor(String string, IProgressMonitor iProgressMonitor) {
        super(iProgressMonitor);
        this.status = new MultiStatus("org.eclipse.core.resources", 1, string, null);
    }

    protected void changed(Resource resource) {
        String string = NLS.bind((String)Messages.localstore_resourceIsOutOfSync, (Object)resource.getFullPath());
        this.status.add((IStatus)new ResourceStatus(274, resource.getFullPath(), string));
        if (this.affectedResources == null) {
            this.affectedResources = new ArrayList(20);
        }
        this.affectedResources.add(resource);
        this.resourceChanged = true;
    }

    protected void createResource(UnifiedTreeNode unifiedTreeNode, Resource resource) {
        this.changed(resource);
    }

    protected void deleteResource(UnifiedTreeNode unifiedTreeNode, Resource resource) {
        if (!this.ignoreLocalDeletions) {
            this.changed(resource);
        }
    }

    protected void fileToFolder(UnifiedTreeNode unifiedTreeNode, Resource resource) {
        this.changed(resource);
    }

    protected void folderToFile(UnifiedTreeNode unifiedTreeNode, Resource resource) {
        this.changed(resource);
    }

    public List getAffectedResources() {
        return this.affectedResources;
    }

    public MultiStatus getSyncStatus() {
        return this.status;
    }

    protected void makeLocal(UnifiedTreeNode unifiedTreeNode, Resource resource) {
        this.changed(resource);
    }

    protected void refresh(Container container) {
        this.changed(container);
    }

    protected void resourceChanged(UnifiedTreeNode unifiedTreeNode, Resource resource) {
        this.changed(resource);
    }

    public void setIgnoreLocalDeletions(boolean bl) {
        this.ignoreLocalDeletions = bl;
    }
}

