/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.net.URI;
import java.util.LinkedList;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.localstore.IUnifiedTreeVisitor;
import org.eclipse.core.internal.localstore.RefreshLocalVisitor;
import org.eclipse.core.internal.localstore.UnifiedTreeNode;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;

public class CopyVisitor
implements IUnifiedTreeVisitor {
    protected IResource rootDestination;
    protected IProgressMonitor monitor;
    protected int updateFlags;
    protected boolean force;
    protected boolean isDeep;
    protected int segmentsToDrop;
    protected MultiStatus status;
    protected RefreshLocalVisitor refreshLocalVisitor;
    private FileSystemResourceManager localManager;

    public CopyVisitor(IResource iResource, IResource iResource2, int n, IProgressMonitor iProgressMonitor) {
        this.localManager = ((Resource)iResource).getLocalManager();
        this.rootDestination = iResource2;
        this.updateFlags = n;
        this.isDeep = (n & 0x20) == 0;
        this.force = (n & 1) != 0;
        this.monitor = iProgressMonitor;
        this.segmentsToDrop = iResource.getFullPath().segmentCount();
        this.status = new MultiStatus("org.eclipse.core.resources", 1, Messages.localstore_copyProblem, null);
    }

    protected boolean copy(UnifiedTreeNode unifiedTreeNode) {
        IPath iPath;
        Resource resource;
        Resource resource2 = (Resource)unifiedTreeNode.getResource();
        if (!this.copyProperties(resource2, resource = this.getDestinationResource(resource2, iPath = resource2.getFullPath().removeFirstSegments(this.segmentsToDrop)))) {
            return false;
        }
        return this.copyContents(unifiedTreeNode, resource2, resource);
    }

    protected boolean copyContents(UnifiedTreeNode unifiedTreeNode, Resource resource, Resource resource2) {
        block7: {
            block6: {
                if (!resource.isGroup()) break block6;
                ((Folder)resource2).createGroup(this.updateFlags & 0x10, null);
                return true;
            }
            if (this.isDeep && !resource.isUnderGroup() || !resource.isLinked()) break block7;
            URI uRI = this.getWorkspace().transferVariableDefinition(resource, resource2, resource.getRawLocationURI());
            resource2.createLink(uRI, this.updateFlags & 0x10, null);
            return false;
        }
        try {
            Cloneable cloneable;
            Object object;
            Object object2;
            if (resource.hasFilters()) {
                object2 = (Project)resource.getProject();
                object = ((Project)object2).internalGetDescription().getFilter(resource.getProjectRelativePath());
                cloneable = FilterDescription.copy((LinkedList)object, resource2.getProjectRelativePath());
                Project project = (Project)resource2.getProject();
                project.internalGetDescription().setFilters(resource2.getProjectRelativePath(), (LinkedList)cloneable);
                project.writeDescription(this.updateFlags);
            }
            object2 = unifiedTreeNode.getStore();
            object = resource2.getStore();
            if (resource2 == this.rootDestination) {
                object.getParent().mkdir(0, Policy.subMonitorFor(this.monitor, 0));
            }
            object2.copy(object, 4, Policy.subMonitorFor(this.monitor, 0));
            cloneable = this.localManager.getWorkspace().createResource((IResource)resource2, this.updateFlags);
            this.localManager.updateLocalSync((ResourceInfo)cloneable, object.fetchInfo().getLastModified());
            this.getWorkspace().getAliasManager().updateAliases(resource2, (IFileStore)object, 0, this.monitor);
        }
        catch (CoreException coreException) {
            this.status.add(coreException.getStatus());
        }
        return true;
    }

    protected boolean copyProperties(Resource resource, Resource resource2) {
        try {
            resource.getPropertyManager().copy(resource, resource2, 0);
            return true;
        }
        catch (CoreException coreException) {
            this.status.add(coreException.getStatus());
            return false;
        }
    }

    protected Resource getDestinationResource(Resource resource, IPath iPath) {
        if (iPath.segmentCount() == 0) {
            return (Resource)this.rootDestination;
        }
        IPath iPath2 = this.rootDestination.getFullPath().append(iPath);
        return this.getWorkspace().newResource(iPath2, resource.getType());
    }

    protected RefreshLocalVisitor getRefreshLocalVisitor() {
        if (this.refreshLocalVisitor == null) {
            this.refreshLocalVisitor = new RefreshLocalVisitor(Policy.monitorFor(null));
        }
        return this.refreshLocalVisitor;
    }

    public IStatus getStatus() {
        return this.status;
    }

    protected Workspace getWorkspace() {
        return (Workspace)this.rootDestination.getWorkspace();
    }

    protected boolean isSynchronized(UnifiedTreeNode unifiedTreeNode) {
        if (unifiedTreeNode.getResource().isGroup()) {
            return true;
        }
        if (!unifiedTreeNode.existsInWorkspace() || !unifiedTreeNode.existsInFileSystem()) {
            return false;
        }
        if (unifiedTreeNode.isFolder() && unifiedTreeNode.getResource().getType() == 2) {
            return true;
        }
        Resource resource = (Resource)unifiedTreeNode.getResource();
        long l = resource.getResourceInfo(false, false).getLocalSyncInfo();
        return l == unifiedTreeNode.getLastModified();
    }

    protected void synchronize(UnifiedTreeNode unifiedTreeNode) throws CoreException {
        this.getRefreshLocalVisitor().visit(unifiedTreeNode);
    }

    public boolean visit(UnifiedTreeNode unifiedTreeNode) throws CoreException {
        Policy.checkCanceled(this.monitor);
        int n = 1;
        try {
            if (unifiedTreeNode.getStore() == null) {
                IPath iPath = unifiedTreeNode.getResource().getFullPath();
                String string = NLS.bind((String)Messages.localstore_locationUndefined, (Object)iPath);
                this.status.add((IStatus)new ResourceStatus(271, iPath, string, null));
                return false;
            }
            boolean bl = this.isSynchronized(unifiedTreeNode);
            if (this.force && !bl) {
                this.synchronize(unifiedTreeNode);
                n = 0;
                if (!unifiedTreeNode.existsInFileSystem()) {
                    IPath iPath = unifiedTreeNode.getResource().getFullPath();
                    String string = NLS.bind((String)Messages.resources_mustExist, (Object)iPath);
                    this.status.add((IStatus)new ResourceStatus(368, iPath, string, null));
                    return false;
                }
            }
            if (!this.force && !bl) {
                IPath iPath = unifiedTreeNode.getResource().getFullPath();
                String string = NLS.bind((String)Messages.localstore_resourceIsOutOfSync, (Object)iPath);
                this.status.add((IStatus)new ResourceStatus(274, iPath, string, null));
                return true;
            }
            boolean bl2 = this.copy(unifiedTreeNode);
            return bl2;
        }
        finally {
            this.monitor.worked(n);
        }
    }
}

