/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.localstore.IUnifiedTreeVisitor;
import org.eclipse.core.internal.localstore.UnifiedTreeNode;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;

public class DeleteVisitor
implements IUnifiedTreeVisitor,
ICoreConstants {
    protected boolean force;
    protected boolean keepHistory;
    protected IProgressMonitor monitor;
    protected List skipList;
    protected MultiStatus status;
    private int ticks;

    public DeleteVisitor(List list, int n, IProgressMonitor iProgressMonitor, int n2) {
        this.skipList = list;
        this.ticks = n2;
        this.force = (n & 1) != 0;
        this.keepHistory = (n & 2) != 0;
        this.monitor = iProgressMonitor;
        this.status = new MultiStatus("org.eclipse.core.resources", 273, Messages.localstore_deleteProblem, null);
    }

    protected void delete(UnifiedTreeNode unifiedTreeNode, boolean bl) {
        Resource resource = (Resource)unifiedTreeNode.getResource();
        try {
            IFileStore iFileStore;
            boolean bl2 = !resource.isLinked() && unifiedTreeNode.existsInFileSystem();
            IFileStore iFileStore2 = iFileStore = bl2 ? unifiedTreeNode.getStore() : null;
            if (bl2 && bl) {
                this.recursiveKeepHistory(resource.getLocalManager().getHistoryStore(), unifiedTreeNode);
            }
            unifiedTreeNode.removeChildrenFromTree();
            int n = this.ticks < 0 ? 0 : this.ticks;
            this.ticks -= n;
            if (bl2) {
                iFileStore.delete(0, Policy.subMonitorFor(this.monitor, n));
            } else {
                this.monitor.worked(n);
            }
            if (unifiedTreeNode.existsInWorkspace()) {
                resource.deleteResource(true, this.status);
            }
        }
        catch (CoreException coreException) {
            this.status.add(coreException.getStatus());
            try {
                resource.refreshLocal(2, null);
            }
            catch (CoreException coreException2) {}
        }
    }

    protected boolean equals(IResource iResource, IResource iResource2) {
        return iResource.getFullPath().equals((Object)iResource2.getFullPath());
    }

    public MultiStatus getStatus() {
        return this.status;
    }

    protected boolean isAncestor(IResource iResource, IResource iResource2) {
        return iResource.getFullPath().isPrefixOf(iResource2.getFullPath()) && !this.equals(iResource, iResource2);
    }

    protected boolean isAncestorOfResourceToSkip(IResource iResource) {
        if (this.skipList == null) {
            return false;
        }
        int n = 0;
        while (n < this.skipList.size()) {
            IResource iResource2 = (IResource)this.skipList.get(n);
            if (this.isAncestor(iResource, iResource2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void recursiveKeepHistory(IHistoryStore iHistoryStore, UnifiedTreeNode unifiedTreeNode) {
        IResource iResource = unifiedTreeNode.getResource();
        if (iResource.isLinked() || iResource.isGroup() || unifiedTreeNode.isSymbolicLink()) {
            return;
        }
        if (unifiedTreeNode.isFolder()) {
            this.monitor.subTask(NLS.bind((String)Messages.localstore_deleting, (Object)iResource.getFullPath()));
            Iterator iterator = unifiedTreeNode.getChildren();
            while (iterator.hasNext()) {
                this.recursiveKeepHistory(iHistoryStore, (UnifiedTreeNode)iterator.next());
            }
        } else {
            IFileInfo iFileInfo = unifiedTreeNode.fileInfo;
            if (iFileInfo == null) {
                iFileInfo = new FileInfo(unifiedTreeNode.getLocalName());
            }
            iHistoryStore.addState(iResource.getFullPath(), unifiedTreeNode.getStore(), iFileInfo, true);
        }
        this.monitor.worked(1);
        --this.ticks;
    }

    protected void removeFromSkipList(IResource iResource) {
        if (this.skipList != null) {
            this.skipList.remove(iResource);
        }
    }

    protected boolean shouldSkip(IResource iResource) {
        if (this.skipList == null) {
            return false;
        }
        int n = 0;
        while (n < this.skipList.size()) {
            if (this.equals(iResource, (IResource)this.skipList.get(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean visit(UnifiedTreeNode unifiedTreeNode) {
        Policy.checkCanceled(this.monitor);
        Resource resource = (Resource)unifiedTreeNode.getResource();
        if (this.shouldSkip(resource)) {
            this.removeFromSkipList(resource);
            int n = resource.countResources(2, false);
            this.monitor.worked(n);
            this.ticks -= n;
            return false;
        }
        if (this.isAncestorOfResourceToSkip(resource)) {
            return true;
        }
        this.delete(unifiedTreeNode, this.keepHistory);
        return false;
    }
}

