/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FileStoreRoot {
    private int chop;
    private boolean isValid = true;
    private IPath localRoot = null;
    private URI root;

    FileStoreRoot(URI uRI, IPath iPath) {
        Assert.isNotNull((Object)uRI);
        Assert.isNotNull((Object)iPath);
        this.root = uRI;
        this.chop = iPath.segmentCount();
        this.localRoot = this.toLocalPath(this.root);
    }

    private IPathVariableManager getManager(IPath iPath) {
        if (iPath.segmentCount() > 0) {
            IResource iResource;
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            if (iPath.segmentCount() > 1) {
                iPath = iPath.removeLastSegments(iPath.segmentCount() - 1);
            }
            if ((iResource = iWorkspaceRoot.findMember(iPath)) != null && iResource.getType() == 4) {
                return ((IProject)iResource).getPathVariableManager();
            }
        }
        return ResourcesPlugin.getWorkspace().getPathVariableManager();
    }

    public URI computeURI(IPath iPath) {
        IPath iPath2 = iPath.removeFirstSegments(this.chop);
        URI uRI = this.getManager(iPath).resolveURI(this.root);
        if (iPath2.segmentCount() == 0) {
            return uRI;
        }
        try {
            return EFS.getStore((URI)uRI).getChild(iPath2).toURI();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    IFileStore createStore(IPath iPath) throws CoreException {
        IPath iPath2 = iPath.removeFirstSegments(this.chop);
        URI uRI = this.getManager(iPath).resolveURI(this.root);
        if (!uRI.isAbsolute()) {
            return EFS.getNullFileSystem().getStore(iPath);
        }
        IFileStore iFileStore = EFS.getStore((URI)uRI);
        if (iPath2.segmentCount() == 0) {
            return iFileStore;
        }
        return iFileStore.getChild(iPath2);
    }

    boolean isValid() {
        return this.isValid;
    }

    IPath localLocation(IPath iPath) {
        if (this.localRoot == null) {
            return null;
        }
        IPath iPath2 = iPath.segmentCount() <= this.chop ? this.localRoot : this.localRoot.append(iPath.removeFirstSegments(this.chop));
        iPath2 = this.getManager(iPath).resolvePath(iPath2);
        if (!iPath2.isAbsolute()) {
            return null;
        }
        return iPath2;
    }

    void setValid(boolean bl) {
        this.isValid = bl;
    }

    private IPath toLocalPath(URI uRI) {
        try {
            File file = EFS.getStore((URI)uRI).toLocalFile(0, null);
            return file == null ? null : new Path(file.getAbsolutePath());
        }
        catch (CoreException coreException) {
            return FileUtil.toPath(uRI);
        }
    }
}

