/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileTree;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.localstore.CollectSyncStatusVisitor;
import org.eclipse.core.internal.localstore.CopyVisitor;
import org.eclipse.core.internal.localstore.DeleteVisitor;
import org.eclipse.core.internal.localstore.FileStoreRoot;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.localstore.IUnifiedTreeVisitor;
import org.eclipse.core.internal.localstore.IsSynchronizedVisitor;
import org.eclipse.core.internal.localstore.RefreshLocalAliasVisitor;
import org.eclipse.core.internal.localstore.RefreshLocalVisitor;
import org.eclipse.core.internal.localstore.UnifiedTree;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ModelObjectWriter;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourcesCompatibilityHelper;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.BitMask;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;

public class FileSystemResourceManager
implements ICoreConstants,
IManager {
    protected IHistoryStore _historyStore;
    protected Workspace workspace;

    public FileSystemResourceManager(Workspace workspace) {
        this.workspace = workspace;
    }

    protected ArrayList allPathsForLocation(URI uRI) {
        URI uRI2 = FileUtil.canonicalURI(uRI);
        boolean bl = "file".equals(uRI.getScheme());
        IWorkspaceRoot iWorkspaceRoot = this.getWorkspace().getRoot();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (URIUtil.equals((URI)uRI2, (URI)iWorkspaceRoot.getLocationURI())) {
            arrayList.add(Path.ROOT);
            return arrayList;
        }
        IProject[] iProjectArray = iWorkspaceRoot.getProjects(8);
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            URI uRI3 = iProject.getLocationURI();
            if (uRI3 != null) {
                if (bl && !"file".equals(uRI3.getScheme())) {
                    uRI3 = this.getFileURI(uRI3);
                }
                if (uRI3 != null) {
                    HashMap hashMap;
                    ProjectDescription projectDescription;
                    URI uRI4 = uRI3.relativize(uRI2);
                    if (!uRI4.isAbsolute() && !uRI4.equals(uRI3)) {
                        projectDescription = new Path(uRI4.getPath());
                        arrayList.add(iProject.getFullPath().append((IPath)projectDescription));
                    }
                    if ((projectDescription = ((Project)iProject).internalGetDescription()) != null && (hashMap = projectDescription.getLinks()) != null) {
                        Iterator iterator = hashMap.values().iterator();
                        while (iterator.hasNext()) {
                            LinkDescription linkDescription = (LinkDescription)iterator.next();
                            uRI3 = iProject.getPathVariableManager().resolveURI(linkDescription.getLocationURI());
                            if (bl && !"file".equals(uRI3.getScheme())) {
                                uRI3 = this.getFileURI(uRI3);
                            }
                            if (uRI3 == null || (uRI4 = uRI3.relativize(uRI2)).isAbsolute() || uRI4.equals(uRI3)) continue;
                            Path path = new Path(uRI4.getPath());
                            arrayList.add(iProject.getFullPath().append(linkDescription.getProjectRelativePath()).append((IPath)path));
                        }
                    }
                }
            }
            ++n;
        }
        return arrayList;
    }

    private URI getFileURI(URI uRI) {
        try {
            IFileStore iFileStore = EFS.getStore((URI)uRI);
            java.io.File file = iFileStore.toLocalFile(0, null);
            if (file != null) {
                return URIUtil.toURI((String)file.getAbsolutePath());
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public IResource[] allResourcesFor(URI uRI, boolean bl, int n) {
        IResource iResource;
        ArrayList arrayList = this.allPathsForLocation(uRI);
        int n2 = 0;
        int n3 = 0;
        int n4 = arrayList.size();
        while (n3 < n4) {
            iResource = this.resourceFor((IPath)arrayList.get(n3), bl);
            if (iResource == null || (n & 8) == 0 && iResource.isHidden(512) || (n & 2) == 0 && iResource.isTeamPrivateMember(512)) {
                iResource = null;
            }
            arrayList.set(n3, iResource);
            if (iResource != null) {
                ++n2;
            }
            ++n3;
        }
        IResource[] iResourceArray = bl ? new IFile[n2] : new IContainer[n2];
        n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            iResource = (IResource)iterator.next();
            if (iResource == null) continue;
            iResourceArray[n2++] = iResource;
        }
        return iResourceArray;
    }

    public ResourceAttributes attributes(IResource iResource) {
        IFileStore iFileStore = this.getStore(iResource);
        IFileInfo iFileInfo = iFileStore.fetchInfo();
        if (!iFileInfo.exists()) {
            return null;
        }
        return FileUtil.fileInfoToAttributes(iFileInfo);
    }

    public IContainer containerForLocation(IPath iPath) {
        IPath iPath2 = this.pathForLocation(iPath);
        return iPath2 == null ? null : (IContainer)this.resourceFor(iPath2, false);
    }

    public void copy(IResource iResource, IResource iResource2, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            int n2 = ((Resource)iResource).countResources(2, false);
            String string = NLS.bind((String)Messages.localstore_copying, (Object)iResource.getFullPath());
            iProgressMonitor.beginTask(string, n2);
            IFileStore iFileStore = this.getStore(iResource2);
            if (iFileStore.fetchInfo().exists()) {
                String string2 = NLS.bind((String)Messages.localstore_resourceExists, (Object)iResource2.getFullPath());
                throw new ResourceException(272, iResource2.getFullPath(), string2, null);
            }
            this.getHistoryStore().copyHistory(iResource, iResource2, false);
            CopyVisitor copyVisitor = new CopyVisitor(iResource, iResource2, n, iProgressMonitor);
            UnifiedTree unifiedTree = new UnifiedTree(iResource);
            unifiedTree.accept(copyVisitor, 2);
            IStatus iStatus = copyVisitor.getStatus();
            if (!iStatus.isOK()) {
                throw new ResourceException(iStatus);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void delete(IResource iResource, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            Object object;
            Resource resource = (Resource)iResource;
            int n2 = resource.countResources(2, false) * 2;
            boolean bl = (n & 1) != 0;
            int n3 = 0;
            if (!bl) {
                n3 = Math.min(n2, 100);
            }
            String string = NLS.bind((String)Messages.localstore_deleting, (Object)resource.getFullPath());
            iProgressMonitor.beginTask(string, n2 + n3);
            iProgressMonitor.subTask("");
            MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 273, Messages.localstore_deleteProblem, null);
            List list = null;
            UnifiedTree unifiedTree = new UnifiedTree(iResource);
            if (!bl) {
                object = Policy.subMonitorFor(iProgressMonitor, n3);
                object.beginTask("", 1000);
                try {
                    CollectSyncStatusVisitor collectSyncStatusVisitor = new CollectSyncStatusVisitor(Messages.localstore_deleteProblem, (IProgressMonitor)object);
                    collectSyncStatusVisitor.setIgnoreLocalDeletions(true);
                    unifiedTree.accept(collectSyncStatusVisitor, 2);
                    multiStatus.merge((IStatus)collectSyncStatusVisitor.getSyncStatus());
                    list = collectSyncStatusVisitor.getAffectedResources();
                }
                finally {
                    object.done();
                }
            }
            object = new DeleteVisitor(list, n, iProgressMonitor, n2);
            unifiedTree.accept((IUnifiedTreeVisitor)object, 2);
            multiStatus.merge((IStatus)((DeleteVisitor)object).getStatus());
            if (!multiStatus.isOK()) {
                throw new ResourceException((IStatus)multiStatus);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean descriptionChanged(IFile iFile, byte[] byArray) {
        BufferedInputStream bufferedInputStream = null;
        try {
            block16: {
                block15: {
                    int n = byArray.length > 4096 ? 8192 : byArray.length * 2;
                    bufferedInputStream = new BufferedInputStream(iFile.getContents(true), n);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    int n2 = ((InputStream)byteArrayInputStream).read();
                    int n3 = ((InputStream)bufferedInputStream).read();
                    while (n2 >= 0 && n3 >= 0) {
                        if (n2 == n3) {
                            n2 = ((InputStream)byteArrayInputStream).read();
                            n3 = ((InputStream)bufferedInputStream).read();
                            continue;
                        }
                        if (!(n2 != 13 && n2 != 10 || n3 != 13 && n3 != 10)) {
                            while (n2 == 13 || n2 == 10) {
                                n2 = ((InputStream)byteArrayInputStream).read();
                            }
                            while (n3 == 13 || n3 == 10) {
                                n3 = ((InputStream)bufferedInputStream).read();
                            }
                            continue;
                        }
                        break block15;
                    }
                    if (n2 < 0 && n3 < 0) break block16;
                }
                FileUtil.safeClose(bufferedInputStream);
                return true;
            }
            FileUtil.safeClose(bufferedInputStream);
            return false;
        }
        catch (Exception exception) {
            Policy.log(exception);
            return true;
        }
        finally {
            FileUtil.safeClose(bufferedInputStream);
        }
    }

    public int doGetEncoding(IFileStore iFileStore) throws CoreException {
        InputStream inputStream;
        block12: {
            int n;
            int n2;
            int n3;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            inputStream = null;
                            inputStream = iFileStore.openInputStream(0, null);
                            n3 = inputStream.read();
                            n2 = inputStream.read();
                            if (n3 != -1 && n2 != -1) break block8;
                            FileUtil.safeClose(inputStream);
                            return 0;
                        }
                        if ((n3 &= 0xFF) != 254 || (n2 &= 0xFF) != 255) break block9;
                        FileUtil.safeClose(inputStream);
                        return 4;
                    }
                    if (n3 != 255 || n2 != 254) break block10;
                    FileUtil.safeClose(inputStream);
                    return 5;
                }
                n = inputStream.read() & 0xFF;
                if (n != -1) break block11;
                FileUtil.safeClose(inputStream);
                return 0;
            }
            try {
                if (n3 != 239 || n2 != 187 || n != 191) break block12;
            }
            catch (IOException iOException) {
                try {
                    String string = NLS.bind((String)Messages.localstore_couldNotRead, (Object)iFileStore.toString());
                    throw new ResourceException(271, null, string, iOException);
                }
                catch (Throwable throwable) {
                    FileUtil.safeClose(inputStream);
                    throw throwable;
                }
            }
            FileUtil.safeClose(inputStream);
            return 3;
        }
        FileUtil.safeClose(inputStream);
        return 0;
    }

    public boolean fastIsSynchronized(File file) {
        IFileInfo iFileInfo;
        ResourceInfo resourceInfo = file.getResourceInfo(false, false);
        return file.exists(file.getFlags(resourceInfo), true) && !(iFileInfo = this.getStore(file).fetchInfo()).isDirectory() && resourceInfo.getLocalSyncInfo() == iFileInfo.getLastModified();
    }

    public IFile fileForLocation(IPath iPath) {
        IPath iPath2 = this.pathForLocation(iPath);
        return iPath2 == null ? null : (IFile)this.resourceFor(iPath2, true);
    }

    public int getEncoding(File file) throws CoreException {
        IFileStore iFileStore = this.getStore(file);
        if (!iFileStore.fetchInfo().exists()) {
            String string = NLS.bind((String)Messages.localstore_fileNotFound, (Object)iFileStore.toString());
            throw new ResourceException(271, file.getFullPath(), string, null);
        }
        return this.doGetEncoding(iFileStore);
    }

    public IHistoryStore getHistoryStore() {
        if (this._historyStore == null) {
            IPath iPath = this.getWorkspace().getMetaArea().getHistoryStoreLocation();
            iPath.toFile().mkdirs();
            this._historyStore = ResourcesCompatibilityHelper.createHistoryStore(iPath, 256);
        }
        return this._historyStore;
    }

    public String getLocalName(IFileStore iFileStore) {
        return iFileStore.fetchInfo().getName();
    }

    protected IPath getProjectDefaultLocation(IProject iProject) {
        return this.workspace.getRoot().getLocation().append(iProject.getFullPath());
    }

    public IFileStore getStore(IResource iResource) {
        try {
            return this.getStoreRoot(iResource).createStore(iResource.getFullPath());
        }
        catch (CoreException coreException) {
            return EFS.getNullFileSystem().getStore(iResource.getFullPath());
        }
    }

    private FileStoreRoot getStoreRoot(IResource iResource) {
        Object object;
        Object object2;
        FileStoreRoot fileStoreRoot;
        ResourceInfo resourceInfo = this.workspace.getResourceInfo(iResource.getFullPath(), true, false);
        if (resourceInfo != null) {
            fileStoreRoot = resourceInfo.getFileStoreRoot();
            if (fileStoreRoot != null && fileStoreRoot.isValid()) {
                return fileStoreRoot;
            }
            if (resourceInfo.isSet(524288)) {
                ProjectDescription projectDescription = ((Project)iResource.getProject()).internalGetDescription();
                if (projectDescription != null) {
                    this.setLocation(iResource, resourceInfo, projectDescription.getGroupLocationURI(iResource.getProjectRelativePath()));
                    return resourceInfo.getFileStoreRoot();
                }
                return resourceInfo.getFileStoreRoot();
            }
            if (resourceInfo.isSet(65536) && (object2 = ((Project)iResource.getProject()).internalGetDescription()) != null && (object = ((ProjectDescription)object2).getLinkLocationURI(iResource.getProjectRelativePath())) != null) {
                this.setLocation(iResource, resourceInfo, (URI)object);
                return resourceInfo.getFileStoreRoot();
            }
        }
        if ((object2 = iResource.getParent()) == null) {
            resourceInfo = this.workspace.getResourceInfo((IPath)Path.ROOT, false, true);
            object = this.workspace.getRoot();
            this.setLocation((IResource)object, resourceInfo, URIUtil.toURI((IPath)object.getLocation()));
            return resourceInfo.getFileStoreRoot();
        }
        fileStoreRoot = this.getStoreRoot((IResource)object2);
        if (resourceInfo != null) {
            resourceInfo.setFileStoreRoot(fileStoreRoot);
        }
        return fileStoreRoot;
    }

    protected Workspace getWorkspace() {
        return this.workspace;
    }

    public boolean hasSavedContent(IProject iProject) {
        return this.getStore(iProject).fetchInfo().exists();
    }

    public boolean hasSavedDescription(IProject iProject) {
        return this.getStore(iProject).getChild(".project").fetchInfo().exists();
    }

    private IFileStore initializeStore(IResource iResource, URI uRI) throws CoreException {
        ResourceInfo resourceInfo = ((Resource)iResource).getResourceInfo(false, true);
        this.setLocation(iResource, resourceInfo, uRI);
        FileStoreRoot fileStoreRoot = this.getStoreRoot(iResource);
        return fileStoreRoot.createStore(iResource.getFullPath());
    }

    public boolean internalWrite(IProject iProject, IProjectDescription iProjectDescription, int n, boolean bl, boolean bl2) throws CoreException {
        if (bl2) {
            this.getWorkspace().getMetaArea().writePrivateDescription(iProject);
        }
        if (!bl) {
            return false;
        }
        if (iProjectDescription == null) {
            return false;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            new ModelObjectWriter().write((Object)iProjectDescription, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)Messages.resources_writeMeta, (Object)iProject.getFullPath());
            throw new ResourceException(568, iProject.getFullPath(), string, iOException);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        IFile iFile = iProject.getFile(".project");
        if (!iFile.exists()) {
            this.workspace.createResource((IResource)iFile, false);
        } else if (!this.descriptionChanged(iFile, byArray)) {
            return false;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        IFileStore iFileStore = ((Resource)((Object)iFile)).getStore();
        IFileInfo iFileInfo = iFileStore.fetchInfo();
        if (iFileInfo.getAttribute(2)) {
            IStatus iStatus = this.getWorkspace().validateEdit(new IFile[]{iFile}, null);
            if (!iStatus.isOK()) {
                throw new ResourceException(iStatus);
            }
            iFileInfo = iFileStore.fetchInfo();
        }
        this.write(iFile, byteArrayInputStream, iFileInfo, 1, false, Policy.monitorFor(null));
        this.workspace.getAliasManager().updateAliases(iFile, this.getStore(iFile), 0, Policy.monitorFor(null));
        long l = ((Resource)((Object)iFile)).getResourceInfo(false, false).getLocalSyncInfo();
        ResourceInfo resourceInfo = ((Resource)((Object)iProject)).getResourceInfo(false, true);
        this.updateLocalSync(resourceInfo, l);
        this.getWorkspace().getMetaArea().clearOldDescription(iProject);
        return true;
    }

    public boolean isDescriptionSynchronized(IProject iProject) {
        IFile iFile = iProject.getFile(".project");
        ResourceInfo resourceInfo = ((Resource)((Object)iProject)).getResourceInfo(false, false);
        if (resourceInfo == null) {
            return false;
        }
        return resourceInfo.getLocalSyncInfo() == this.getStore(iFile).fetchInfo().getLastModified();
    }

    public boolean isSynchronized(IResource iResource, int n) {
        switch (iResource.getType()) {
            case 8: {
                if (n == 0) {
                    return true;
                }
                n = n == 1 ? 0 : n;
                IProject[] iProjectArray = ((IWorkspaceRoot)iResource).getProjects(8);
                int n2 = 0;
                while (n2 < iProjectArray.length) {
                    if (!this.isSynchronized(iProjectArray[n2], n)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            case 4: {
                if (iResource.isAccessible()) break;
                return true;
            }
            case 1: {
                if (!this.fastIsSynchronized((File)iResource)) break;
                return true;
            }
        }
        IsSynchronizedVisitor isSynchronizedVisitor = new IsSynchronizedVisitor(Policy.monitorFor(null));
        UnifiedTree unifiedTree = new UnifiedTree(iResource);
        try {
            unifiedTree.accept(isSynchronizedVisitor, n);
        }
        catch (CoreException coreException) {
            Policy.log(coreException);
            return false;
        }
        catch (IsSynchronizedVisitor.ResourceChangedException resourceChangedException) {
            return false;
        }
        return true;
    }

    public void link(Resource resource, URI uRI, IFileInfo iFileInfo) throws CoreException {
        long l;
        this.initializeStore(resource, uRI);
        ResourceInfo resourceInfo = resource.getResourceInfo(false, true);
        long l2 = l = iFileInfo == null ? 0L : iFileInfo.getLastModified();
        if (l == 0L) {
            resourceInfo.clearModificationStamp();
        }
        this.updateLocalSync(resourceInfo, l);
    }

    public IPath locationFor(IResource iResource) {
        return this.getStoreRoot(iResource).localLocation(iResource.getFullPath());
    }

    public URI locationURIFor(IResource iResource) {
        return this.getStoreRoot(iResource).computeURI(iResource.getFullPath());
    }

    public void move(IResource iResource, IFileStore iFileStore, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.getStore(iResource).move(iFileStore, 0, iProgressMonitor);
    }

    protected IPath pathForLocation(IPath iPath) {
        if (this.workspace.getRoot().getLocation().equals((Object)iPath)) {
            return Path.ROOT;
        }
        IProject[] iProjectArray = this.getWorkspace().getRoot().getProjects(8);
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            IPath iPath2 = iProject.getLocation();
            if (iPath2 != null && iPath2.isPrefixOf(iPath)) {
                int n2 = iPath2.segmentCount();
                return iProject.getFullPath().append(iPath.removeFirstSegments(n2));
            }
            ++n;
        }
        return null;
    }

    public InputStream read(IFile iFile, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        IFileStore iFileStore = this.getStore(iFile);
        if (!bl) {
            IFileInfo iFileInfo = iFileStore.fetchInfo();
            if (!iFileInfo.exists()) {
                String string = NLS.bind((String)Messages.localstore_fileNotFound, (Object)iFileStore.toString());
                throw new ResourceException(271, iFile.getFullPath(), string, null);
            }
            ResourceInfo resourceInfo = ((Resource)((Object)iFile)).getResourceInfo(true, false);
            int n = ((Resource)((Object)iFile)).getFlags(resourceInfo);
            ((Resource)((Object)iFile)).checkExists(n, true);
            if (iFileInfo.getLastModified() != resourceInfo.getLocalSyncInfo()) {
                String string = NLS.bind((String)Messages.localstore_resourceIsOutOfSync, (Object)iFile.getFullPath());
                throw new ResourceException(274, iFile.getFullPath(), string, null);
            }
        }
        return iFileStore.openInputStream(0, iProgressMonitor);
    }

    public ProjectDescription read(IProject iProject, boolean bl) throws CoreException {
        ResourceException resourceException;
        ProjectDescription projectDescription;
        IFileStore iFileStore;
        boolean bl2;
        ProjectDescription projectDescription2;
        URI uRI;
        block18: {
            uRI = null;
            projectDescription2 = null;
            if (bl) {
                projectDescription2 = new ProjectDescription();
                this.getWorkspace().getMetaArea().readPrivateDescription(iProject, projectDescription2);
                uRI = projectDescription2.getLocationURI();
            } else {
                ProjectDescription projectDescription3 = ((Project)iProject).internalGetDescription();
                if (projectDescription3 != null && projectDescription3.getLocationURI() != null) {
                    uRI = projectDescription3.getLocationURI();
                }
            }
            boolean bl3 = bl2 = uRI == null;
            if (bl2) {
                uRI = URIUtil.toURI((IPath)this.getProjectDefaultLocation(iProject));
            }
            IFileStore iFileStore2 = this.initializeStore(iProject, uRI);
            iFileStore = iFileStore2.getChild(".project");
            projectDescription = null;
            resourceException = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(iFileStore.openInputStream(0, null));
                projectDescription = new ProjectDescriptionReader(iProject).read(new InputSource(bufferedInputStream));
            }
            catch (CoreException coreException) {
                projectDescription = this.getWorkspace().getMetaArea().readOldDescription(iProject);
                if (projectDescription != null) {
                    ProjectDescription projectDescription4 = projectDescription;
                    FileUtil.safeClose(bufferedInputStream);
                    return projectDescription4;
                }
                try {
                    if (!iFileStore.fetchInfo().exists()) {
                        String string = NLS.bind((String)Messages.resources_missingProjectMeta, (Object)iProject.getName());
                        throw new ResourceException(567, iProject.getFullPath(), string, null);
                    }
                    String string = NLS.bind((String)Messages.resources_readProjectMeta, (Object)iProject.getName());
                    resourceException = new ResourceException(567, iProject.getFullPath(), string, coreException);
                }
                catch (Throwable throwable) {
                    FileUtil.safeClose(bufferedInputStream);
                    throw throwable;
                }
                FileUtil.safeClose(bufferedInputStream);
                break block18;
            }
            FileUtil.safeClose(bufferedInputStream);
        }
        if (resourceException == null && projectDescription == null) {
            String string = NLS.bind((String)Messages.resources_readProjectMeta, (Object)iProject.getName());
            resourceException = new ResourceException(567, iProject.getFullPath(), string, null);
        }
        if (projectDescription != null) {
            projectDescription.setName(iProject.getName());
            if (!bl2) {
                projectDescription.setLocationURI(uRI);
            }
            if (bl && projectDescription2 != null) {
                projectDescription.setDynamicReferences(projectDescription2.getDynamicReferences(false));
            }
        }
        long l = iFileStore.fetchInfo().getLastModified();
        IFile iFile = iProject.getFile(".project");
        ResourceInfo resourceInfo = ((Resource)((Object)iFile)).getResourceInfo(false, false);
        if (resourceInfo == null) {
            resourceInfo = this.getWorkspace().createResource((IResource)iFile, false);
            this.updateLocalSync(resourceInfo, l);
        }
        if (!bl) {
            this.updateLocalSync(resourceInfo, l);
        }
        resourceInfo = ((Resource)((Object)iProject)).getResourceInfo(false, true);
        this.updateLocalSync(resourceInfo, l);
        if (resourceException != null) {
            throw resourceException;
        }
        return projectDescription;
    }

    public boolean refresh(IResource iResource, int n, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        switch (iResource.getType()) {
            case 8: {
                return this.refreshRoot((IWorkspaceRoot)iResource, n, bl, iProgressMonitor);
            }
            case 4: {
                if (!iResource.isAccessible()) {
                    return false;
                }
            }
            case 1: 
            case 2: {
                return this.refreshResource(iResource, n, bl, iProgressMonitor);
            }
        }
        return false;
    }

    protected boolean refreshResource(IResource iResource, int n, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        int n2 = 250;
        String string = NLS.bind((String)Messages.localstore_refreshing, (Object)iResource.getFullPath());
        try {
            iProgressMonitor.beginTask(string, n2);
            RefreshLocalVisitor refreshLocalVisitor = bl ? new RefreshLocalAliasVisitor(iProgressMonitor) : new RefreshLocalVisitor(iProgressMonitor);
            IFileStore iFileStore = ((Resource)iResource).getStore();
            IFileTree iFileTree = iFileStore.getFileSystem().fetchFileTree(iFileStore, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0));
            UnifiedTree unifiedTree = iFileTree == null ? new UnifiedTree(iResource) : new UnifiedTree(iResource, iFileTree);
            unifiedTree.accept(refreshLocalVisitor, n);
            IStatus iStatus = refreshLocalVisitor.getErrorStatus();
            if (!iStatus.isOK()) {
                throw new ResourceException(iStatus);
            }
            boolean bl2 = refreshLocalVisitor.resourcesChanged();
            return bl2;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected boolean refreshRoot(IWorkspaceRoot iWorkspaceRoot, int n, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        IProject[] iProjectArray = iWorkspaceRoot.getProjects(8);
        int n2 = iProjectArray.length;
        String string = Messages.localstore_refreshingRoot;
        try {
            iProgressMonitor.beginTask(string, n2);
            if (n == 0) {
                return false;
            }
            boolean bl2 = false;
            n = n == 1 ? 0 : n;
            int n3 = 0;
            while (n3 < iProjectArray.length) {
                bl2 |= this.refresh(iProjectArray[n3], n, bl, Policy.subMonitorFor(iProgressMonitor, 1));
                ++n3;
            }
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected IResource resourceFor(IPath iPath, boolean bl) {
        int n = iPath.segmentCount();
        if (bl && n < 2) {
            return null;
        }
        IWorkspaceRoot iWorkspaceRoot = this.getWorkspace().getRoot();
        if (iPath.isRoot()) {
            return iWorkspaceRoot;
        }
        if (n == 1) {
            return iWorkspaceRoot.getProject(iPath.segment(0));
        }
        return bl ? iWorkspaceRoot.getFile(iPath) : iWorkspaceRoot.getFolder(iPath);
    }

    public long setLocalTimeStamp(IResource iResource, ResourceInfo resourceInfo, long l) throws CoreException {
        IFileStore iFileStore = this.getStore(iResource);
        IFileInfo iFileInfo = iFileStore.fetchInfo();
        iFileInfo.setLastModified(l);
        iFileStore.putInfo(iFileInfo, 2048, null);
        iFileInfo = iFileStore.fetchInfo();
        long l2 = iFileInfo.getLastModified();
        this.updateLocalSync(resourceInfo, l2);
        return l2;
    }

    public void setLocation(IResource iResource, ResourceInfo resourceInfo, URI uRI) {
        FileStoreRoot fileStoreRoot = resourceInfo.getFileStoreRoot();
        if (uRI != null) {
            resourceInfo.setFileStoreRoot(new FileStoreRoot(uRI, iResource.getFullPath()));
        } else {
            resourceInfo.setFileStoreRoot(null);
        }
        if (fileStoreRoot != null) {
            fileStoreRoot.setValid(false);
        }
    }

    public void setResourceAttributes(IResource iResource, ResourceAttributes resourceAttributes) throws CoreException {
        IFileStore iFileStore = this.getStore(iResource);
        boolean bl = false;
        if (iResource instanceof IContainer && (iFileStore.getFileSystem().attributes() & 4) != 0) {
            bl = iFileStore.fetchInfo().getAttribute(4) ^ resourceAttributes.isExecutable();
        }
        iFileStore.putInfo(FileUtil.attributesToFileInfo(resourceAttributes), 1024, null);
        if (bl) {
            this.workspace.getRefreshManager().refresh(iResource);
        }
    }

    public void shutdown(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this._historyStore != null) {
            this._historyStore.shutdown(iProgressMonitor);
        }
    }

    public void startup(IProgressMonitor iProgressMonitor) throws CoreException {
    }

    public void updateLocalSync(ResourceInfo resourceInfo, long l) {
        resourceInfo.setLocalSyncInfo(l);
        if (l == -1L) {
            resourceInfo.clear(2);
        } else {
            resourceInfo.set(2);
        }
    }

    public void write(IFile iFile, InputStream inputStream, IFileInfo iFileInfo, int n, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(null);
        try {
            IFileStore iFileStore = this.getStore(iFile);
            if (iFileInfo.getAttribute(2)) {
                String string = NLS.bind((String)Messages.localstore_couldNotWriteReadOnly, (Object)iFile.getFullPath());
                throw new ResourceException(272, iFile.getFullPath(), string, null);
            }
            long l = iFileInfo.getLastModified();
            if (BitMask.isSet(n, 1)) {
                if (bl && !iFile.isLocal(0) && !iFileInfo.exists()) {
                    String string = NLS.bind((String)Messages.resources_mustBeLocal, (Object)iFile.getFullPath());
                    throw new ResourceException(369, iFile.getFullPath(), string, null);
                }
            } else if (iFile.isLocal(0)) {
                ResourceInfo resourceInfo = ((Resource)((Object)iFile)).getResourceInfo(true, false);
                if (l != resourceInfo.getLocalSyncInfo()) {
                    String string = NLS.bind((String)Messages.localstore_resourceIsOutOfSync, (Object)iFile.getFullPath());
                    throw new ResourceException(274, iFile.getFullPath(), string, null);
                }
            } else {
                if (iFileInfo.exists()) {
                    String string = NLS.bind((String)Messages.localstore_resourceExists, (Object)iFile.getFullPath());
                    throw new ResourceException(268, iFile.getFullPath(), string, null);
                }
                if (bl) {
                    String string = NLS.bind((String)Messages.resources_mustBeLocal, (Object)iFile.getFullPath());
                    throw new ResourceException(369, iFile.getFullPath(), string, null);
                }
            }
            if (BitMask.isSet(n, 2) && iFileInfo.exists()) {
                this.getHistoryStore().addState(iFile.getFullPath(), iFileStore, iFileInfo, false);
            }
            if (!iFileInfo.exists()) {
                iFileStore.getParent().mkdir(0, null);
            }
            int n2 = bl ? 1 : 0;
            OutputStream outputStream = iFileStore.openOutputStream(n2, Policy.subMonitorFor(iProgressMonitor, 0));
            FileUtil.transferStreams(inputStream, outputStream, iFileStore.toString(), iProgressMonitor);
            l = iFileStore.fetchInfo().getLastModified();
            ResourceInfo resourceInfo = ((Resource)((Object)iFile)).getResourceInfo(false, true);
            this.updateLocalSync(resourceInfo, l);
            resourceInfo.incrementContentId();
            resourceInfo.clear(393216);
            this.workspace.updateModificationStamp(resourceInfo);
        }
        finally {
            FileUtil.safeClose(inputStream);
        }
    }

    public void write(IFolder iFolder, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        IFileStore iFileStore = this.getStore(iFolder);
        if (!bl) {
            object = iFileStore.fetchInfo();
            if (object.isDirectory()) {
                String string = NLS.bind((String)Messages.localstore_resourceExists, (Object)iFolder.getFullPath());
                throw new ResourceException(268, iFolder.getFullPath(), string, null);
            }
            if (object.exists()) {
                String string = NLS.bind((String)Messages.localstore_fileExists, (Object)iFolder.getFullPath());
                throw new ResourceException(274, iFolder.getFullPath(), string, null);
            }
        }
        iFileStore.mkdir(0, iProgressMonitor);
        object = ((Resource)((Object)iFolder)).getResourceInfo(false, true);
        this.updateLocalSync((ResourceInfo)object, iFileStore.fetchInfo().getLastModified());
    }

    public void writeSilently(IProject iProject) throws CoreException {
        IPath iPath = this.locationFor(iProject);
        if (iPath == null) {
            return;
        }
        IFileStore iFileStore = this.getStore(iProject);
        iFileStore.mkdir(0, null);
        ProjectDescription projectDescription = ((Project)iProject).internalGetDescription();
        if (projectDescription == null) {
            return;
        }
        this.getWorkspace().getMetaArea().writePrivateDescription(iProject);
        IFileStore iFileStore2 = iFileStore.getChild(".project");
        OutputStream outputStream = null;
        try {
            try {
                outputStream = iFileStore2.openOutputStream(0, null);
                new ModelObjectWriter().write((Object)projectDescription, outputStream);
            }
            catch (IOException iOException) {
                String string = NLS.bind((String)Messages.resources_writeMeta, (Object)iProject.getFullPath());
                throw new ResourceException(568, iProject.getFullPath(), string, iOException);
            }
        }
        catch (Throwable throwable) {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.getWorkspace().getMetaArea().clearOldDescription(iProject);
    }
}

