/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.runtime.IPath;

public class HistoryBucket
extends Bucket {
    public static final byte VERSION = 2;

    public void addBlob(IPath iPath, UniversalUniqueIdentifier universalUniqueIdentifier, long l) {
        byte[] byArray = HistoryEntry.getState(universalUniqueIdentifier, l);
        String string = iPath.toString();
        byte[][] byArray2 = (byte[][])this.getEntryValue(string);
        if (byArray2 == null) {
            this.setEntryValue(string, new byte[][]{byArray});
            return;
        }
        byte[][] byArray3 = HistoryEntry.insert(byArray2, byArray);
        if (byArray3 == null) {
            return;
        }
        this.setEntryValue(string, byArray3);
    }

    public void addBlobs(HistoryEntry historyEntry) {
        IPath iPath = historyEntry.getPath();
        byte[][] byArray = historyEntry.getData();
        String string = iPath.toString();
        byte[][] byArray2 = (byte[][])this.getEntryValue(string);
        if (byArray2 == null) {
            this.setEntryValue(string, byArray);
            return;
        }
        this.setEntryValue(string, HistoryEntry.merge(byArray2, byArray));
    }

    protected Bucket.Entry createEntry(IPath iPath, Object object) {
        return new HistoryEntry(iPath, (byte[][])object);
    }

    public HistoryEntry getEntry(IPath iPath) {
        String string = iPath.toString();
        byte[][] byArray = (byte[][])this.getEntryValue(string);
        if (byArray == null) {
            return null;
        }
        return new HistoryEntry(iPath, byArray);
    }

    protected String getIndexFileName() {
        return "history.index";
    }

    protected byte getVersion() {
        return 2;
    }

    protected String getVersionFileName() {
        return "history.version";
    }

    protected Object readEntryValue(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        byte[][] byArray = new byte[n][24];
        int n2 = 0;
        while (n2 < byArray.length) {
            dataInputStream.read(byArray[n2]);
            ++n2;
        }
        return byArray;
    }

    protected void writeEntryValue(DataOutputStream dataOutputStream, Object object) throws IOException {
        byte[][] byArray = (byte[][])object;
        dataOutputStream.writeShort(byArray.length);
        int n = 0;
        while (n < byArray.length) {
            dataOutputStream.write(byArray[n]);
            ++n;
        }
    }

    public static final class HistoryEntry
    extends Bucket.Entry {
        static final Comparator COMPARATOR = new Comparator(){

            public int compare(Object object, Object object2) {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = (byte[])object2;
                return HistoryEntry.access$0(byArray, byArray2);
            }
        };
        private static final byte[][] EMPTY_DATA = new byte[0][];
        private static final int LONG_LENGTH = 8;
        private static final int UUID_LENGTH = 16;
        public static final int DATA_LENGTH = 24;
        private byte[][] data;

        private static int compareStates(byte[] byArray, byte[] byArray2) {
            long l;
            long l2 = HistoryEntry.getTimestamp(byArray);
            if (l2 == (l = HistoryEntry.getTimestamp(byArray2))) {
                return -UniversalUniqueIdentifier.compareTime(byArray, byArray2);
            }
            return l2 < l ? 1 : -1;
        }

        private static byte[] getState(UniversalUniqueIdentifier universalUniqueIdentifier, long l) {
            byte[] byArray = universalUniqueIdentifier.toBytes();
            byte[] byArray2 = new byte[24];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            int n = 0;
            while (n < 8) {
                byArray2[16 + n] = (byte)(0xFFL & l);
                l >>>= 8;
                ++n;
            }
            return byArray2;
        }

        private static long getTimestamp(byte[] byArray) {
            long l = 0L;
            int n = 0;
            while (n < 8) {
                l += ((long)byArray[16 + n] & 0xFFL) << n * 8;
                ++n;
            }
            return l;
        }

        private static byte[][] insert(byte[][] byArray, byte[] byArray2) {
            int n = HistoryEntry.search(byArray, byArray2);
            if (n >= 0) {
                return null;
            }
            int n2 = -n - 1;
            byte[][] byArrayArray = new byte[byArray.length + 1][];
            if (n2 > 0) {
                System.arraycopy(byArray, 0, byArrayArray, 0, n2);
            }
            byArrayArray[n2] = byArray2;
            if (n2 < byArray.length) {
                System.arraycopy(byArray, n2, byArrayArray, n2 + 1, byArray.length - n2);
            }
            return byArrayArray;
        }

        private static byte[][] merge(byte[][] byArray, byte[][] byArray2) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            byte[][] byArrayArray = new byte[byArray.length + byArray2.length][];
            while (n2 < byArray.length && n < byArray2.length) {
                int n4 = HistoryEntry.compareStates(byArray[n2], byArray2[n]);
                if (n4 == 0) {
                    byArrayArray[n3++] = byArray[n2++];
                    ++n;
                    continue;
                }
                byArrayArray[n3++] = n4 < 0 ? byArray[n2++] : byArray2[n++];
            }
            byte[][] byArray3 = n2 == byArray.length ? byArray2 : byArray;
            int n5 = n2 == byArray.length ? n : n2;
            int n6 = byArray3.length - n5;
            System.arraycopy(byArray3, n5, byArrayArray, n3, n6);
            if ((n3 += n6) == byArray.length + byArray2.length) {
                return byArrayArray;
            }
            byte[][] byArrayArray2 = new byte[n3][];
            System.arraycopy(byArrayArray, 0, byArrayArray2, 0, byArrayArray2.length);
            return byArrayArray2;
        }

        private static int search(byte[][] byArray, byte[] byArray2) {
            return Arrays.binarySearch(byArray, byArray2, COMPARATOR);
        }

        public HistoryEntry(IPath iPath, byte[][] byArray) {
            super(iPath);
            this.data = byArray;
        }

        public HistoryEntry(IPath iPath, HistoryEntry historyEntry) {
            super(iPath);
            this.data = new byte[historyEntry.data.length][];
            System.arraycopy(historyEntry.data, 0, this.data, 0, this.data.length);
        }

        private void compact() {
            if (!this.isDirty()) {
                return;
            }
            int n = 0;
            int n2 = 0;
            while (n2 < this.data.length) {
                if (this.data[n2] != null) {
                    this.data[n++] = this.data[n2];
                }
                ++n2;
            }
            if (n == this.data.length) {
                return;
            }
            if (n == 0) {
                this.data = EMPTY_DATA;
                this.delete();
                return;
            }
            byte[][] byArrayArray = new byte[n][];
            System.arraycopy(this.data, 0, byArrayArray, 0, n);
            this.data = byArrayArray;
        }

        public void deleteOccurrence(int n) {
            this.markDirty();
            this.data[n] = null;
        }

        byte[][] getData() {
            return this.data;
        }

        public int getOccurrences() {
            return this.data.length;
        }

        public long getTimestamp(int n) {
            return HistoryEntry.getTimestamp(this.data[n]);
        }

        public UniversalUniqueIdentifier getUUID(int n) {
            return new UniversalUniqueIdentifier(this.data[n]);
        }

        public Object getValue() {
            return this.data;
        }

        public boolean isEmpty() {
            return this.data.length == 0;
        }

        public void visited() {
            this.compact();
        }

        static /* synthetic */ int access$0(byte[] byArray, byte[] byArray2) {
            return HistoryEntry.compareStates(byArray, byArray2);
        }
    }
}

