/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.localstore.BlobStore;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.localstore.BucketTree;
import org.eclipse.core.internal.localstore.HistoryBucket;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.resources.FileState;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class HistoryStore2
implements IHistoryStore {
    private BlobStore blobStore;
    private Set blobsToRemove = new HashSet();
    final BucketTree tree;
    private Workspace workspace;

    public HistoryStore2(Workspace workspace, IFileStore iFileStore, int n) {
        this.workspace = workspace;
        try {
            iFileStore.mkdir(0, null);
        }
        catch (CoreException coreException) {}
        this.blobStore = new BlobStore(iFileStore, n);
        this.tree = new BucketTree(workspace, new HistoryBucket());
    }

    public synchronized IFileState addState(IPath iPath, IFileStore iFileStore, IFileInfo iFileInfo, boolean bl) {
        long l = iFileInfo.getLastModified();
        if (Policy.DEBUG_HISTORY) {
            System.out.println("History: Adding state for key: " + iPath + ", file: " + iFileStore + ", timestamp: " + l + ", size: " + iFileStore.fetchInfo().getLength());
        }
        if (!this.isValid(iFileStore, iFileInfo)) {
            return null;
        }
        UniversalUniqueIdentifier universalUniqueIdentifier = null;
        try {
            universalUniqueIdentifier = this.blobStore.addBlob(iFileStore, bl);
            this.tree.loadBucketFor(iPath);
            HistoryBucket historyBucket = (HistoryBucket)this.tree.getCurrent();
            historyBucket.addBlob(iPath, universalUniqueIdentifier, l);
        }
        catch (CoreException coreException) {
            this.log(coreException);
        }
        return new FileState(this, iPath, l, universalUniqueIdentifier);
    }

    public synchronized Set allFiles(IPath iPath, int n, IProgressMonitor iProgressMonitor) {
        final HashSet hashSet = new HashSet();
        try {
            this.tree.accept(new Bucket.Visitor(){

                public int visit(Bucket.Entry entry) {
                    hashSet.add(entry.getPath());
                    return 0;
                }
            }, iPath, n == 2 ? Integer.MAX_VALUE : n);
        }
        catch (CoreException coreException) {
            this.log(coreException);
        }
        return hashSet;
    }

    protected void applyPolicy(HistoryBucket.HistoryEntry historyEntry, int n, long l) {
        int n2 = 0;
        while (n2 < historyEntry.getOccurrences()) {
            if (n2 >= n || historyEntry.getTimestamp(n2) < l) {
                this.blobsToRemove.add(historyEntry.getUUID(n2));
                historyEntry.deleteOccurrence(n2);
            }
            ++n2;
        }
    }

    private void applyPolicy(IPath iPath) throws CoreException {
        WorkspaceDescription workspaceDescription = this.workspace.internalGetDescription();
        final long l = System.currentTimeMillis() - workspaceDescription.getFileStateLongevity();
        final int n = workspaceDescription.getMaxFileStates();
        this.tree.accept(new Bucket.Visitor(){

            public int visit(Bucket.Entry entry) {
                HistoryStore2.this.applyPolicy((HistoryBucket.HistoryEntry)entry, n, l);
                return 0;
            }
        }, iPath, Integer.MAX_VALUE);
        this.tree.getCurrent().save();
    }

    public synchronized void clean(IProgressMonitor iProgressMonitor) {
        long l = System.currentTimeMillis();
        try {
            WorkspaceDescription workspaceDescription = this.workspace.internalGetDescription();
            final long l2 = System.currentTimeMillis() - workspaceDescription.getFileStateLongevity();
            final int n = workspaceDescription.getMaxFileStates();
            final int[] nArray = new int[1];
            this.tree.accept(new Bucket.Visitor(){

                public int visit(Bucket.Entry entry) {
                    nArray[0] = nArray[0] + entry.getOccurrences();
                    HistoryStore2.this.applyPolicy((HistoryBucket.HistoryEntry)entry, n, l2);
                    return 0;
                }
            }, (IPath)Path.ROOT, Integer.MAX_VALUE);
            if (Policy.DEBUG_HISTORY) {
                Policy.debug("Time to apply history store policies: " + (System.currentTimeMillis() - l) + "ms.");
                Policy.debug("Total number of history store entries: " + nArray[0]);
            }
            l = System.currentTimeMillis();
            this.blobStore.deleteBlobs(this.blobsToRemove);
            if (Policy.DEBUG_HISTORY) {
                Policy.debug("Time to remove " + this.blobsToRemove.size() + " unreferenced blobs: " + (System.currentTimeMillis() - l) + "ms.");
            }
            this.blobsToRemove = new HashSet();
        }
        catch (Exception exception) {
            String string = Messages.history_problemsCleaning;
            ResourceStatus resourceStatus = new ResourceStatus(273, null, string, exception);
            Policy.log(resourceStatus);
        }
    }

    public void closeHistoryStore(IResource iResource) {
        try {
            this.tree.getCurrent().save();
            this.tree.getCurrent().flush();
        }
        catch (CoreException coreException) {
            this.log(coreException);
        }
    }

    public synchronized void copyHistory(IResource iResource, IResource iResource2, boolean bl) {
        if (iResource == null || iResource2 == null) {
            String string = Messages.history_copyToNull;
            ResourceStatus resourceStatus = new ResourceStatus(566, null, string, null);
            Policy.log(resourceStatus);
            return;
        }
        if (iResource.equals(iResource2)) {
            String string = Messages.history_copyToSelf;
            ResourceStatus resourceStatus = new ResourceStatus(566, iResource.getFullPath(), string, null);
            Policy.log(resourceStatus);
            return;
        }
        IPath iPath = iResource.getFullPath();
        IPath iPath2 = iResource2.getFullPath();
        Assert.isLegal((iPath.segmentCount() > 0 ? 1 : 0) != 0);
        Assert.isLegal((iPath2.segmentCount() > 0 ? 1 : 0) != 0);
        Assert.isLegal((iPath.segmentCount() > 1 || iPath2.segmentCount() == 1 ? 1 : 0) != 0);
        try {
            if (bl && iResource.getType() == 4) {
                Bucket bucket = this.tree.getCurrent();
                bucket.save();
                bucket.flush();
                return;
            }
            HistoryCopyVisitor historyCopyVisitor = new HistoryCopyVisitor(iPath, iPath2);
            this.tree.accept(historyCopyVisitor, iPath, Integer.MAX_VALUE);
            this.applyPolicy(iResource2.getFullPath());
        }
        catch (CoreException coreException) {
            this.log(coreException);
        }
    }

    public boolean exists(IFileState iFileState) {
        return this.blobStore.fileFor(((FileState)iFileState).getUUID()).fetchInfo().exists();
    }

    public InputStream getContents(IFileState iFileState) throws CoreException {
        if (!iFileState.exists()) {
            String string = Messages.history_notValid;
            throw new ResourceException(271, iFileState.getFullPath(), string, null);
        }
        return this.blobStore.getBlob(((FileState)iFileState).getUUID());
    }

    public synchronized IFileState[] getStates(IPath iPath, IProgressMonitor iProgressMonitor) {
        try {
            this.tree.loadBucketFor(iPath);
            HistoryBucket historyBucket = (HistoryBucket)this.tree.getCurrent();
            HistoryBucket.HistoryEntry historyEntry = historyBucket.getEntry(iPath);
            if (historyEntry == null || historyEntry.isEmpty()) {
                return new IFileState[0];
            }
            IFileState[] iFileStateArray = new IFileState[historyEntry.getOccurrences()];
            int n = 0;
            while (n < iFileStateArray.length) {
                iFileStateArray[n] = new FileState(this, historyEntry.getPath(), historyEntry.getTimestamp(n), historyEntry.getUUID(n));
                ++n;
            }
            return iFileStateArray;
        }
        catch (CoreException coreException) {
            this.log(coreException);
            return new IFileState[0];
        }
    }

    public BucketTree getTree() {
        return this.tree;
    }

    private boolean isValid(IFileStore iFileStore, IFileInfo iFileInfo) {
        boolean bl;
        WorkspaceDescription workspaceDescription = this.workspace.internalGetDescription();
        long l = iFileInfo.getLength();
        boolean bl2 = bl = l <= workspaceDescription.getMaxFileStateSize();
        if (Policy.DEBUG_HISTORY && !bl) {
            System.out.println("History: Ignoring file (too large). File: " + iFileStore.toString() + ", size: " + l + ", max: " + workspaceDescription.getMaxFileStateSize());
        }
        return bl;
    }

    private void log(CoreException coreException) {
        IStatus iStatus = coreException.getStatus();
        if (iStatus.getException() == null) {
            iStatus = new Status(4, "org.eclipse.core.resources", 568, "Internal error in history store", (Throwable)coreException);
        }
        Policy.log(iStatus);
    }

    public synchronized void remove(IPath iPath, IProgressMonitor iProgressMonitor) {
        try {
            final Set set = this.blobsToRemove;
            this.tree.accept(new Bucket.Visitor(){

                public int visit(Bucket.Entry entry) {
                    int n = 0;
                    while (n < entry.getOccurrences()) {
                        set.add(((HistoryBucket.HistoryEntry)entry).getUUID(n));
                        ++n;
                    }
                    entry.delete();
                    return 0;
                }
            }, iPath, Integer.MAX_VALUE);
        }
        catch (CoreException coreException) {
            this.log(coreException);
        }
    }

    public synchronized void removeGarbage() {
        try {
            final Set set = this.blobsToRemove;
            this.tree.accept(new Bucket.Visitor(){

                public int visit(Bucket.Entry entry) {
                    int n = 0;
                    while (n < entry.getOccurrences()) {
                        set.remove(((HistoryBucket.HistoryEntry)entry).getUUID(n));
                        ++n;
                    }
                    return 0;
                }
            }, (IPath)Path.ROOT, Integer.MAX_VALUE);
            this.blobStore.deleteBlobs(this.blobsToRemove);
            this.blobsToRemove = new HashSet();
        }
        catch (Exception exception) {
            String string = Messages.history_problemsCleaning;
            ResourceStatus resourceStatus = new ResourceStatus(273, null, string, exception);
            Policy.log(resourceStatus);
        }
    }

    public synchronized void shutdown(IProgressMonitor iProgressMonitor) throws CoreException {
        this.tree.close();
    }

    public void startup(IProgressMonitor iProgressMonitor) {
    }

    class HistoryCopyVisitor
    extends Bucket.Visitor {
        private List changes = new ArrayList();
        private IPath destination;
        private IPath source;

        public HistoryCopyVisitor(IPath iPath, IPath iPath2) {
            this.source = iPath;
            this.destination = iPath2;
        }

        public void afterSaving(Bucket bucket) throws CoreException {
            this.saveChanges();
            this.changes.clear();
        }

        private void saveChanges() throws CoreException {
            if (this.changes.isEmpty()) {
                return;
            }
            Iterator iterator = this.changes.iterator();
            HistoryBucket.HistoryEntry historyEntry = (HistoryBucket.HistoryEntry)iterator.next();
            HistoryStore2.this.tree.loadBucketFor(historyEntry.getPath());
            HistoryBucket historyBucket = (HistoryBucket)HistoryStore2.this.tree.getCurrent();
            historyBucket.addBlobs(historyEntry);
            while (iterator.hasNext()) {
                historyBucket.addBlobs((HistoryBucket.HistoryEntry)iterator.next());
            }
            historyBucket.save();
        }

        public int visit(Bucket.Entry entry) {
            IPath iPath = this.destination.append(entry.getPath().removeFirstSegments(this.source.segmentCount()));
            HistoryBucket.HistoryEntry historyEntry = new HistoryBucket.HistoryEntry(iPath, (HistoryBucket.HistoryEntry)entry);
            this.changes.add(historyEntry);
            return 0;
        }
    }
}

