/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.util.Arrays;

public class PrefixPool {
    private String[] pool;
    private int size;

    public PrefixPool(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.pool = new String[n];
        this.size = 0;
    }

    public void clear() {
        Arrays.fill(this.pool, 0, this.size, null);
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    private void checkCapacity() {
        if (this.size + 1 >= this.pool.length) {
            String[] stringArray = new String[2 * this.pool.length];
            System.arraycopy(this.pool, 0, stringArray, 0, this.pool.length);
            Arrays.fill(this.pool, null);
            this.pool = stringArray;
        }
    }

    public void insertLonger(String string) {
        int n = this.size - 1;
        while (n >= 0) {
            if (this.pool[n].startsWith(string)) {
                return;
            }
            if (string.startsWith(this.pool[n])) {
                this.pool[n] = string;
                return;
            }
            --n;
        }
        this.checkCapacity();
        this.pool[this.size] = string;
        ++this.size;
    }

    public boolean insertShorter(String string) {
        boolean bl = false;
        int n = this.size - 1;
        while (n >= 0) {
            if (string.startsWith(this.pool[n])) {
                return false;
            }
            if (this.pool[n].startsWith(string)) {
                if (bl) {
                    System.arraycopy(this.pool, n + 1, this.pool, n, this.size - n - 1);
                    --this.size;
                    this.pool[this.size] = null;
                } else {
                    this.pool[n] = string;
                    bl = true;
                }
            }
            --n;
        }
        if (!bl) {
            this.checkCapacity();
            this.pool[this.size] = string;
            ++this.size;
        }
        return bl;
    }

    public boolean containsAsPrefix(String string) {
        int n = this.size - 1;
        while (n >= 0) {
            if (this.pool[n].startsWith(string)) {
                return true;
            }
            --n;
        }
        return false;
    }

    public boolean hasPrefixOf(String string) {
        int n = this.size - 1;
        while (n >= 0) {
            if (string.startsWith(this.pool[n])) {
                return true;
            }
            --n;
        }
        return false;
    }
}

