/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.localstore.RefreshLocalVisitor;
import org.eclipse.core.internal.localstore.UnifiedTreeNode;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class RefreshLocalAliasVisitor
extends RefreshLocalVisitor {
    public RefreshLocalAliasVisitor(IProgressMonitor iProgressMonitor) {
        super(iProgressMonitor);
    }

    protected void createResource(UnifiedTreeNode unifiedTreeNode, Resource resource) throws CoreException {
        super.createResource(unifiedTreeNode, resource);
        IFileStore iFileStore = unifiedTreeNode.getStore();
        if (iFileStore == null) {
            return;
        }
        IResource[] iResourceArray = this.workspace.getAliasManager().computeAliases(resource, iFileStore);
        if (iResourceArray != null) {
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[n].getProject().isOpen() && !((Resource)iResourceArray[n]).isFilteredFromParent()) {
                    super.createResource(unifiedTreeNode, (Resource)iResourceArray[n]);
                }
                ++n;
            }
        }
    }

    protected void deleteResource(UnifiedTreeNode unifiedTreeNode, Resource resource) throws CoreException {
        super.deleteResource(unifiedTreeNode, resource);
        IFileStore iFileStore = unifiedTreeNode.getStore();
        if (iFileStore == null) {
            return;
        }
        IResource[] iResourceArray = this.workspace.getAliasManager().computeAliases(resource, iFileStore);
        if (iResourceArray != null) {
            boolean bl = false;
            if (iFileStore.fetchInfo() != null && iFileStore.fetchInfo().exists()) {
                bl = resource.isFilteredFromParent();
            }
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[n].getProject().isOpen()) {
                    if (bl) {
                        if (((Resource)iResourceArray[n]).isFilteredFromParent()) {
                            super.deleteResource(unifiedTreeNode, (Resource)iResourceArray[n]);
                        }
                    } else {
                        super.deleteResource(unifiedTreeNode, (Resource)iResourceArray[n]);
                    }
                }
                ++n;
            }
        }
    }

    protected void resourceChanged(UnifiedTreeNode unifiedTreeNode, Resource resource) {
        super.resourceChanged(unifiedTreeNode, resource);
        IFileStore iFileStore = unifiedTreeNode.getStore();
        if (iFileStore == null) {
            return;
        }
        IResource[] iResourceArray = this.workspace.getAliasManager().computeAliases(resource, iFileStore);
        if (iResourceArray != null) {
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[n].getProject().isOpen()) {
                    super.resourceChanged(unifiedTreeNode, (Resource)iResourceArray[n]);
                }
                ++n;
            }
        }
    }

    protected void fileToFolder(UnifiedTreeNode unifiedTreeNode, Resource resource) throws CoreException {
        super.fileToFolder(unifiedTreeNode, resource);
        IFileStore iFileStore = unifiedTreeNode.getStore();
        if (iFileStore == null) {
            return;
        }
        IResource[] iResourceArray = this.workspace.getAliasManager().computeAliases(resource, iFileStore);
        if (iResourceArray != null) {
            int n = 0;
            while (n < iResourceArray.length) {
                super.fileToFolder(unifiedTreeNode, (Resource)iResourceArray[n]);
                ++n;
            }
        }
    }

    protected void folderToFile(UnifiedTreeNode unifiedTreeNode, Resource resource) throws CoreException {
        super.folderToFile(unifiedTreeNode, resource);
        IFileStore iFileStore = unifiedTreeNode.getStore();
        if (iFileStore == null) {
            return;
        }
        IResource[] iResourceArray = this.workspace.getAliasManager().computeAliases(resource, iFileStore);
        if (iResourceArray != null) {
            int n = 0;
            while (n < iResourceArray.length) {
                super.folderToFile(unifiedTreeNode, (Resource)iResourceArray[n]);
                ++n;
            }
        }
    }

    protected void refresh(Container container) throws CoreException {
        container.getLocalManager().refresh(container, 0, true, null);
    }
}

