/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import org.eclipse.core.internal.localstore.ILocalStoreConstants;
import org.eclipse.core.internal.localstore.IUnifiedTreeVisitor;
import org.eclipse.core.internal.localstore.UnifiedTreeNode;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class RefreshLocalVisitor
implements IUnifiedTreeVisitor,
ILocalStoreConstants {
    protected static final int RL_UNKNOWN = 0;
    protected static final int RL_IN_SYNC = 1;
    protected static final int RL_NOT_IN_SYNC = 2;
    public static final int TOTAL_WORK = 250;
    private int currentIncrement = 4;
    private int halfWay = 125;
    private int nextProgress = this.currentIncrement;
    private int worked = 0;
    protected MultiStatus errors;
    protected IProgressMonitor monitor;
    protected boolean resourceChanged;
    protected Workspace workspace;

    public RefreshLocalVisitor(IProgressMonitor iProgressMonitor) {
        this.monitor = iProgressMonitor;
        this.workspace = (Workspace)ResourcesPlugin.getWorkspace();
        this.resourceChanged = false;
        String string = Messages.resources_errorMultiRefresh;
        this.errors = new MultiStatus("org.eclipse.core.resources", 271, string, null);
    }

    protected void contentAdded(UnifiedTreeNode unifiedTreeNode, Resource resource) {
        this.resourceChanged(unifiedTreeNode, resource);
    }

    protected void createResource(UnifiedTreeNode unifiedTreeNode, Resource resource) throws CoreException {
        IContainer iContainer;
        ResourceInfo resourceInfo = resource.getResourceInfo(false, false);
        int n = resource.getFlags(resourceInfo);
        if (resource.exists(n, false)) {
            return;
        }
        if (unifiedTreeNode.getLevel() == 0 && (iContainer = resource.getParent()).getType() == 2) {
            ((Folder)resource.getParent()).ensureExists(this.monitor);
        }
        resourceInfo = this.workspace.createResource((IResource)resource, false);
        resourceInfo.set(0x100000);
        resource.getLocalManager().updateLocalSync(resourceInfo, unifiedTreeNode.getLastModified());
    }

    protected void deleteResource(UnifiedTreeNode unifiedTreeNode, Resource resource) throws CoreException {
        ResourceInfo resourceInfo = resource.getResourceInfo(false, false);
        int n = resource.getFlags(resourceInfo);
        if (ResourceInfo.isSet(n, 65536)) {
            resourceInfo = resource.getResourceInfo(false, true);
            if (resourceInfo != null) {
                resourceInfo.clearModificationStamp();
            }
            return;
        }
        if (resource.exists(n, false)) {
            resource.deleteResource(true, this.errors);
        }
        unifiedTreeNode.setExistsWorkspace(false);
    }

    protected void fileToFolder(UnifiedTreeNode unifiedTreeNode, Resource resource) throws CoreException {
        ResourceInfo resourceInfo = resource.getResourceInfo(false, false);
        int n = resource.getFlags(resourceInfo);
        if (resource.exists(n, true)) {
            resource = (Folder)((File)resource).changeToFolder();
        } else if (!resource.exists(n, false)) {
            resource = (Resource)((Object)this.workspace.getRoot().getFolder(resource.getFullPath()));
            this.workspace.createResource((IResource)resource, false);
        }
        unifiedTreeNode.setResource(resource);
        resourceInfo = resource.getResourceInfo(false, true);
        resource.getLocalManager().updateLocalSync(resourceInfo, unifiedTreeNode.getLastModified());
    }

    protected void folderToFile(UnifiedTreeNode unifiedTreeNode, Resource resource) throws CoreException {
        ResourceInfo resourceInfo = resource.getResourceInfo(false, false);
        int n = resource.getFlags(resourceInfo);
        if (resource.exists(n, true)) {
            resource = (File)((Folder)resource).changeToFile();
        } else if (!resource.exists(n, false)) {
            resource = (Resource)((Object)this.workspace.getRoot().getFile(resource.getFullPath()));
            this.workspace.createResource((IResource)resource, false);
        }
        unifiedTreeNode.setResource(resource);
        resourceInfo = resource.getResourceInfo(false, true);
        resource.getLocalManager().updateLocalSync(resourceInfo, unifiedTreeNode.getLastModified());
    }

    public IStatus getErrorStatus() {
        return this.errors;
    }

    protected void makeLocal(UnifiedTreeNode unifiedTreeNode, Resource resource) {
        ResourceInfo resourceInfo = resource.getResourceInfo(false, true);
        if (resourceInfo != null) {
            resource.getLocalManager().updateLocalSync(resourceInfo, unifiedTreeNode.getLastModified());
        }
    }

    protected void refresh(Container container) throws CoreException {
        container.getLocalManager().refresh(container, 0, false, null);
    }

    protected void resourceChanged(UnifiedTreeNode unifiedTreeNode, Resource resource) {
        ResourceInfo resourceInfo = resource.getResourceInfo(false, true);
        if (resourceInfo == null) {
            return;
        }
        resource.getLocalManager().updateLocalSync(resourceInfo, unifiedTreeNode.getLastModified());
        resourceInfo.incrementContentId();
        resourceInfo.clear(393216);
        this.workspace.updateModificationStamp(resourceInfo);
    }

    public boolean resourcesChanged() {
        return this.resourceChanged;
    }

    protected int synchronizeExistence(UnifiedTreeNode unifiedTreeNode, Resource resource) throws CoreException {
        if (unifiedTreeNode.existsInWorkspace()) {
            if (!unifiedTreeNode.existsInFileSystem()) {
                if (resource.isLocal(0)) {
                    this.deleteResource(unifiedTreeNode, resource);
                    this.resourceChanged = true;
                    return 2;
                }
                return 1;
            }
        } else {
            IResource iResource = this.workspace.getRoot().findMember(resource.getFullPath());
            if (iResource != null) {
                return 0;
            }
            if (unifiedTreeNode.existsInFileSystem()) {
                IResource iResource2;
                Container container = (Container)resource.getParent();
                if (!container.exists()) {
                    this.refresh(container);
                    if (!container.exists()) {
                        return 2;
                    }
                }
                if (!resource.getName().equals(unifiedTreeNode.getLocalName())) {
                    return 1;
                }
                if (!Workspace.caseSensitive && unifiedTreeNode.getLevel() == 0 && (iResource2 = resource.findExistingResourceVariant(resource.getFullPath())) != null) {
                    this.deleteResource(unifiedTreeNode, (Resource)iResource2);
                    this.createResource(unifiedTreeNode, resource);
                    this.resourceChanged = true;
                    return 2;
                }
                this.createResource(unifiedTreeNode, resource);
                this.resourceChanged = true;
                return 2;
            }
        }
        return 0;
    }

    protected boolean synchronizeGender(UnifiedTreeNode unifiedTreeNode, Resource resource) throws CoreException {
        IResource iResource;
        if (!unifiedTreeNode.existsInWorkspace() && (iResource = this.workspace.getRoot().findMember(resource.getFullPath())) != null) {
            resource = (Resource)iResource;
        }
        if (resource.getType() == 1) {
            if (unifiedTreeNode.isFolder()) {
                this.fileToFolder(unifiedTreeNode, resource);
                this.resourceChanged = true;
                return false;
            }
        } else if (!unifiedTreeNode.isFolder()) {
            this.folderToFile(unifiedTreeNode, resource);
            this.resourceChanged = true;
            return false;
        }
        return true;
    }

    protected void synchronizeLastModified(UnifiedTreeNode unifiedTreeNode, Resource resource) {
        if (resource.isLocal(0)) {
            this.resourceChanged(unifiedTreeNode, resource);
        } else {
            this.contentAdded(unifiedTreeNode, resource);
        }
        this.resourceChanged = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visit(UnifiedTreeNode unifiedTreeNode) throws CoreException {
        Policy.checkCanceled(this.monitor);
        try {
            Resource resource = (Resource)unifiedTreeNode.getResource();
            int n = resource.getType();
            if (n == 4) {
                return true;
            }
            if (unifiedTreeNode.existsInWorkspace() && unifiedTreeNode.existsInFileSystem()) {
                ResourceInfo resourceInfo;
                if (n == 2 && unifiedTreeNode.isFolder()) {
                    if (!resource.isLocal(0)) {
                        this.makeLocal(unifiedTreeNode, resource);
                    }
                    if ((resourceInfo = resource.getResourceInfo(false, false)) != null && resourceInfo.getModificationStamp() != -1L) {
                        return true;
                    }
                }
                if (n == 1 && !unifiedTreeNode.isFolder() && (resourceInfo = resource.getResourceInfo(false, false)) != null && resourceInfo.getModificationStamp() != -1L && resourceInfo.getLocalSyncInfo() == unifiedTreeNode.getLastModified()) {
                    return true;
                }
            } else {
                if (unifiedTreeNode.existsInFileSystem() && !Path.EMPTY.isValidSegment(unifiedTreeNode.getLocalName())) {
                    String string = NLS.bind((String)Messages.resources_invalidResourceName, (Object)unifiedTreeNode.getLocalName());
                    this.errors.merge((IStatus)new ResourceStatus(278, string));
                    return false;
                }
                int n2 = this.synchronizeExistence(unifiedTreeNode, resource);
                if (n2 == 1 || n2 == 2) {
                    if (n != 1) return true;
                    try {
                        ((File)resource).updateMetadataFiles();
                        return true;
                    }
                    catch (CoreException coreException) {
                        this.errors.merge(coreException.getStatus());
                        return true;
                    }
                }
            }
            if (this.synchronizeGender(unifiedTreeNode, resource)) {
                this.synchronizeLastModified(unifiedTreeNode, resource);
            }
            if (n != 1) return true;
            try {
                ((File)resource).updateMetadataFiles();
                return true;
            }
            catch (CoreException coreException) {
                this.errors.merge(coreException.getStatus());
                return true;
            }
        }
        finally {
            if (--this.nextProgress <= 0) {
                this.monitor.worked(1);
                ++this.worked;
                if (this.worked >= this.halfWay) {
                    this.currentIncrement *= 2;
                    this.halfWay += (250 - this.halfWay) / 2;
                }
                this.nextProgress = this.currentIncrement;
            }
        }
    }
}

