/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.internal.localstore.ILocalStoreConstants;

public class SafeChunkyInputStream
extends InputStream {
    protected static final int BUFFER_SIZE = 8192;
    protected byte[] buffer;
    protected int bufferLength = 0;
    protected byte[] chunk;
    protected int chunkLength = 0;
    protected boolean endOfFile = false;
    protected InputStream input;
    protected int nextByteInBuffer = 0;
    protected int nextByteInChunk = 0;

    public SafeChunkyInputStream(File file) throws IOException {
        this(file, 8192);
    }

    public SafeChunkyInputStream(File file, int n) throws IOException {
        this.input = new FileInputStream(file);
        this.buffer = new byte[n];
    }

    protected void accumulate(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[this.chunk.length + n2 - n];
        System.arraycopy(this.chunk, 0, byArray2, 0, this.chunk.length);
        System.arraycopy(byArray, n, byArray2, this.chunk.length, n2 - n);
        this.chunk = byArray2;
        this.chunkLength = this.chunkLength + n2 - n;
    }

    public int available() throws IOException {
        return this.chunkLength - this.nextByteInChunk;
    }

    protected void buildChunk() throws IOException {
        do {
            int n;
            if (this.nextByteInBuffer + ILocalStoreConstants.CHUNK_DELIMITER_SIZE > this.bufferLength) {
                this.shiftAndFillBuffer();
            }
            if ((n = this.find(ILocalStoreConstants.END_CHUNK, this.nextByteInBuffer, this.bufferLength, true)) != -1) {
                this.accumulate(this.buffer, this.nextByteInBuffer, n);
                this.nextByteInBuffer = n + ILocalStoreConstants.CHUNK_DELIMITER_SIZE;
                return;
            }
            this.accumulate(this.buffer, this.nextByteInBuffer, this.bufferLength);
            this.bufferLength = this.input.read(this.buffer);
            this.nextByteInBuffer = 0;
        } while (this.bufferLength != -1);
        this.endOfFile = true;
    }

    public void close() throws IOException {
        this.input.close();
    }

    protected boolean compare(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        while (n2 < byArray2.length) {
            if (byArray[n] != byArray2[n2]) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    protected int find(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        int n3 = this.findByte(byArray[0], n, n2);
        if (n3 == -1) {
            return -1;
        }
        if (n3 + ILocalStoreConstants.CHUNK_DELIMITER_SIZE > this.bufferLength) {
            if (bl) {
                this.accumulate(this.buffer, this.nextByteInBuffer, n3);
            }
            this.nextByteInBuffer = n3;
            n3 = 0;
            this.shiftAndFillBuffer();
        }
        if (this.compare(this.buffer, byArray, n3)) {
            return n3;
        }
        return this.find(byArray, n3 + 1, n2, bl);
    }

    protected int findByte(byte by, int n, int n2) {
        while (n < n2) {
            if (this.buffer[n] == by) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected void findChunkStart() throws IOException {
        int n;
        if (this.nextByteInBuffer + ILocalStoreConstants.CHUNK_DELIMITER_SIZE > this.bufferLength) {
            this.shiftAndFillBuffer();
        }
        if ((n = this.find(ILocalStoreConstants.BEGIN_CHUNK, this.nextByteInBuffer, this.bufferLength, false)) != -1) {
            this.nextByteInBuffer = n + ILocalStoreConstants.CHUNK_DELIMITER_SIZE;
            return;
        }
        this.bufferLength = this.input.read(this.buffer);
        this.nextByteInBuffer = 0;
        if (this.bufferLength == -1) {
            this.resetChunk();
            this.endOfFile = true;
            return;
        }
        this.findChunkStart();
    }

    public int read() throws IOException {
        if (this.endOfFile) {
            return -1;
        }
        if (this.nextByteInChunk < this.chunkLength) {
            return this.chunk[this.nextByteInChunk++] & 0xFF;
        }
        this.resetChunk();
        this.findChunkStart();
        if (this.endOfFile) {
            return -1;
        }
        this.buildChunk();
        this.refineChunk();
        return this.read();
    }

    protected void refineChunk() {
        int n = this.chunkLength - ILocalStoreConstants.CHUNK_DELIMITER_SIZE;
        if (n < 0) {
            return;
        }
        int n2 = n;
        while (n2 >= 0) {
            if (this.compare(this.chunk, ILocalStoreConstants.BEGIN_CHUNK, n2)) {
                this.nextByteInChunk = n2 + ILocalStoreConstants.CHUNK_DELIMITER_SIZE;
                return;
            }
            --n2;
        }
    }

    protected void resetChunk() {
        this.chunk = new byte[0];
        this.chunkLength = 0;
        this.nextByteInChunk = 0;
    }

    protected void shiftAndFillBuffer() throws IOException {
        int n = this.bufferLength - this.nextByteInBuffer;
        System.arraycopy(this.buffer, this.nextByteInBuffer, this.buffer, 0, n);
        this.nextByteInBuffer = 0;
        this.bufferLength = n;
        int n2 = this.input.read(this.buffer, this.bufferLength, this.buffer.length - this.bufferLength);
        if (n2 != -1) {
            this.bufferLength += n2;
        } else {
            this.resetChunk();
            this.endOfFile = true;
        }
    }
}

